/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.parsing;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.tsl.function.LOTLSigningCertificatesAnnouncementSchemeInformationURI;
import eu.europa.esig.dss.tsl.function.PivotSchemeInformationURI;
import eu.europa.esig.dss.tsl.function.converter.OtherTSLPointerConverter;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingTask;
import eu.europa.esig.dss.tsl.parsing.LOTLParsingResult;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.trustedlist.TrustedListFacade;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIListType;
import eu.europa.esig.trustedlist.jaxb.tsl.NonEmptyMultiLangURIType;
import eu.europa.esig.trustedlist.jaxb.tsl.OtherTSLPointersType;
import eu.europa.esig.trustedlist.jaxb.tsl.TSLSchemeInformationType;
import eu.europa.esig.trustedlist.jaxb.tsl.TrustStatusListType;
import eu.europa.esig.trustedlist.mra.MRAFacade;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LOTLParsingTask
extends AbstractParsingTask<LOTLParsingResult> {
    private static final Logger LOG = LoggerFactory.getLogger(LOTLParsingTask.class);
    private final LOTLSource lotlSource;

    public LOTLParsingTask(DSSDocument document, LOTLSource lotlSource) {
        super(document);
        Objects.requireNonNull(lotlSource, "The LOTLSource is null");
        this.lotlSource = lotlSource;
    }

    @Override
    public LOTLParsingResult get() {
        LOTLParsingResult result = new LOTLParsingResult();
        TrustStatusListType jaxbObject = this.getJAXBObject();
        this.parseSchemeInformation(result, jaxbObject.getSchemeInformation());
        return result;
    }

    private void parseSchemeInformation(LOTLParsingResult result, TSLSchemeInformationType schemeInformation) {
        this.commonParseSchemeInformation(result, schemeInformation);
        this.extractOtherTSLPointers(result, schemeInformation);
        this.extractSchemeInformationURI(result, schemeInformation);
    }

    private void extractOtherTSLPointers(LOTLParsingResult result, TSLSchemeInformationType schemeInformation) {
        OtherTSLPointersType otherTSLPointersType = schemeInformation.getPointersToOtherTSL();
        if (otherTSLPointersType != null && Utils.isCollectionNotEmpty((Collection)otherTSLPointersType.getOtherTSLPointer())) {
            List otherTSLPointers = otherTSLPointersType.getOtherTSLPointer();
            OtherTSLPointerConverter converter = new OtherTSLPointerConverter(this.lotlSource.isMraSupport());
            result.setLotlPointers(otherTSLPointers.stream().filter(this.lotlSource.getLotlPredicate()).map(converter).collect(Collectors.toList()));
            result.setTlPointers(otherTSLPointers.stream().filter(this.lotlSource.getTlPredicate()).map(converter).collect(Collectors.toList()));
        }
    }

    private void extractSchemeInformationURI(LOTLParsingResult result, TSLSchemeInformationType schemeInformation) {
        NonEmptyMultiLangURIListType schemeInformationURI = schemeInformation.getSchemeInformationURI();
        if (schemeInformationURI != null) {
            this.extractSigningCertificatesAnnouncementURL(result, schemeInformationURI);
            this.extractPivotURLs(result, schemeInformationURI);
        }
    }

    private void extractSigningCertificatesAnnouncementURL(LOTLParsingResult result, NonEmptyMultiLangURIListType schemeInformationURI) {
        List uris;
        LOTLSigningCertificatesAnnouncementSchemeInformationURI signingCertificatesAnnouncementPredicate = this.lotlSource.getSigningCertificatesAnnouncementPredicate();
        if (signingCertificatesAnnouncementPredicate != null && Utils.isCollectionNotEmpty(uris = schemeInformationURI.getURI().stream().filter(signingCertificatesAnnouncementPredicate).map(NonEmptyMultiLangURIType::getValue).collect(Collectors.toList()))) {
            if (uris.size() > 1) {
                LOG.warn("More than 1 LOTLSigningCertificatesAnnouncement URI found (returns the first entry) : {}", uris);
            }
            result.setSigningCertificateAnnouncementURL((String)uris.get(0));
        }
    }

    private void extractPivotURLs(LOTLParsingResult result, NonEmptyMultiLangURIListType schemeInformationURI) {
        if (this.lotlSource.isPivotSupport()) {
            List<String> uris = schemeInformationURI.getURI().stream().filter(new PivotSchemeInformationURI()).map(NonEmptyMultiLangURIType::getValue).collect(Collectors.toList());
            result.setPivotURLs(uris);
        }
    }

    @Override
    protected TrustedListFacade createTrustedListFacade() {
        if (this.lotlSource.isMraSupport()) {
            return MRAFacade.newFacade();
        }
        return super.createTrustedListFacade();
    }
}

