/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.parsing.AbstractParsingTask;
import eu.europa.esig.dss.tsl.parsing.LOTLParsingTask;
import eu.europa.esig.dss.tsl.parsing.ParsingUtils;
import eu.europa.esig.dss.tsl.runnable.AbstractAnalysis;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResult;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import java.util.concurrent.Callable;

public class PivotProcessing
extends AbstractAnalysis
implements Callable<PivotProcessingResult> {
    private final CacheAccessByKey lotlCacheAccess;

    public PivotProcessing(LOTLSource pivotSource, CacheAccessByKey pivotCacheAccess, CacheAccessByKey lotlCacheAccess, DSSFileLoader dssFileLoader) {
        super(pivotSource, pivotCacheAccess, dssFileLoader);
        this.lotlCacheAccess = lotlCacheAccess;
    }

    @Override
    public PivotProcessingResult call() throws Exception {
        DSSDocument pivot = this.download(this.getSource().getUrl());
        if (pivot != null) {
            this.parsing(pivot);
            ParsingCacheDTO parsingResult = this.getCacheAccessByKey().getParsingReadOnlyResult();
            OtherTSLPointer xmllotlPointer = ParsingUtils.getXMLLOTLPointer(parsingResult);
            if (xmllotlPointer != null) {
                return new PivotProcessingResult(pivot, this.getLOTLAnnouncedCertificateSource(xmllotlPointer), xmllotlPointer.getTSLLocation());
            }
        }
        return null;
    }

    @Override
    protected AbstractParsingTask<?> getParsingTask(DSSDocument document) {
        return new LOTLParsingTask(document, (LOTLSource)this.getSource());
    }

    private CertificateSource getLOTLAnnouncedCertificateSource(OtherTSLPointer currentLOTLPointer) {
        CommonCertificateSource certificateSource = new CommonCertificateSource();
        for (CertificateToken certificate : currentLOTLPointer.getSdiCertificates()) {
            certificateSource.addCertificate(certificate);
        }
        return certificateSource;
    }

    @Override
    protected void expireCache() {
        super.expireCache();
        this.lotlCacheAccess.expireValidation();
    }
}

