/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.alerts;

import eu.europa.esig.dss.alert.Alert;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TLValidationJobSummary;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLValidationJobAlerter {
    private static final Logger LOG = LoggerFactory.getLogger(TLValidationJobAlerter.class);
    private final List<Alert<LOTLInfo>> lotlAlerts;
    private final List<Alert<TLInfo>> tlAlerts;

    public TLValidationJobAlerter(List<Alert<LOTLInfo>> lotlAlerts, List<Alert<TLInfo>> tlAlerts) {
        this.lotlAlerts = lotlAlerts;
        this.tlAlerts = tlAlerts;
    }

    public void detectChanges(TLValidationJobSummary jobSummary) {
        for (LOTLInfo lotlInfo : jobSummary.getLOTLInfos()) {
            if (Utils.isCollectionNotEmpty(this.lotlAlerts)) {
                for (Alert<LOTLInfo> alert : this.lotlAlerts) {
                    this.execute(alert, lotlInfo);
                }
            }
            if (!Utils.isCollectionNotEmpty(this.tlAlerts)) continue;
            for (TLInfo tLInfo : lotlInfo.getTLInfos()) {
                for (Alert<TLInfo> tlAlert : this.tlAlerts) {
                    this.execute(tlAlert, tLInfo);
                }
            }
        }
        if (Utils.isCollectionNotEmpty(this.tlAlerts)) {
            for (TLInfo tlInfo : jobSummary.getOtherTLInfos()) {
                for (Alert alert : this.tlAlerts) {
                    this.execute(alert, tlInfo);
                }
            }
        }
    }

    private <T extends TLInfo> void execute(Alert<T> alert, T info) {
        try {
            alert.alert(info);
        }
        catch (Exception e) {
            LOG.warn("An error occurred while trying to detect changes inside '{}'. Reason : {}", (Object)info.getDSSId().asXmlId(), (Object)e.getMessage());
        }
    }
}

