/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessFactory;
import eu.europa.esig.dss.tsl.cache.access.ReadOnlyCacheAccess;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.dto.ValidationCacheDTO;
import eu.europa.esig.dss.tsl.runnable.LOTLAnalysis;
import eu.europa.esig.dss.tsl.runnable.PivotProcessing;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResult;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResultFromCacheAccessBuilder;
import eu.europa.esig.dss.tsl.sha2.Sha2FileCacheDataLoader;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.validation.TLValidatorTask;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LOTLWithPivotsAnalysis
extends LOTLAnalysis {
    private static final Logger LOG = LoggerFactory.getLogger(LOTLWithPivotsAnalysis.class);
    private final CacheAccessFactory cacheAccessFactory;
    private final DSSFileLoader dssFileLoader;

    public LOTLWithPivotsAnalysis(LOTLSource source, CacheAccessByKey cacheAccess, DSSFileLoader dssFileLoader, CacheAccessFactory cacheAccessFactory, CountDownLatch latch) {
        super(source, cacheAccess, dssFileLoader, latch);
        this.cacheAccessFactory = cacheAccessFactory;
        this.dssFileLoader = dssFileLoader;
    }

    @Override
    protected CertificateSource getCurrentCertificateSource() {
        CertificateSource currentCertificateSource;
        CertificateSource initialCertificateSource = super.getCurrentCertificateSource();
        ParsingCacheDTO currentLOTLParsing = this.getCacheAccessByKey().getParsingReadOnlyResult();
        if (currentLOTLParsing != null) {
            List<String> pivotURLs = currentLOTLParsing.getPivotUrls();
            if (Utils.isCollectionEmpty(pivotURLs)) {
                LOG.trace("No pivot LOTL found");
                currentCertificateSource = initialCertificateSource;
            } else {
                currentCertificateSource = this.getCurrentCertificateSourceFromPivots(initialCertificateSource, pivotURLs);
            }
        } else {
            LOG.warn("Unable to retrieve the parsing result for the current LOTL (allowed signing certificates set from the configuration)");
            currentCertificateSource = initialCertificateSource;
        }
        return currentCertificateSource;
    }

    private CertificateSource getCurrentCertificateSourceFromPivots(CertificateSource initialCertificateSource, List<String> pivotURLs) {
        Map<String, PivotProcessingResult> processingResults = this.downloadAndParseAllPivots(pivotURLs);
        ReadOnlyCacheAccess readOnlyCacheAccess = this.cacheAccessFactory.getReadOnlyCacheAccess();
        List pivotUrlsReversed = Utils.reverseList(pivotURLs);
        CertificateSource currentCertificateSource = initialCertificateSource;
        for (String pivotUrl : pivotUrlsReversed) {
            CacheKey cacheKey = new CacheKey(pivotUrl);
            PivotProcessingResult pivotProcessingResult = processingResults.get(pivotUrl);
            if (pivotProcessingResult != null) {
                CacheAccessByKey pivotCacheAccess = this.cacheAccessFactory.getCacheAccess(cacheKey);
                this.validationPivot(pivotCacheAccess, pivotProcessingResult.getPivot(), currentCertificateSource);
                ValidationCacheDTO validationResult = readOnlyCacheAccess.getValidationCacheDTO(cacheKey);
                if (validationResult != null) {
                    if (validationResult.isValid()) {
                        currentCertificateSource = pivotProcessingResult.getCertificateSource();
                        continue;
                    }
                    LOG.warn("Pivot LOTL '{}' is not valid ({}/{})", new Object[]{pivotUrl, validationResult.getIndication(), validationResult.getSubIndication()});
                    continue;
                }
                LOG.warn("No validation result found for Pivot LOTL '{}'", (Object)pivotUrl);
                continue;
            }
            LOG.warn("No processing result for Pivot LOTL '{}'", (Object)pivotUrl);
        }
        return currentCertificateSource;
    }

    private void validationPivot(CacheAccessByKey pivotCacheAccess, DSSDocument document, CertificateSource certificateSource) {
        if (pivotCacheAccess.isValidationRefreshNeeded()) {
            try {
                LOG.debug("Validating the Pivot LOTL with cache key '{}'...", (Object)pivotCacheAccess.getCacheKey().getKey());
                TLValidatorTask validationTask = new TLValidatorTask(document, certificateSource);
                pivotCacheAccess.update(validationTask.get());
            }
            catch (Exception e) {
                LOG.warn("Cannot validate the Pivot LOTL with the cache key '{}' : {}", (Object)pivotCacheAccess.getCacheKey().getKey(), (Object)e.getMessage());
                this.assertOriginalDocumentIsAccessible(pivotCacheAccess);
                pivotCacheAccess.validationError(e);
            }
        }
    }

    private void assertOriginalDocumentIsAccessible(CacheAccessByKey pivotCacheAccess) {
        try {
            if (pivotCacheAccess.getDownloadReadOnlyResult() != null && DSSUtils.isEmpty((DSSDocument)pivotCacheAccess.getDownloadReadOnlyResult().getDocument())) {
                LOG.warn("The Pivot LOTL with the cache key '{}' contains empty content", (Object)pivotCacheAccess.getCacheKey().getKey());
                throw new DSSException("Empty content file is obtained!");
            }
        }
        catch (Exception e) {
            LOG.warn("The Pivot LOTL with the cache key '{}' contains empty content : {}", (Object)pivotCacheAccess.getCacheKey().getKey(), (Object)e.getMessage());
            pivotCacheAccess.downloadError(e);
            pivotCacheAccess.parsingError(e);
        }
    }

    private Map<String, PivotProcessingResult> downloadAndParseAllPivots(List<String> pivotURLs) {
        HashMap<String, PivotProcessingResult> processingResults = new HashMap<String, PivotProcessingResult>();
        LOTLSource lotlSource = (LOTLSource)this.getSource();
        CacheAccessByKey lotlCacheAccessByKey = this.getCacheAccessByKey();
        HashMap<String, PivotProcessing> pivotProcessingMap = new HashMap<String, PivotProcessing>();
        ArrayList<CacheAccessByKey> pivotCacheAccessByKeyList = new ArrayList<CacheAccessByKey>();
        for (String pivotUrl : pivotURLs) {
            CacheAccessByKey pivotCacheAccess = this.cacheAccessFactory.getCacheAccess(new CacheKey(pivotUrl));
            if (lotlCacheAccessByKey.isValidationRefreshNeeded() || pivotCacheAccess.isValidationRefreshNeeded() || !pivotCacheAccess.getDownloadReadOnlyResult().isResultExist()) {
                LOTLSource pivotSource = new LOTLSource();
                pivotSource.setUrl(pivotUrl);
                pivotSource.setLotlPredicate(lotlSource.getLotlPredicate());
                pivotSource.setTlPredicate(lotlSource.getTlPredicate());
                pivotSource.setPivotSupport(lotlSource.isPivotSupport());
                DSSFileLoader dataLoader = this.dssFileLoader instanceof Sha2FileCacheDataLoader ? ((Sha2FileCacheDataLoader)this.dssFileLoader).getDataLoader() : this.dssFileLoader;
                pivotProcessingMap.put(pivotUrl, new PivotProcessing(pivotSource, pivotCacheAccess, this.getCacheAccessByKey(), new ArrayList<CacheAccessByKey>(pivotCacheAccessByKeyList), dataLoader));
            } else {
                processingResults.put(pivotUrl, new PivotProcessingResultFromCacheAccessBuilder(pivotCacheAccess).build());
            }
            pivotCacheAccessByKeyList.add(pivotCacheAccess);
        }
        if (Utils.isMapNotEmpty(pivotProcessingMap)) {
            ExecutorService executorService = Executors.newFixedThreadPool(pivotProcessingMap.size());
            HashMap futures = new HashMap();
            for (Map.Entry processing : pivotProcessingMap.entrySet()) {
                futures.put((String)processing.getKey(), executorService.submit((Callable)processing.getValue()));
            }
            for (Map.Entry entry : futures.entrySet()) {
                try {
                    processingResults.put((String)entry.getKey(), (PivotProcessingResult)((Future)entry.getValue()).get());
                }
                catch (InterruptedException e) {
                    LOG.error(String.format("Unable to retrieve the PivotProcessingResult for url '%s'", entry.getKey()), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.error(String.format("Unable to retrieve the PivotProcessingResult for url '%s'", entry.getKey()), (Throwable)e);
                }
            }
            this.shutdownAndAwaitTermination(executorService);
        }
        return processingResults;
    }

    private void shutdownAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.shutdownNowAndAwaitTermination(executorService);
            }
        }
        catch (InterruptedException e) {
            this.shutdownNowAndAwaitTermination(executorService);
            Thread.currentThread().interrupt();
        }
    }

    private void shutdownNowAndAwaitTermination(ExecutorService executorService) {
        executorService.shutdownNow();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.warn("More than 10s to terminate the service executor");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Unable to interrupt the service executor", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

