/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sha2;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.tsl.sha2.DocumentWithSha2;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import eu.europa.esig.trustedlist.definition.TrustedListNamespace;
import java.util.Date;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractTrustedListWithSha2Predicate
implements Predicate<DocumentWithSha2> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTrustedListWithSha2Predicate.class);
    protected static final DigestAlgorithm SHA2_ALGORITHM = DigestAlgorithm.SHA256;
    protected static final String NEXT_UPDATE_PATH = "./tl:SchemeInformation/tl:NextUpdate";

    protected AbstractTrustedListWithSha2Predicate() {
    }

    @Override
    public abstract boolean test(DocumentWithSha2 var1);

    protected Digest getOriginalDocumentDigest(DSSDocument document) {
        if (document == null) {
            return null;
        }
        byte[] digest = document.getDigestValue(SHA2_ALGORITHM);
        return new Digest(SHA2_ALGORITHM, digest);
    }

    protected Digest getSha2Digest(DSSDocument sha2Document) {
        if (sha2Document == null) {
            return null;
        }
        byte[] sha2DocumentBinaries = DSSUtils.toByteArray((DSSDocument)sha2Document);
        String sha2DocumentStr = new String(sha2DocumentBinaries);
        if (Utils.isHexEncoded((String)sha2DocumentStr)) {
            sha2DocumentBinaries = Utils.fromHex((String)sha2DocumentStr);
        }
        return new Digest(SHA2_ALGORITHM, sha2DocumentBinaries);
    }

    protected Date getNextUpdate(DSSDocument tlDocument) {
        if (!DomUtils.isDOM((DSSDocument)tlDocument)) {
            LOG.warn("The document is not XML! Unable to extract NextUpdate.");
        }
        try {
            Document documentDom = DomUtils.buildDOM((DSSDocument)tlDocument);
            Element nextUpdateElement = DomUtils.getElement((Node)documentDom.getDocumentElement(), (String)NEXT_UPDATE_PATH);
            if (nextUpdateElement != null) {
                String nextUpdate = nextUpdateElement.getTextContent();
                if (Utils.isStringNotEmpty((String)nextUpdate)) {
                    nextUpdate = Utils.trim((String)nextUpdate);
                    return DSSUtils.parseRFCDate((String)nextUpdate);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("NextUpdate element has an empty content.");
                }
            } else {
                LOG.warn("No NextUpdate element found!");
            }
        }
        catch (Exception e) {
            String errorMessage = "An error occurred on NextUpdate extraction. Reason : {}";
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Object)e.getMessage(), (Object)e);
            }
            LOG.warn(errorMessage, (Object)e.getMessage());
        }
        return null;
    }

    static {
        DomUtils.registerNamespace((DSSNamespace)TrustedListNamespace.NS);
    }
}

