/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache;

import eu.europa.esig.dss.tsl.cache.AbstractCache;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.cache.CacheType;
import eu.europa.esig.dss.tsl.cache.state.CacheStateEnum;
import eu.europa.esig.dss.tsl.cache.state.CachedEntry;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import eu.europa.esig.dss.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCache
extends AbstractCache<XmlDownloadResult> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadCache.class);

    public boolean isUpToDate(CacheKey cacheKey, XmlDownloadResult downloadedResult) {
        LOG.trace("Extracting cached file for the key [{}]...", (Object)cacheKey);
        if (this.isToBeDeleted(cacheKey)) {
            LOG.warn("Update requested for a {} entry with the key [{}]! Force update.", (Object)CacheStateEnum.TO_BE_DELETED, (Object)cacheKey);
            return false;
        }
        CachedEntry cachedFileEntry = this.get(cacheKey);
        if (!cachedFileEntry.isEmpty()) {
            XmlDownloadResult cachedResult = (XmlDownloadResult)cachedFileEntry.getCachedResult();
            LOG.trace("Comparing digest of the stored file [{}] with the downloaded file [{}]", (Object)cachedResult.getDigest(), (Object)downloadedResult.getDigest());
            boolean digestMatch = cachedResult.getDigest().equals((Object)downloadedResult.getDigest());
            boolean sha2ContentMatch = this.isSHA2ContentMatch(cachedResult, downloadedResult);
            boolean upToDate = digestMatch && sha2ContentMatch;
            LOG.trace("Is file with the key [{}] up to date ? {}", (Object)cacheKey, (Object)upToDate);
            if (upToDate) {
                cachedFileEntry.syncUpdateDate();
            }
            return upToDate;
        }
        LOG.trace("The FileCache does not contain a file result for the key [{}]!", (Object)cacheKey);
        return false;
    }

    private boolean isSHA2ContentMatch(XmlDownloadResult cachedResult, XmlDownloadResult downloadedResult) {
        return Utils.isCollectionEmpty(cachedResult.getSha2ErrorMessages()) && Utils.isCollectionEmpty(downloadedResult.getSha2ErrorMessages()) || Utils.isCollectionEmpty(cachedResult.getSha2ErrorMessages()) && cachedResult.getSha2ErrorMessages().equals(downloadedResult.getSha2ErrorMessages());
    }

    @Override
    protected CacheType getCacheType() {
        return CacheType.DOWNLOAD;
    }
}

