/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.sha2;

import eu.europa.esig.dss.model.CommonDocument;
import eu.europa.esig.dss.model.DSSDocument;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentWithSha2
extends CommonDocument {
    private static final long serialVersionUID = -6370847348735932510L;
    private final DSSDocument document;
    private final DSSDocument sha2Document;
    private List<String> errors;

    protected DocumentWithSha2(DSSDocument document, DSSDocument sha2Document) {
        this.document = document;
        this.sha2Document = sha2Document;
    }

    public DSSDocument getDocument() {
        return this.document;
    }

    public DSSDocument getSha2Document() {
        return this.sha2Document;
    }

    protected void addErrorMessage(String errorMessage) {
        this.getErrors().add(errorMessage);
    }

    public List<String> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        return this.errors;
    }

    public InputStream openStream() {
        Objects.requireNonNull(this.document, "Document is null! Unable to open InputStream.");
        return this.document.openStream();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DocumentWithSha2 that = (DocumentWithSha2)((Object)object);
        return Objects.equals(this.document, that.document) && Objects.equals(this.sha2Document, that.sha2Document) && Objects.equals(this.errors, that.errors);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.document);
        result = 31 * result + Objects.hashCode(this.sha2Document);
        result = 31 * result + Objects.hashCode(this.errors);
        return result;
    }
}

