/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.download;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.client.http.DSSFileLoader;
import eu.europa.esig.dss.tsl.download.XmlDownloadResult;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Supplier;

public class XmlDownloadTask
implements Supplier<XmlDownloadResult> {
    private static final DigestAlgorithm DEFAULT_DIGEST_ALGORITHM = DigestAlgorithm.SHA256;
    private static final String DEFAULT_CANONICALIZATION_METHOD = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private final DSSFileLoader dssFileLoader;
    private final String url;

    public XmlDownloadTask(DSSFileLoader dssFileLoader, String url) {
        Objects.requireNonNull(dssFileLoader, "The DSSFileLoader is null");
        Objects.requireNonNull(url, "The url is null");
        this.dssFileLoader = dssFileLoader;
        this.url = url;
    }

    @Override
    public XmlDownloadResult get() {
        try {
            DSSDocument dssDocument = this.dssFileLoader.getDocument(this.url);
            this.assertDocumentIsValidXML(dssDocument);
            DSSMessageDigest digest = DSSXMLUtils.getDigestOnCanonicalizedInputStream((InputStream)dssDocument.openStream(), (DigestAlgorithm)DEFAULT_DIGEST_ALGORITHM, (String)DEFAULT_CANONICALIZATION_METHOD);
            return new XmlDownloadResult(dssDocument, (Digest)digest);
        }
        catch (DSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSSException(String.format("Unable to retrieve the content for url '%s'. Reason : '%s'", this.url, e.getMessage()), (Throwable)e);
        }
    }

    private void assertDocumentIsValidXML(DSSDocument document) {
        if (document == null) {
            throw new NullPointerException(String.format("No document has been retrieved from URL '%s'!", this.url));
        }
        if (!DomUtils.isDOM((DSSDocument)document)) {
            throw new DSSException(String.format("The document obtained from URL '%s' is not a valid XML!", this.url));
        }
    }
}

