/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.runnable;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.tsl.OtherTSLPointer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.tsl.cache.access.CacheAccessByKey;
import eu.europa.esig.dss.tsl.parsing.ParsingUtils;
import eu.europa.esig.dss.tsl.runnable.PivotProcessingResult;

public class PivotProcessingResultFromCacheAccessBuilder {
    private final CacheAccessByKey cacheAccessByKey;

    public PivotProcessingResultFromCacheAccessBuilder(CacheAccessByKey cacheAccessByKey) {
        this.cacheAccessByKey = cacheAccessByKey;
    }

    public PivotProcessingResult build() {
        OtherTSLPointer xmlLotlPointer = ParsingUtils.getXMLLOTLPointer(this.cacheAccessByKey.getParsingReadOnlyResult());
        return new PivotProcessingResult(this.getDocument(), this.getCertificateSource(xmlLotlPointer), this.getLotlLocation(xmlLotlPointer));
    }

    private DSSDocument getDocument() {
        if (this.cacheAccessByKey.getDownloadReadOnlyResult() != null) {
            return this.cacheAccessByKey.getDownloadReadOnlyResult().getDocument();
        }
        return null;
    }

    private CertificateSource getCertificateSource(OtherTSLPointer xmlLotlPointer) {
        if (xmlLotlPointer != null) {
            return ParsingUtils.getLOTLAnnouncedCertificateSource(xmlLotlPointer);
        }
        return null;
    }

    private String getLotlLocation(OtherTSLPointer xmlLotlPointer) {
        if (xmlLotlPointer != null) {
            return xmlLotlPointer.getTSLLocation();
        }
        return null;
    }
}

