/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.utils.apache.impl;

import eu.europa.esig.dss.utils.IUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ApacheCommonsUtils
implements IUtils {
    public boolean isStringEmpty(String text) {
        return StringUtils.isEmpty((CharSequence)text);
    }

    public boolean isStringNotEmpty(String text) {
        return StringUtils.isNotEmpty((CharSequence)text);
    }

    public boolean isStringBlank(String text) {
        return StringUtils.isBlank((CharSequence)text);
    }

    public boolean isStringNotBlank(String text) {
        return StringUtils.isNotBlank((CharSequence)text);
    }

    public boolean areStringsEqual(String text1, String text2) {
        return StringUtils.equals((CharSequence)text1, (CharSequence)text2);
    }

    public boolean areStringsEqualIgnoreCase(String text1, String text2) {
        return StringUtils.equalsIgnoreCase((CharSequence)text1, (CharSequence)text2);
    }

    public boolean isStringDigits(String text) {
        return NumberUtils.isDigits((String)text);
    }

    public String trim(String text) {
        return StringUtils.trim((String)text);
    }

    public String joinStrings(Collection<String> strings, String separator) {
        return StringUtils.join(strings, (String)separator);
    }

    public byte[] concat(byte[] ... byteArrays) {
        if (byteArrays.length == 0) {
            return new byte[0];
        }
        byte[] result = new byte[]{};
        for (byte[] byteArray : byteArrays) {
            Objects.requireNonNull(byteArray, "ByteArray is null!");
            result = ArrayUtils.addAll((byte[])result, (byte[])byteArray);
        }
        return result;
    }

    public String substringAfter(String text, String after) {
        return StringUtils.substringAfter((String)text, (String)after);
    }

    public boolean endsWithIgnoreCase(String text, String expected) {
        return StringUtils.endsWithIgnoreCase((CharSequence)text, (CharSequence)expected);
    }

    public String getFileNameExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public String lowerCase(String text) {
        return StringUtils.lowerCase((String)text);
    }

    public String upperCase(String text) {
        return StringUtils.upperCase((String)text);
    }

    public boolean isArrayEmpty(Object[] array) {
        return ArrayUtils.isEmpty((Object[])array);
    }

    public boolean isArrayNotEmpty(Object[] array) {
        return ArrayUtils.isNotEmpty((Object[])array);
    }

    public int arraySize(Object[] array) {
        return ArrayUtils.getLength((Object)array);
    }

    public boolean isArrayEmpty(byte[] array) {
        return ArrayUtils.isEmpty((byte[])array);
    }

    public boolean isArrayNotEmpty(byte[] array) {
        return ArrayUtils.isNotEmpty((byte[])array);
    }

    public int arraySize(byte[] array) {
        return ArrayUtils.getLength((Object)array);
    }

    public boolean isArrayEmpty(char[] array) {
        return ArrayUtils.isEmpty((char[])array);
    }

    public boolean isArrayNotEmpty(char[] array) {
        return ArrayUtils.isNotEmpty((char[])array);
    }

    public int arraySize(char[] array) {
        return ArrayUtils.getLength((Object)array);
    }

    public byte[] subarray(byte[] array, int start, int length) {
        return ArrayUtils.subarray((byte[])array, (int)start, (int)length);
    }

    public boolean isTrue(Boolean bool) {
        return BooleanUtils.isTrue((Boolean)bool);
    }

    public boolean isCollectionEmpty(Collection collection) {
        return CollectionUtils.isEmpty((Collection)collection);
    }

    public boolean isCollectionNotEmpty(Collection collection) {
        return CollectionUtils.isNotEmpty((Collection)collection);
    }

    public boolean isMapEmpty(Map<?, ?> map) {
        return MapUtils.isEmpty(map);
    }

    public boolean isMapNotEmpty(Map<?, ?> map) {
        return MapUtils.isNotEmpty(map);
    }

    public int collectionSize(Collection collection) {
        return CollectionUtils.size((Object)collection);
    }

    public boolean isHexEncoded(String hexString) {
        Objects.requireNonNull(hexString, "String cannot be null");
        try {
            Hex.decodeHex((String)hexString);
            return true;
        }
        catch (DecoderException e) {
            return false;
        }
    }

    public String toHex(byte[] bytes) {
        Objects.requireNonNull(bytes, "Bytes cannot be null");
        return Hex.encodeHexString((byte[])bytes);
    }

    public byte[] fromHex(String hex) {
        Objects.requireNonNull(hex, "Hex cannot be null");
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Unable to extract binary from Hex", e);
        }
    }

    public boolean isBase64Encoded(String base64String) {
        return Base64.isBase64((String)base64String);
    }

    public String toBase64(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public byte[] fromBase64(String base64) {
        return Base64.decodeBase64((String)base64);
    }

    public byte[] toByteArray(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void copy(InputStream is, OutputStream os) throws IOException {
        IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    public void write(byte[] content, OutputStream os) throws IOException {
        IOUtils.write((byte[])content, (OutputStream)os);
    }

    public long getInputStreamSize(InputStream is) throws IOException {
        int nRead;
        long byteCounter = 0L;
        byte[] data = new byte[8192];
        while ((nRead = IOUtils.read((InputStream)is, (byte[])data)) > 0) {
            byteCounter += (long)nRead;
        }
        return byteCounter;
    }

    public boolean compareInputStreams(InputStream stream1, InputStream stream2) throws IOException {
        return IOUtils.contentEquals((InputStream)stream1, (InputStream)stream2);
    }

    public boolean startsWith(byte[] byteArray, byte[] prefixArray) {
        if (byteArray == null || prefixArray == null) {
            return false;
        }
        if (ArrayUtils.getLength((Object)byteArray) >= ArrayUtils.getLength((Object)prefixArray)) {
            for (int i = 0; i < prefixArray.length; ++i) {
                if (byteArray[i] == prefixArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean startsWith(InputStream inputStream, byte[] prefixArray) throws IOException {
        if (inputStream == null || prefixArray == null) {
            return false;
        }
        byte[] temp = new byte[prefixArray.length];
        IOUtils.read((InputStream)inputStream, (byte[])temp);
        return Arrays.equals(prefixArray, temp);
    }

    public void cleanDirectory(File directory) throws IOException {
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public Collection<File> listFiles(File folder, String[] extensions, boolean recursive) {
        return FileUtils.listFiles((File)folder, (String[])extensions, (boolean)recursive);
    }

    public <T> List<T> reverseList(List<T> list) {
        ArrayList<T> reverse = new ArrayList<T>(list);
        Collections.reverse(reverse);
        return reverse;
    }

    public <T> boolean containsAny(Collection<T> superCollection, Collection<T> subCollection) {
        return CollectionUtils.containsAny(superCollection, subCollection);
    }
}

