/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.identifier.TokenIdentifierProvider;
import eu.europa.esig.dss.policy.EtsiValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.ValidationPolicyFacade;
import eu.europa.esig.dss.policy.jaxb.ConstraintsParameters;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.policy.SignaturePolicyProvider;
import eu.europa.esig.dss.spi.policy.SignaturePolicyValidatorLoader;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationContext;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.spi.validation.analyzer.DefaultDocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.DocumentAnalyzer;
import eu.europa.esig.dss.spi.validation.executor.SkipValidationContextExecutor;
import eu.europa.esig.dss.spi.validation.executor.ValidationContextExecutor;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.DocumentValidatorFactory;
import eu.europa.esig.dss.validation.executor.DocumentProcessExecutor;
import eu.europa.esig.dss.validation.executor.signature.DefaultSignatureProcessExecutor;
import eu.europa.esig.dss.validation.reports.Reports;
import eu.europa.esig.dss.validation.reports.diagnostic.SignedDocumentDiagnosticDataBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlDiagnosticDataFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignedDocumentValidator
implements DocumentValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedDocumentValidator.class);
    protected final DocumentAnalyzer documentAnalyzer;
    protected DocumentProcessExecutor processExecutor = null;
    private DigestAlgorithm defaultDigestAlgorithm = DigestAlgorithm.SHA256;
    private TokenExtractionStrategy tokenExtractionStrategy = TokenExtractionStrategy.NONE;
    private boolean includeSemantics = false;
    private ValidationLevel validationLevel = ValidationLevel.ARCHIVAL_DATA;
    private Locale locale = Locale.getDefault();
    private boolean enableEtsiValidationReport = true;

    protected SignedDocumentValidator(DocumentAnalyzer documentAnalyzer) {
        Objects.requireNonNull(documentAnalyzer, "DocumentAnalyzer cannot be null!");
        this.documentAnalyzer = documentAnalyzer;
    }

    public static SignedDocumentValidator fromDocument(DSSDocument dssDocument) {
        Objects.requireNonNull(dssDocument, "DSSDocument is null");
        ServiceLoader<DocumentValidatorFactory> serviceLoaders = ServiceLoader.load(DocumentValidatorFactory.class);
        for (DocumentValidatorFactory factory : serviceLoaders) {
            if (!factory.isSupported(dssDocument)) continue;
            return factory.create(dssDocument);
        }
        throw new UnsupportedOperationException("Document format not recognized/handled");
    }

    public boolean isSupported(DSSDocument dssDocument) {
        return this.documentAnalyzer.isSupported(dssDocument);
    }

    public DocumentAnalyzer getDocumentAnalyzer() {
        return this.documentAnalyzer;
    }

    @Override
    public void setSigningCertificateSource(CertificateSource signingCertificateSource) {
        this.documentAnalyzer.setSigningCertificateSource(signingCertificateSource);
    }

    @Override
    public void setCertificateVerifier(CertificateVerifier certificateVerifier) {
        this.documentAnalyzer.setCertificateVerifier(certificateVerifier);
    }

    @Override
    public void setValidationContextExecutor(ValidationContextExecutor validationContextExecutor) {
        this.documentAnalyzer.setValidationContextExecutor(validationContextExecutor);
    }

    @Override
    public void setTokenIdentifierProvider(TokenIdentifierProvider tokenIdentifierProvider) {
        this.documentAnalyzer.setTokenIdentifierProvider(tokenIdentifierProvider);
    }

    @Override
    public void setDetachedContents(List<DSSDocument> detachedContents) {
        this.documentAnalyzer.setDetachedContents(detachedContents);
    }

    @Override
    public void setDetachedEvidenceRecordDocuments(List<DSSDocument> detachedEvidenceRecordDocuments) {
        this.documentAnalyzer.setDetachedEvidenceRecordDocuments(detachedEvidenceRecordDocuments);
    }

    @Override
    public void setContainerContents(List<DSSDocument> containerContents) {
        this.documentAnalyzer.setContainerContents(containerContents);
    }

    @Override
    public void setManifestFile(ManifestFile manifestFile) {
        this.documentAnalyzer.setManifestFile(manifestFile);
    }

    @Override
    public void setValidationTime(Date validationTime) {
        this.documentAnalyzer.setValidationTime(validationTime);
    }

    @Deprecated
    public void setSkipValidationContextExecution(boolean skipValidationContextExecution) {
        if (skipValidationContextExecution) {
            LOG.warn("Use of deprecated method #setSkipValidationContextExecution. SkipValidationContextExecutor is instantiated.");
            this.documentAnalyzer.setValidationContextExecutor((ValidationContextExecutor)SkipValidationContextExecutor.INSTANCE);
        }
    }

    @Override
    public void setSignaturePolicyProvider(SignaturePolicyProvider signaturePolicyProvider) {
        this.documentAnalyzer.setSignaturePolicyProvider(signaturePolicyProvider);
    }

    @Override
    public void setDefaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        Objects.requireNonNull(digestAlgorithm, "Default DigestAlgorithm cannot be nulL!");
        this.defaultDigestAlgorithm = digestAlgorithm;
    }

    @Override
    public void setTokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        Objects.requireNonNull(tokenExtractionStrategy);
        this.tokenExtractionStrategy = tokenExtractionStrategy;
    }

    @Override
    public void setIncludeSemantics(boolean include) {
        this.includeSemantics = include;
    }

    @Override
    public void setValidationLevel(ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
    }

    @Override
    public void setEnableEtsiValidationReport(boolean enableEtsiValidationReport) {
        this.enableEtsiValidationReport = enableEtsiValidationReport;
    }

    @Override
    public void setProcessExecutor(DocumentProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    protected DocumentProcessExecutor provideProcessExecutorInstance() {
        if (this.processExecutor == null) {
            this.processExecutor = this.getDefaultProcessExecutor();
        }
        return this.processExecutor;
    }

    @Override
    public DocumentProcessExecutor getDefaultProcessExecutor() {
        return new DefaultSignatureProcessExecutor();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Reports validateDocument() {
        return this.validateDocument((InputStream)null);
    }

    @Override
    public Reports validateDocument(URL validationPolicyURL) {
        Reports reports;
        block9: {
            if (validationPolicyURL == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = validationPolicyURL.openStream();
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy with URL '%s'. Reason : %s", validationPolicyURL, e.getMessage()), (Throwable)e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(String policyResourcePath) {
        Reports reports;
        block9: {
            if (policyResourcePath == null) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = this.getClass().getResourceAsStream(policyResourcePath);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from path '%s'. Reason : %s", policyResourcePath, e.getMessage()), (Throwable)e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(File policyFile) {
        Reports reports;
        block9: {
            if (policyFile == null || !policyFile.exists()) {
                return this.validateDocument((InputStream)null);
            }
            InputStream is = DSSUtils.toByteArrayInputStream((File)policyFile);
            try {
                reports = this.validateDocument(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalInputException(String.format("Unable to load policy from file '%s'. Reason : %s", policyFile, e.getMessage()), (Throwable)e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(DSSDocument policyDocument) {
        Reports reports;
        block8: {
            InputStream is = policyDocument.openStream();
            try {
                reports = this.validateDocument(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DSSException(String.format("Unable to read policy file: %s", e.getMessage()), (Throwable)e);
                }
            }
            is.close();
        }
        return reports;
    }

    @Override
    public Reports validateDocument(InputStream policyDataStream) {
        ValidationPolicy validationPolicy;
        try {
            if (policyDataStream == null) {
                LOG.debug("No provided validation policy : use the default policy");
                validationPolicy = ValidationPolicyFacade.newFacade().getDefaultValidationPolicy();
            } else {
                validationPolicy = ValidationPolicyFacade.newFacade().getValidationPolicy(policyDataStream);
            }
        }
        catch (Exception e) {
            throw new IllegalInputException("Unable to load the policy", (Throwable)e);
        }
        return this.validateDocument(validationPolicy);
    }

    @Override
    public Reports validateDocument(ConstraintsParameters validationPolicyJaxb) {
        EtsiValidationPolicy validationPolicy = new EtsiValidationPolicy(validationPolicyJaxb);
        return this.validateDocument((ValidationPolicy)validationPolicy);
    }

    @Override
    public Reports validateDocument(ValidationPolicy validationPolicy) {
        LOG.info("Document validation...");
        this.assertConfigurationValid();
        XmlDiagnosticData diagnosticData = this.getDiagnosticData();
        return this.processValidationPolicy(diagnosticData, validationPolicy);
    }

    protected void assertConfigurationValid() {
        if (ValidationLevel.BASIC_SIGNATURES == this.validationLevel && (Utils.isCollectionNotEmpty((Collection)this.documentAnalyzer.getDetachedTimestamps()) || Utils.isCollectionNotEmpty((Collection)this.documentAnalyzer.getDetachedEvidenceRecords())) && Utils.isCollectionEmpty((Collection)this.documentAnalyzer.getSignatures())) {
            throw new IllegalArgumentException("Basic Signatures validation cannot be used for timestamp or evidence record documents!");
        }
    }

    public final XmlDiagnosticData getDiagnosticData() {
        ValidationContext validationContext = this.documentAnalyzer.validate();
        SignedDocumentDiagnosticDataBuilder diagnosticDataBuilder = this.initializeDiagnosticDataBuilder();
        return new XmlDiagnosticDataFactory(diagnosticDataBuilder).setDocument(this.documentAnalyzer.getDocument()).setValidationTime(this.documentAnalyzer.getValidationTime()).setTokenIdentifierProvider(this.documentAnalyzer.getTokenIdentifierProvider()).setValidationContext(validationContext).setDefaultDigestAlgorithm(this.defaultDigestAlgorithm).setTokenExtractionStrategy(this.tokenExtractionStrategy).create();
    }

    protected SignedDocumentDiagnosticDataBuilder initializeDiagnosticDataBuilder() {
        return new SignedDocumentDiagnosticDataBuilder();
    }

    protected final Reports processValidationPolicy(XmlDiagnosticData diagnosticData, ValidationPolicy validationPolicy) {
        DocumentProcessExecutor executor = this.provideProcessExecutorInstance();
        executor.setCurrentTime(this.documentAnalyzer.getValidationTime());
        executor.setValidationPolicy(validationPolicy);
        executor.setValidationLevel(this.validationLevel);
        executor.setDiagnosticData(diagnosticData);
        executor.setIncludeSemantics(this.includeSemantics);
        executor.setEnableEtsiValidationReport(this.enableEtsiValidationReport);
        executor.setLocale(this.locale);
        return (Reports)executor.execute();
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        return this.documentAnalyzer.getSignatures();
    }

    public AdvancedSignature getSignatureById(String signatureId) {
        if (this.documentAnalyzer instanceof DefaultDocumentAnalyzer) {
            return ((DefaultDocumentAnalyzer)this.documentAnalyzer).getSignatureById(signatureId);
        }
        throw new IllegalStateException("The documentAnalyzer shall be an instance of DefaultDocumentAnalyzer to execute the method!");
    }

    @Override
    public List<TimestampToken> getDetachedTimestamps() {
        return this.documentAnalyzer.getDetachedTimestamps();
    }

    @Override
    public List<EvidenceRecord> getDetachedEvidenceRecords() {
        return this.documentAnalyzer.getDetachedEvidenceRecords();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        return this.documentAnalyzer.getOriginalDocuments(signatureId);
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        return this.documentAnalyzer.getOriginalDocuments(advancedSignature);
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures) {
        return this.documentAnalyzer.getValidationData(signatures);
    }

    @Override
    public <T extends AdvancedSignature> ValidationDataContainer getValidationData(Collection<T> signatures, Collection<TimestampToken> detachedTimestamps) {
        return this.documentAnalyzer.getValidationData(signatures, detachedTimestamps);
    }

    @Deprecated
    public SignaturePolicyValidatorLoader getSignaturePolicyValidatorLoader() {
        if (this.documentAnalyzer instanceof DefaultDocumentAnalyzer) {
            return ((DefaultDocumentAnalyzer)this.documentAnalyzer).getSignaturePolicyValidatorLoader();
        }
        throw new IllegalStateException("The documentAnalyzer shall be an instance of DefaultDocumentAnalyzer to execute the method!");
    }
}

