/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ValidationProcessUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String URN_OID_PREFIX = "urn:oid:";
    private static final String ALL_VALUE = "*";

    private ValidationProcessUtils() {
    }

    public static boolean isAllowedBasicSignatureValidation(XmlConclusion conclusion) {
        return conclusion != null && (Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication())));
    }

    public static boolean isAllowedBasicRevocationDataValidation(XmlConclusion conclusion) {
        return conclusion != null && (Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication())));
    }

    public static boolean isAllowedBasicTimestampValidation(XmlConclusion conclusion) {
        return conclusion != null && (Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication())));
    }

    public static boolean isAllowedValidationWithLongTermData(XmlConclusion conclusion) {
        return conclusion != null && (Indication.PASSED.equals((Object)conclusion.getIndication()) || Indication.INDETERMINATE.equals((Object)conclusion.getIndication()) && (SubIndication.REVOKED_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals((Object)conclusion.getSubIndication()) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.REVOCATION_OUT_OF_BOUNDS_NO_POE.equals((Object)conclusion.getSubIndication()) || SubIndication.SIG_CONSTRAINTS_FAILURE.equals((Object)conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals((Object)conclusion.getSubIndication())));
    }

    public static CertificateRevocationWrapper getLatestAcceptableRevocationData(TokenProxy token, CertificateWrapper certificate, Collection<CertificateRevocationWrapper> revocationData, Date controlTime, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        CertificateRevocationWrapper latestRevocationData = null;
        if (poe.isPOEExists(certificate.getId(), controlTime)) {
            for (CertificateRevocationWrapper revocationWrapper : revocationData) {
                XmlBasicBuildingBlocks revocationBBB = bbbs.get(revocationWrapper.getId());
                if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, (RevocationWrapper)revocationWrapper) || revocationWrapper.getThisUpdate() == null || !revocationWrapper.getThisUpdate().before(controlTime) || !poe.isPOEExists(revocationWrapper.getId(), controlTime) || latestRevocationData != null && (revocationWrapper.getProductionDate() == null || !latestRevocationData.getProductionDate().before(revocationWrapper.getProductionDate()))) continue;
                latestRevocationData = revocationWrapper;
            }
        }
        return latestRevocationData;
    }

    public static List<CertificateRevocationWrapper> getAcceptableRevocationDataForPSVIfExistOrReturnAll(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        List<CertificateRevocationWrapper> revocationWrappers = ValidationProcessUtils.filterRevocationDataForPastSignatureValidation(token, certificate, bbbs, poe);
        if (Utils.isCollectionNotEmpty(revocationWrappers)) {
            return revocationWrappers;
        }
        return certificate.getCertificateRevocationData();
    }

    private static List<CertificateRevocationWrapper> filterRevocationDataForPastSignatureValidation(TokenProxy token, CertificateWrapper certificate, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe) {
        ArrayList<CertificateRevocationWrapper> certificateRevocations = new ArrayList<CertificateRevocationWrapper>();
        for (CertificateRevocationWrapper certificateRevocation : certificate.getCertificateRevocationData()) {
            XmlBasicBuildingBlocks revocationBBB = bbbs.get(certificateRevocation.getId());
            CertificateWrapper revocationIssuer = certificateRevocation.getSigningCertificate();
            if (!ValidationProcessUtils.isAllowedBasicRevocationDataValidation(revocationBBB.getConclusion()) || !ValidationProcessUtils.isRevocationDataAcceptable(bbbs.get(token.getId()), certificate, (RevocationWrapper)certificateRevocation) || revocationIssuer == null || !revocationIssuer.isTrusted() && !poe.isPOEExistInRange(revocationIssuer.getId(), revocationIssuer.getNotBefore(), revocationIssuer.getNotAfter())) continue;
            certificateRevocations.add(certificateRevocation);
        }
        return certificateRevocations;
    }

    public static boolean isRevocationDataAcceptable(XmlBasicBuildingBlocks bbb, CertificateWrapper certificate, RevocationWrapper revocationData) {
        XmlRAC xmlRAC = ValidationProcessUtils.getRevocationAcceptanceCheckerResult(bbb, certificate.getId(), revocationData.getId());
        return xmlRAC != null && xmlRAC.getConclusion() != null && Indication.PASSED.equals((Object)xmlRAC.getConclusion().getIndication());
    }

    public static boolean isLongTermAvailabilityAndIntegrityMaterialPresent(SignatureWrapper signature) {
        return signature.isThereALevel() || ValidationProcessUtils.timestampCoveringOtherSignatureTimestampsPresent(signature) || Utils.isCollectionNotEmpty((Collection)signature.getEvidenceRecords());
    }

    private static boolean timestampCoveringOtherSignatureTimestampsPresent(SignatureWrapper signature) {
        for (TimestampWrapper timestamp : signature.getTimestampList()) {
            List timestampedTimestamps = timestamp.getTimestampedTimestamps();
            if (!Utils.isCollectionNotEmpty((Collection)timestampedTimestamps)) continue;
            for (TimestampWrapper timestampedTimestamp : timestampedTimestamps) {
                if (timestampedTimestamp.getType().isContentTimestamp() || !Utils.isCollectionNotEmpty((Collection)timestampedTimestamp.getTimestampedSignatures())) continue;
                return true;
            }
        }
        return false;
    }

    public static XmlRAC getRevocationAcceptanceCheckerResult(XmlBasicBuildingBlocks bbb, String certificateId, String revocationDataId) {
        List racs;
        XmlRAC rac;
        XmlCRS crs;
        XmlSubXCV subXCV;
        XmlXCV xcv;
        if (bbb != null && (xcv = bbb.getXCV()) != null && (subXCV = ValidationProcessUtils.getXmlSubXCVForId(xcv.getSubXCV(), certificateId)) != null && (crs = subXCV.getCRS()) != null && (rac = ValidationProcessUtils.getXmlRACForId(racs = crs.getRAC(), revocationDataId)) != null) {
            return rac;
        }
        return null;
    }

    private static XmlSubXCV getXmlSubXCVForId(List<XmlSubXCV> subXCVs, String tokenId) {
        for (XmlSubXCV subXCV : subXCVs) {
            if (!tokenId.equals(subXCV.getId())) continue;
            return subXCV;
        }
        return null;
    }

    private static XmlRAC getXmlRACForId(List<XmlRAC> racs, String tokenId) {
        if (Utils.isCollectionNotEmpty(racs)) {
            for (XmlRAC rac : racs) {
                if (!tokenId.equals(rac.getId())) continue;
                return rac;
            }
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String buildStringMessage(I18nProvider i18nProvider, MessageTag messageTag, Object ... args) {
        if (messageTag != null) {
            return i18nProvider.getMessage(messageTag, args);
        }
        return null;
    }

    public static MessageTag getCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_SIG_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_TST_SIG;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_REVOC_SIG;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getCertificateChainCryptoPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.ACCM_POS_CERT_CHAIN_SIG;
            }
            case TIMESTAMP: {
                return MessageTag.ACCM_POS_CERT_CHAIN_TST;
            }
            case REVOCATION: {
                return MessageTag.ACCM_POS_CERT_CHAIN_REVOC;
            }
            case CERTIFICATE: {
                return MessageTag.ACCM_POS_CERT_CHAIN;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getDigestMatcherCryptoPosition(XmlDigestMatcher digestMatcher) {
        switch (digestMatcher.getType()) {
            case OBJECT: 
            case REFERENCE: 
            case XPOINTER: {
                return MessageTag.ACCM_POS_REF;
            }
            case MANIFEST: {
                return MessageTag.ACCM_POS_MAN;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.ACCM_POS_MAN_ENT;
            }
            case SIGNED_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGND_PRT;
            }
            case KEY_INFO: {
                return MessageTag.ACCM_POS_KEY;
            }
            case SIGNATURE_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGNTR_PRT;
            }
            case COUNTER_SIGNATURE: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.ACCM_POS_CNTR_SIG;
            }
            case MESSAGE_DIGEST: {
                return MessageTag.ACCM_POS_MES_DIG;
            }
            case CONTENT_DIGEST: {
                return MessageTag.ACCM_POS_CON_DIG;
            }
            case JWS_SIGNING_INPUT_DIGEST: {
                return MessageTag.ACCM_POS_JWS;
            }
            case SIG_D_ENTRY: {
                return MessageTag.ACCM_POS_SIG_D_ENT;
            }
            case MESSAGE_IMPRINT: {
                return MessageTag.ACCM_POS_MESS_IMP;
            }
            case EVIDENCE_RECORD_ARCHIVE_OBJECT: {
                return MessageTag.ACCM_POS_ER_ADO;
            }
            case EVIDENCE_RECORD_ORPHAN_REFERENCE: {
                return MessageTag.ACCM_POS_ER_OR;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP: {
                return MessageTag.ACCM_POS_ER_TST;
            }
            case EVIDENCE_RECORD_ARCHIVE_TIME_STAMP_SEQUENCE: {
                return MessageTag.ACCM_POS_ER_TST_SEQ;
            }
        }
        throw new IllegalArgumentException(String.format("The provided DigestMatcherType '%s' is not supported!", digestMatcher.getType()));
    }

    public static MessageTag getDigestMatcherCryptoPosition(Collection<XmlDigestMatcher> digestMatchers) {
        if (Utils.isCollectionEmpty(digestMatchers)) {
            throw new IllegalArgumentException("Collection of DigestMatchers cannot be null!");
        }
        if (Utils.collectionSize(digestMatchers) == 1) {
            return ValidationProcessUtils.getDigestMatcherCryptoPosition(digestMatchers.iterator().next());
        }
        DigestMatcherType digestMatcherType = ValidationProcessUtils.getDigestMatcherType(digestMatchers);
        switch (digestMatcherType) {
            case OBJECT: 
            case REFERENCE: 
            case XPOINTER: {
                return MessageTag.ACCM_POS_REF_PL;
            }
            case MANIFEST: {
                return MessageTag.ACCM_POS_MAN_PL;
            }
            case MANIFEST_ENTRY: {
                return MessageTag.ACCM_POS_MAN_ENT_PL;
            }
            case SIGNED_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGND_PRT;
            }
            case KEY_INFO: {
                return MessageTag.ACCM_POS_KEY_PL;
            }
            case SIGNATURE_PROPERTIES: {
                return MessageTag.ACCM_POS_SIGNTR_PRT;
            }
            case COUNTER_SIGNATURE: 
            case COUNTER_SIGNED_SIGNATURE_VALUE: {
                return MessageTag.ACCM_POS_CNTR_SIG_PL;
            }
            case SIG_D_ENTRY: {
                return MessageTag.ACCM_POS_SIG_D_ENT_PL;
            }
            case EVIDENCE_RECORD_ARCHIVE_OBJECT: {
                return MessageTag.ACCM_POS_ER_ADO_PL;
            }
            case EVIDENCE_RECORD_ORPHAN_REFERENCE: {
                return MessageTag.ACCM_POS_ER_OR_PL;
            }
        }
        throw new IllegalArgumentException(String.format("The provided DigestMatcherType '%s' is not supported for multiple digest matchers!", digestMatcherType));
    }

    private static DigestMatcherType getDigestMatcherType(Collection<XmlDigestMatcher> digestMatchers) {
        return digestMatchers.iterator().next().getType();
    }

    public static MessageTag getTimestampTypeMessageTag(TimestampType timestampType) {
        if (timestampType.isContentTimestamp()) {
            return MessageTag.TST_TYPE_CONTENT_TST;
        }
        if (timestampType.isSignatureTimestamp()) {
            return MessageTag.TST_TYPE_SIGNATURE_TST;
        }
        if (timestampType.isValidationDataTimestamp()) {
            return MessageTag.TST_TYPE_VD_TST;
        }
        if (timestampType.isDocumentTimestamp()) {
            return MessageTag.TST_TYPE_DOC_TST;
        }
        if (timestampType.isContainerTimestamp()) {
            return MessageTag.TST_TYPE_CONTAINER_TST;
        }
        if (timestampType.isArchivalTimestamp()) {
            return MessageTag.TST_TYPE_ARCHIVE_TST;
        }
        if (timestampType.isEvidenceRecordTimestamp()) {
            return MessageTag.TST_TYPE_ER_TST;
        }
        throw new IllegalArgumentException(String.format("The TimestampType '%s' is not supported!", timestampType));
    }

    public static MessageTag getContextPosition(Context context) {
        switch (context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: 
            case CERTIFICATE: {
                return MessageTag.SIGNATURE;
            }
            case TIMESTAMP: {
                return MessageTag.TIMESTAMP;
            }
            case REVOCATION: {
                return MessageTag.REVOCATION;
            }
        }
        throw new IllegalArgumentException("Unsupported context " + context);
    }

    public static MessageTag getSubContextPosition(SubContext subContext) {
        switch (subContext) {
            case SIGNING_CERT: {
                return MessageTag.SIGNING_CERTIFICATE;
            }
            case CA_CERTIFICATE: {
                return MessageTag.CA_CERTIFICATE;
            }
        }
        throw new IllegalArgumentException("Unsupported subContext " + subContext);
    }

    public static MessageTag getValidationTimeMessageTag(ValidationTime validationTime) {
        switch (validationTime) {
            case BEST_SIGNATURE_TIME: {
                return MessageTag.VT_BEST_SIGNATURE_TIME;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                return MessageTag.VT_CERTIFICATE_ISSUANCE_TIME;
            }
            case VALIDATION_TIME: {
                return MessageTag.VT_VALIDATION_TIME;
            }
            case TIMESTAMP_GENERATION_TIME: {
                return MessageTag.VT_TST_GENERATION_TIME;
            }
            case TIMESTAMP_POE_TIME: {
                return MessageTag.VT_TST_POE_TIME;
            }
        }
        throw new IllegalArgumentException(String.format("The validation time [%s] is not supported", validationTime));
    }

    public static String toUrnOid(String oid) {
        if (oid == null) {
            return null;
        }
        return URN_OID_PREFIX + oid;
    }

    public static String getDomainName(String uri) {
        if (uri == null) {
            return null;
        }
        return uri.replaceAll("(^.*://)|(www\\.)|([?=:#/].*)", "");
    }

    public static boolean processValueCheck(String value, List<String> expectedValues) {
        if (Utils.isStringNotEmpty((String)value) && Utils.isCollectionNotEmpty(expectedValues)) {
            return expectedValues.contains(ALL_VALUE) || expectedValues.contains(value);
        }
        return false;
    }

    public static boolean processValuesCheck(List<String> values, List<String> expectedValues) {
        if (Utils.isCollectionNotEmpty(values)) {
            for (String value : values) {
                if (!ValidationProcessUtils.processValueCheck(value, expectedValues)) continue;
                return true;
            }
            return false;
        }
        return Utils.isCollectionEmpty(expectedValues);
    }
}

