/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;

public class FullScopeCheck
extends ChainItem<XmlFC> {
    private final Collection<XmlSignatureScope> signatureScopes;

    public FullScopeCheck(I18nProvider i18nProvider, XmlFC result, Collection<XmlSignatureScope> signatureScopes, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.signatureScopes = signatureScopes;
    }

    @Override
    protected boolean process() {
        if (Utils.isCollectionNotEmpty(this.signatureScopes)) {
            for (XmlSignatureScope sigScope : this.signatureScopes) {
                if (SignatureScopeType.FULL == sigScope.getScope()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_ICFD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_ICFD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

