/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SignedFilesPresentCheck
extends ChainItem<XmlFC> {
    private final XmlContainerInfo containerInfo;

    public SignedFilesPresentCheck(I18nProvider i18nProvider, XmlFC result, XmlContainerInfo containerInfo, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.containerInfo = containerInfo;
    }

    @Override
    protected boolean process() {
        if (this.isASiCS()) {
            List<String> rootLevelFiles = this.getRootLevelFiles(this.containerInfo.getContentFiles());
            return Utils.isCollectionNotEmpty(rootLevelFiles) && rootLevelFiles.size() == 1;
        }
        return Utils.isCollectionNotEmpty((Collection)this.containerInfo.getContentFiles());
    }

    private boolean isASiCS() {
        return ASiCContainerType.ASiC_S.equals((Object)this.containerInfo.getContainerType());
    }

    private List<String> getRootLevelFiles(List<String> fileNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String fileName : fileNames) {
            if (!this.isRootDirectoryFile(fileName)) continue;
            result.add(fileName);
        }
        return result;
    }

    private boolean isRootDirectoryFile(String fileName) {
        return !fileName.contains("/") && !fileName.contains("\\");
    }

    @Override
    protected MessageTag getMessageTag() {
        if (this.isASiCS()) {
            return MessageTag.BBB_FC_ISFP_ASICS;
        }
        return MessageTag.BBB_FC_ISFP_ASICE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        if (this.isASiCS()) {
            return MessageTag.BBB_FC_ISFP_ASICS_ANS;
        }
        return MessageTag.BBB_FC_ISFP_ASICE_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

