/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.utils.Utils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PolicyTreeNode {
    private static final String ANY_POLICY = "2.5.29.32.0";
    private final String validPolicy;
    private final Set<String> qualifierSet;
    private final Set<String> expectedPolicySet;
    private final Set<PolicyTreeNode> children = new HashSet<PolicyTreeNode>();

    public PolicyTreeNode(String policyOid, String policyQualifier) {
        this.validPolicy = policyOid;
        this.qualifierSet = policyQualifier != null ? Collections.singleton(policyQualifier) : Collections.emptySet();
        this.expectedPolicySet = Collections.singleton(policyOid);
    }

    public static PolicyTreeNode initTree() {
        return new PolicyTreeNode(ANY_POLICY, null);
    }

    public boolean isAnyPolicy() {
        return ANY_POLICY.equals(this.validPolicy);
    }

    public boolean addChildNodeIfMatch(PolicyTreeNode policyNode) {
        if (this.expectedPolicySet.contains(policyNode.validPolicy)) {
            this.children.add(policyNode);
            return true;
        }
        if (this.isAnyPolicy()) {
            this.children.add(policyNode);
            return true;
        }
        return false;
    }

    public Set<PolicyTreeNode> createAnyPolicyChildren() {
        HashSet<PolicyTreeNode> anyPolicyChildren = new HashSet<PolicyTreeNode>();
        for (String expectedPolicy : this.expectedPolicySet) {
            PolicyTreeNode child = new PolicyTreeNode(expectedPolicy, ANY_POLICY);
            anyPolicyChildren.add(child);
        }
        this.children.addAll(anyPolicyChildren);
        return anyPolicyChildren;
    }

    public PolicyTreeNode deleteNodesAtLevelWithoutChildren(int depthLevel) {
        if (depthLevel > 0) {
            Iterator<PolicyTreeNode> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                PolicyTreeNode child = iterator.next();
                if (child.deleteNodesAtLevelWithoutChildren(depthLevel - 1) != null) continue;
                iterator.remove();
            }
        }
        return Utils.isCollectionEmpty(this.children) ? null : this;
    }
}

