/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.trust.TrustServiceStatus;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustServicesFilterFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class GrantedStatusCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<TrustServiceWrapper> trustServicesAtTime;

    public GrantedStatusCheck(I18nProvider i18nProvider, T result, List<TrustServiceWrapper> trustServicesAtTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.trustServicesAtTime = trustServicesAtTime;
    }

    @Override
    protected boolean process() {
        TrustServiceFilter filterByGranted = TrustServicesFilterFactory.createFilterByGranted();
        return Utils.isCollectionNotEmpty(filterByGranted.filter(this.trustServicesAtTime));
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_HAS_GRANTED;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.QUAL_HAS_GRANTED_ANS;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        Collection<String> statusList = this.getStatusList();
        MessageTag errorTag = Utils.collectionSize(statusList) == 1 ? MessageTag.QUAL_HAS_GRANTED_ANS : MessageTag.QUAL_HAS_GRANTED_ANS_2;
        String argument = Utils.collectionSize(statusList) == 1 ? statusList.iterator().next() : statusList.toString();
        return this.buildXmlMessage(errorTag, argument);
    }

    private Collection<String> getStatusList() {
        HashSet<String> identifiers = new HashSet<String>();
        for (TrustServiceWrapper trustService : this.trustServicesAtTime) {
            String status = trustService.getStatus();
            TrustServiceStatus tss = TrustServiceStatus.fromUri(status);
            identifiers.add(tss != null ? tss.getShortName() : status);
        }
        return identifiers;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

