/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.crl.CRLBinary;
import eu.europa.esig.dss.diagnostic.jaxb.XmlAbstractToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCommitmentTypeIndication;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestMatcher;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEncapsulationType;
import eu.europa.esig.dss.diagnostic.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundEvidenceRecord;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundRevocations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlFoundTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocationToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRelatedRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureDigestReference;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureProductionPlace;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignatureScope;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerDocumentRepresentations;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerRole;
import eu.europa.esig.dss.diagnostic.jaxb.XmlStructuralValidation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTSAGeneralName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.enumerations.TokenExtractionStrategy;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.ManifestEntry;
import eu.europa.esig.dss.model.ManifestFile;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.identifier.IdentifierBasedObject;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.model.signature.CommitmentTypeIndication;
import eu.europa.esig.dss.model.signature.SignatureCryptographicVerification;
import eu.europa.esig.dss.model.signature.SignatureDigestReference;
import eu.europa.esig.dss.model.signature.SignaturePolicy;
import eu.europa.esig.dss.model.signature.SignatureProductionPlace;
import eu.europa.esig.dss.model.signature.SignerRole;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.Token;
import eu.europa.esig.dss.model.x509.X500PrincipalHelper;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSPKUtils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.SignerIdentifier;
import eu.europa.esig.dss.spi.x509.TokenCertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.revocation.ListRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPResponseBinary;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.spi.x509.tsp.TimestampTokenComparator;
import eu.europa.esig.dss.spi.x509.tsp.TimestampedReference;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.diagnostic.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlPolicyBuilder;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class SignedDocumentDiagnosticDataBuilder
extends DiagnosticDataBuilder {
    protected DSSDocument signedDocument;
    protected Collection<AdvancedSignature> signatures;
    protected Collection<TimestampToken> usedTimestamps;
    protected Collection<EvidenceRecord> evidenceRecords;
    protected ListCertificateSource documentCertificateSource = new ListCertificateSource();
    protected ListRevocationSource<CRL> documentCRLSource = new ListRevocationSource();
    protected ListRevocationSource<OCSP> documentOCSPSource = new ListRevocationSource();
    protected Map<String, XmlSignature> xmlSignaturesMap = new HashMap<String, XmlSignature>();
    protected Map<String, XmlTimestamp> xmlTimestampsMap = new HashMap<String, XmlTimestamp>();
    protected Map<String, XmlEvidenceRecord> xmlEvidenceRecordMap = new HashMap<String, XmlEvidenceRecord>();
    protected Map<String, XmlSignerData> xmlSignedDataMap = new HashMap<String, XmlSignerData>();

    @Override
    public SignedDocumentDiagnosticDataBuilder usedCertificates(Set<CertificateToken> usedCertificates) {
        return (SignedDocumentDiagnosticDataBuilder)super.usedCertificates(usedCertificates);
    }

    @Override
    public SignedDocumentDiagnosticDataBuilder usedRevocations(Set<RevocationToken<?>> usedRevocations) {
        return (SignedDocumentDiagnosticDataBuilder)super.usedRevocations(usedRevocations);
    }

    @Override
    public SignedDocumentDiagnosticDataBuilder allCertificateSources(ListCertificateSource trustedCertSources) {
        return (SignedDocumentDiagnosticDataBuilder)super.allCertificateSources(trustedCertSources);
    }

    @Override
    public SignedDocumentDiagnosticDataBuilder validationDate(Date validationDate) {
        return (SignedDocumentDiagnosticDataBuilder)super.validationDate(validationDate);
    }

    @Override
    public SignedDocumentDiagnosticDataBuilder tokenExtractionStrategy(TokenExtractionStrategy tokenExtractionStrategy) {
        return (SignedDocumentDiagnosticDataBuilder)super.tokenExtractionStrategy(tokenExtractionStrategy);
    }

    @Override
    public SignedDocumentDiagnosticDataBuilder defaultDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return (SignedDocumentDiagnosticDataBuilder)super.defaultDigestAlgorithm(digestAlgorithm);
    }

    public SignedDocumentDiagnosticDataBuilder document(DSSDocument signedDocument) {
        this.signedDocument = signedDocument;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder foundSignatures(Collection<AdvancedSignature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder usedTimestamps(Collection<TimestampToken> usedTimestamps) {
        this.usedTimestamps = usedTimestamps;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder foundEvidenceRecords(Collection<EvidenceRecord> evidenceRecords) {
        this.evidenceRecords = evidenceRecords;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder documentCertificateSource(ListCertificateSource documentCertificateSource) {
        this.documentCertificateSource = documentCertificateSource;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder documentCRLSource(ListRevocationSource<CRL> documentCRLSource) {
        this.documentCRLSource = documentCRLSource;
        return this;
    }

    public SignedDocumentDiagnosticDataBuilder documentOCSPSource(ListRevocationSource<OCSP> documentCRLSource) {
        this.documentOCSPSource = documentCRLSource;
        return this;
    }

    @Override
    public XmlDiagnosticData build() {
        Objects.requireNonNull(this.signedDocument, "signedDocument shall be provided! Use 'document()' method.");
        XmlDiagnosticData diagnosticData = super.build();
        diagnosticData.setDocumentName(this.removeSpecialCharsForXml(this.signedDocument.getName()));
        Collection<XmlSignerData> xmlSignerData = this.buildXmlSignerDataList(this.signatures, this.usedTimestamps, this.evidenceRecords);
        diagnosticData.getOriginalDocuments().addAll(xmlSignerData);
        if (Utils.isCollectionNotEmpty(this.signatures)) {
            Collection<XmlSignature> xmlSignatures = this.buildXmlSignatures(this.signatures);
            diagnosticData.getSignatures().addAll(xmlSignatures);
            this.attachCounterSignatures(this.signatures);
        }
        if (Utils.isCollectionNotEmpty(this.usedTimestamps)) {
            List<XmlTimestamp> builtTimestamps = this.buildXmlTimestamps(this.usedTimestamps);
            diagnosticData.getUsedTimestamps().addAll(builtTimestamps);
            this.linkSignaturesAndTimestamps(this.signatures);
        }
        if (Utils.isCollectionNotEmpty(this.evidenceRecords)) {
            List<XmlEvidenceRecord> builtEvidenceRecords = this.buildXmlEvidenceRecords(this.evidenceRecords);
            diagnosticData.getEvidenceRecords().addAll(builtEvidenceRecords);
            this.linkSignaturesAndEvidenceRecords(this.signatures);
            this.linkTimestampsAndEvidenceRecords(this.usedTimestamps);
            this.linkEvidenceRecordsAndTimestamps(this.evidenceRecords);
        }
        super.linkSigningCertificateAndChains(this.usedCertificates);
        diagnosticData.setOrphanTokens(this.buildXmlOrphanTokens());
        if (Utils.isCollectionNotEmpty(this.usedTimestamps)) {
            this.linkTimestampsAndTimestampsObjects(this.usedTimestamps);
        }
        if (Utils.isCollectionNotEmpty(this.evidenceRecords)) {
            this.linkEvidenceRecordsAndTimestampsObjects(this.evidenceRecords);
        }
        return diagnosticData;
    }

    @Override
    protected void linkSigningCertificateAndChains(Set<CertificateToken> certificates) {
    }

    private String removeSpecialCharsForXml(String text) {
        if (Utils.isStringNotEmpty((String)text)) {
            return text.replace("&", "");
        }
        return "";
    }

    private Collection<XmlSignerData> buildXmlSignerDataList(Collection<AdvancedSignature> signatures, Collection<TimestampToken> timestamps, Collection<EvidenceRecord> evidenceRecords) {
        ArrayList<XmlSignerData> signerDataList = new ArrayList<XmlSignerData>();
        if (Utils.isCollectionNotEmpty(signatures)) {
            for (AdvancedSignature signature : signatures) {
                signerDataList.addAll(this.buildXmlSignerData(signature.getSignatureScopes()));
            }
        }
        if (Utils.isCollectionNotEmpty(timestamps)) {
            for (TimestampToken timestampToken : timestamps) {
                signerDataList.addAll(this.buildXmlSignerData(timestampToken.getTimestampScopes()));
            }
        }
        if (Utils.isCollectionNotEmpty(evidenceRecords)) {
            for (EvidenceRecord evidenceRecord : evidenceRecords) {
                signerDataList.addAll(this.buildXmlSignerData(evidenceRecord.getEvidenceRecordScopes()));
            }
        }
        return signerDataList;
    }

    private List<XmlSignerData> buildXmlSignerData(List<SignatureScope> signatureScopes) {
        return this.buildXmlSignerData(signatureScopes, null);
    }

    private List<XmlSignerData> buildXmlSignerData(List<SignatureScope> signatureScopes, XmlSignerData parentSignerData) {
        ArrayList<XmlSignerData> result = new ArrayList<XmlSignerData>();
        if (Utils.isCollectionNotEmpty(signatureScopes)) {
            for (SignatureScope signatureScope : signatureScopes) {
                if (this.xmlSignedDataMap.get(signatureScope.getDSSIdAsString()) != null) continue;
                XmlSignerData xmlSignerData = this.buildXmlSignerData(signatureScope);
                if (parentSignerData != null) {
                    xmlSignerData.setParent((Object)parentSignerData);
                }
                result.add(xmlSignerData);
                if (!Utils.isCollectionNotEmpty((Collection)signatureScope.getChildren())) continue;
                result.addAll(this.buildXmlSignerData(signatureScope.getChildren(), xmlSignerData));
            }
        }
        return result;
    }

    private XmlSignerData buildXmlSignerData(SignatureScope signatureScope) {
        String id = signatureScope.getDSSIdAsString();
        XmlSignerData xmlSignerData = this.xmlSignedDataMap.get(id);
        if (xmlSignerData == null) {
            xmlSignerData = this.getXmlSignerData(signatureScope);
            this.xmlSignedDataMap.put(id, xmlSignerData);
        }
        return xmlSignerData;
    }

    private XmlSignerData getXmlSignerData(SignatureScope signatureScope) {
        XmlSignerData xmlSignedData = new XmlSignerData();
        xmlSignedData.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)signatureScope));
        xmlSignedData.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(signatureScope.getDigest(this.defaultDigestAlgorithm)));
        xmlSignedData.setReferencedName(signatureScope.getName(this.identifierProvider));
        return xmlSignedData;
    }

    private Collection<XmlSignature> buildXmlSignatures(Collection<AdvancedSignature> signatures) {
        ArrayList<XmlSignature> builtSignatures = new ArrayList<XmlSignature>();
        for (AdvancedSignature advancedSignature : signatures) {
            String id = advancedSignature.getId();
            XmlSignature xmlSignature = this.xmlSignaturesMap.get(id);
            if (xmlSignature != null) continue;
            xmlSignature = this.getXmlSignature(advancedSignature);
            builtSignatures.add(xmlSignature);
        }
        return builtSignatures;
    }

    private void attachCounterSignatures(Collection<AdvancedSignature> signatures) {
        for (AdvancedSignature advancedSignature : signatures) {
            if (!advancedSignature.isCounterSignature()) continue;
            XmlSignature currentSignature = this.xmlSignaturesMap.get(advancedSignature.getId());
            AdvancedSignature masterSignature = advancedSignature.getMasterSignature();
            XmlSignature xmlMasterSignature = this.xmlSignaturesMap.get(masterSignature.getId());
            currentSignature.setCounterSignature(Boolean.valueOf(true));
            currentSignature.setParent(xmlMasterSignature);
        }
    }

    private XmlSignature getXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = this.buildDetachedXmlSignature(signature);
        this.checkDuplicates(xmlSignature, signature);
        this.setXmlSigningCertificate(xmlSignature, signature);
        this.setXmlPolicy(xmlSignature, signature);
        xmlSignature.setFoundCertificates(this.getXmlFoundCertificates((Identifier)signature.getDSSId(), (TokenCertificateSource)signature.getCertificateSource()));
        xmlSignature.setFoundRevocations(this.getXmlFoundRevocations((OfflineRevocationSource<CRL>)signature.getCRLSource(), (OfflineRevocationSource<OCSP>)signature.getOCSPSource()));
        xmlSignature.setSignatureScopes(this.getXmlSignatureScopes(signature.getSignatureScopes()));
        this.xmlSignaturesMap.put(signature.getId(), xmlSignature);
        return xmlSignature;
    }

    private void checkDuplicates(XmlSignature xmlSignature, AdvancedSignature signature) {
        if (this.hasDuplicate(signature)) {
            xmlSignature.setDuplicated(Boolean.valueOf(true));
        }
    }

    private boolean hasDuplicate(AdvancedSignature currentSignature) {
        for (AdvancedSignature signature : this.signatures) {
            if (currentSignature == signature || !currentSignature.getId().equals(signature.getId()) && (currentSignature.getDAIdentifier() == null || !currentSignature.getDAIdentifier().equals(signature.getDAIdentifier()) || currentSignature.getSignatureFilename() == null || !currentSignature.getSignatureFilename().equals(signature.getSignatureFilename()))) continue;
            return true;
        }
        return false;
    }

    private void setXmlSigningCertificate(XmlSignature xmlSignature, AdvancedSignature signature) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = signature.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        PublicKey signingCertificatePublicKey = null;
        if (theCertificateValidity != null) {
            xmlSignature.setSigningCertificate(this.getXmlSigningCertificate((Identifier)signature.getDSSId(), theCertificateValidity));
            xmlSignature.setCertificateChain(this.getXmlForCertificateChain(theCertificateValidity, (CertificateSource)signature.getCertificateSource()));
            signingCertificatePublicKey = theCertificateValidity.getPublicKey();
        }
        xmlSignature.setBasicSignature(this.getXmlBasicSignature(signature, signingCertificatePublicKey));
        xmlSignature.setDigestMatchers(this.getXmlDigestMatchers(signature));
    }

    private void setXmlPolicy(XmlSignature xmlSignature, AdvancedSignature signature) {
        if (signature.getSignaturePolicy() != null) {
            XmlPolicyBuilder policyBuilder = this.getPolicyBuilder(signature);
            xmlSignature.setPolicy(policyBuilder.build());
            xmlSignature.setSignaturePolicyStore(policyBuilder.buildSignaturePolicyStore());
        }
    }

    public XmlSignature buildDetachedXmlSignature(AdvancedSignature signature) {
        XmlSignature xmlSignature = new XmlSignature();
        xmlSignature.setSignatureFilename(this.removeSpecialCharsForXml(signature.getSignatureFilename()));
        xmlSignature.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)signature));
        xmlSignature.setDAIdentifier(signature.getDAIdentifier());
        xmlSignature.setClaimedSigningTime(signature.getSigningTime());
        xmlSignature.setStructuralValidation(this.getXmlStructuralValidation(signature));
        xmlSignature.setSignatureFormat(signature.getDataFoundUpToLevel());
        xmlSignature.setSignatureProductionPlace(this.getXmlSignatureProductionPlace(signature.getSignatureProductionPlace()));
        xmlSignature.getCommitmentTypeIndications().addAll(this.getXmlCommitmentTypeIndications(signature.getCommitmentTypeIndications()));
        xmlSignature.getSignerRole().addAll(this.getXmlSignerRoles(signature.getSignerRoles()));
        xmlSignature.setContentType(signature.getContentType());
        xmlSignature.setMimeType(signature.getMimeType());
        xmlSignature.setSignatureDigestReference(this.getXmlSignatureDigestReference(signature));
        xmlSignature.setDataToBeSignedRepresentation(this.getXmlDataToBeSignedRepresentation(signature));
        xmlSignature.setSignerDocumentRepresentations(this.getXmlSignerDocumentRepresentations(signature));
        xmlSignature.setSignatureValue(signature.getSignatureValue());
        return xmlSignature;
    }

    private XmlStructuralValidation getXmlStructuralValidation(AdvancedSignature signature) {
        return this.getXmlStructuralValidation(signature.getStructureValidationResult());
    }

    private XmlStructuralValidation getXmlStructuralValidation(List<String> errorMessages) {
        XmlStructuralValidation xmlStructuralValidation = new XmlStructuralValidation();
        xmlStructuralValidation.setValid(Boolean.valueOf(Utils.isCollectionEmpty(errorMessages)));
        if (Utils.isCollectionNotEmpty(errorMessages)) {
            xmlStructuralValidation.getMessages().addAll(errorMessages);
        }
        return xmlStructuralValidation;
    }

    private XmlSignatureProductionPlace getXmlSignatureProductionPlace(SignatureProductionPlace signatureProductionPlace) {
        if (signatureProductionPlace != null) {
            XmlSignatureProductionPlace xmlSignatureProductionPlace = new XmlSignatureProductionPlace();
            xmlSignatureProductionPlace.setCountryName(this.emptyToNull(signatureProductionPlace.getCountryName()));
            xmlSignatureProductionPlace.setStateOrProvince(this.emptyToNull(signatureProductionPlace.getStateOrProvince()));
            xmlSignatureProductionPlace.setPostOfficeBoxNumber(this.emptyToNull(signatureProductionPlace.getPostOfficeBoxNumber()));
            xmlSignatureProductionPlace.setPostalCode(this.emptyToNull(signatureProductionPlace.getPostalCode()));
            xmlSignatureProductionPlace.setStreetAddress(this.emptyToNull(signatureProductionPlace.getStreetAddress()));
            xmlSignatureProductionPlace.setCity(this.emptyToNull(signatureProductionPlace.getCity()));
            if (Utils.isCollectionNotEmpty((Collection)signatureProductionPlace.getPostalAddress())) {
                xmlSignatureProductionPlace.getPostalAddress().addAll(signatureProductionPlace.getPostalAddress());
            }
            return xmlSignatureProductionPlace;
        }
        return null;
    }

    protected String emptyToNull(String text) {
        if (Utils.isStringEmpty((String)text)) {
            return null;
        }
        return text;
    }

    private List<XmlCommitmentTypeIndication> getXmlCommitmentTypeIndications(List<CommitmentTypeIndication> commitmentTypeIndications) {
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            ArrayList<XmlCommitmentTypeIndication> xmlCommitmentTypeIndications = new ArrayList<XmlCommitmentTypeIndication>();
            for (CommitmentTypeIndication commitmentTypeIndication : commitmentTypeIndications) {
                xmlCommitmentTypeIndications.add(this.getXmlCommitmentTypeIndication(commitmentTypeIndication));
            }
            return xmlCommitmentTypeIndications;
        }
        return Collections.emptyList();
    }

    private XmlCommitmentTypeIndication getXmlCommitmentTypeIndication(CommitmentTypeIndication commitmentTypeIndication) {
        XmlCommitmentTypeIndication xmlCommitmentTypeIndication = new XmlCommitmentTypeIndication();
        xmlCommitmentTypeIndication.setIdentifier(commitmentTypeIndication.getIdentifier());
        xmlCommitmentTypeIndication.setDescription(commitmentTypeIndication.getDescription());
        xmlCommitmentTypeIndication.setDocumentationReferences(commitmentTypeIndication.getDocumentReferences());
        if (commitmentTypeIndication.isAllDataSignedObjects()) {
            xmlCommitmentTypeIndication.setAllDataSignedObjects(Boolean.valueOf(commitmentTypeIndication.isAllDataSignedObjects()));
        } else {
            xmlCommitmentTypeIndication.setObjectReferences(commitmentTypeIndication.getObjectReferences());
        }
        return xmlCommitmentTypeIndication;
    }

    private List<XmlSignerRole> getXmlSignerRoles(Collection<SignerRole> signerRoles) {
        ArrayList<XmlSignerRole> xmlSignerRoles = new ArrayList<XmlSignerRole>();
        if (Utils.isCollectionNotEmpty(signerRoles)) {
            for (SignerRole signerRole : signerRoles) {
                XmlSignerRole xmlSignerRole = new XmlSignerRole();
                xmlSignerRole.setRole(signerRole.getRole());
                xmlSignerRole.setCategory(signerRole.getCategory());
                xmlSignerRole.setNotBefore(signerRole.getNotBefore());
                xmlSignerRole.setNotAfter(signerRole.getNotAfter());
                xmlSignerRoles.add(xmlSignerRole);
            }
        }
        return xmlSignerRoles;
    }

    private XmlBasicSignature getXmlBasicSignature(AdvancedSignature signature, PublicKey signingCertificatePublicKey) {
        XmlBasicSignature xmlBasicSignature = new XmlBasicSignature();
        xmlBasicSignature.setEncryptionAlgoUsedToSignThisToken(signature.getEncryptionAlgorithm());
        xmlBasicSignature.setKeyLengthUsedToSignThisToken(DSSPKUtils.getStringPublicKeySize((PublicKey)signingCertificatePublicKey));
        xmlBasicSignature.setDigestAlgoUsedToSignThisToken(signature.getDigestAlgorithm());
        SignatureCryptographicVerification scv = signature.getSignatureCryptographicVerification();
        xmlBasicSignature.setSignatureIntact(Boolean.valueOf(scv.isSignatureIntact()));
        xmlBasicSignature.setSignatureValid(Boolean.valueOf(scv.isSignatureValid()));
        return xmlBasicSignature;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(AdvancedSignature signature) {
        return this.getXmlDigestMatchers(signature.getReferenceValidations(), signature.getDetachedContents());
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(List<ReferenceValidation> referenceValidations, List<DSSDocument> detachedContents) {
        ArrayList<XmlDigestMatcher> refs = new ArrayList<XmlDigestMatcher>();
        if (Utils.isCollectionNotEmpty(referenceValidations)) {
            for (ReferenceValidation referenceValidation : referenceValidations) {
                refs.add(this.getXmlDigestMatcher(referenceValidation));
                List dependentValidations = referenceValidation.getDependentValidations();
                if (!Utils.isCollectionNotEmpty((Collection)dependentValidations) || !Utils.isCollectionNotEmpty(detachedContents) && !this.isAtLeastOneFound(dependentValidations)) continue;
                for (ReferenceValidation dependentValidation : referenceValidation.getDependentValidations()) {
                    refs.add(this.getXmlDigestMatcher(dependentValidation));
                }
            }
        }
        return refs;
    }

    private List<XmlDigestMatcher> getTimestampReferenceValidationDigestMatchers(List<ReferenceValidation> referenceValidations) {
        ArrayList<XmlDigestMatcher> refs = new ArrayList<XmlDigestMatcher>();
        if (Utils.isCollectionNotEmpty(referenceValidations)) {
            for (ReferenceValidation referenceValidation : referenceValidations) {
                refs.add(this.getXmlDigestMatcher(referenceValidation));
            }
        }
        return refs;
    }

    private XmlDigestMatcher getXmlDigestMatcher(ReferenceValidation referenceValidation) {
        XmlDigestMatcher ref = new XmlDigestMatcher();
        ref.setType(referenceValidation.getType());
        ref.setId(referenceValidation.getId());
        ref.setUri(referenceValidation.getUri());
        ref.setDocumentName(referenceValidation.getDocumentName());
        Digest digest = referenceValidation.getDigest();
        if (digest != null) {
            ref.setDigestValue(digest.getValue());
            ref.setDigestMethod(digest.getAlgorithm());
        }
        ref.setDataFound(referenceValidation.isFound());
        ref.setDataIntact(referenceValidation.isIntact());
        if (referenceValidation.isDuplicated()) {
            ref.setDuplicated(Boolean.valueOf(referenceValidation.isDuplicated()));
        }
        return ref;
    }

    private boolean isAtLeastOneFound(List<ReferenceValidation> referenceValidations) {
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (!referenceValidation.isFound()) continue;
            return true;
        }
        return false;
    }

    private XmlPolicyBuilder getPolicyBuilder(AdvancedSignature signature) {
        SignaturePolicy signaturePolicy = signature.getSignaturePolicy();
        SignaturePolicyStore signaturePolicyStore = signature.getSignaturePolicyStore();
        XmlPolicyBuilder xmlPolicyBuilder = new XmlPolicyBuilder(signaturePolicy);
        xmlPolicyBuilder.setSignaturePolicyStore(signaturePolicyStore);
        return xmlPolicyBuilder;
    }

    private XmlSignatureDigestReference getXmlSignatureDigestReference(AdvancedSignature signature) {
        SignatureDigestReference signatureDigestReference = signature.getSignatureDigestReference(this.defaultDigestAlgorithm);
        if (signatureDigestReference != null) {
            XmlSignatureDigestReference xmlDigestReference = new XmlSignatureDigestReference();
            xmlDigestReference.setCanonicalizationMethod(signatureDigestReference.getCanonicalizationMethod());
            xmlDigestReference.setDigestMethod(signatureDigestReference.getDigestAlgorithm());
            xmlDigestReference.setDigestValue(signatureDigestReference.getDigestValue());
            return xmlDigestReference;
        }
        return null;
    }

    private XmlDigestAlgoAndValue getXmlDataToBeSignedRepresentation(AdvancedSignature signature) {
        Digest dtbsr = signature.getDataToBeSignedRepresentation();
        if (dtbsr != null) {
            return this.getXmlDigestAlgoAndValue(dtbsr);
        }
        return null;
    }

    private XmlSignerDocumentRepresentations getXmlSignerDocumentRepresentations(AdvancedSignature signature) {
        if (Utils.isCollectionEmpty((Collection)signature.getDetachedContents())) {
            return null;
        }
        XmlSignerDocumentRepresentations signerDocumentRepresentation = new XmlSignerDocumentRepresentations();
        signerDocumentRepresentation.setDocHashOnly(signature.isDocHashOnlyValidation());
        signerDocumentRepresentation.setHashOnly(signature.isHashOnlyValidation());
        return signerDocumentRepresentation;
    }

    private XmlFoundRevocations getXmlFoundRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        XmlFoundRevocations foundRevocations = new XmlFoundRevocations();
        foundRevocations.getRelatedRevocations().addAll(this.getXmlRelatedRevocations(crlSource, ocspSource));
        foundRevocations.getOrphanRevocations().addAll(this.getXmlOrphanRevocations(crlSource, ocspSource));
        foundRevocations.getOrphanRevocations().addAll(this.getXmlOrphanRevocationRefs(crlSource, ocspSource));
        return foundRevocations;
    }

    private List<XmlRelatedRevocation> getXmlRelatedRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlRelatedRevocation> xmlRelatedRevocations = new ArrayList<XmlRelatedRevocation>();
        this.addRelatedRevocations(xmlRelatedRevocations, crlSource);
        this.addRelatedRevocations(xmlRelatedRevocations, ocspSource);
        return xmlRelatedRevocations;
    }

    private <R extends Revocation> void addRelatedRevocations(List<XmlRelatedRevocation> result, OfflineRevocationSource<R> source) {
        for (Map.Entry entry : source.getUniqueRevocationTokensWithOrigins().entrySet()) {
            RevocationToken token = (RevocationToken)entry.getKey();
            String id = token.getDSSIdAsString();
            XmlRevocation xmlRevocation = (XmlRevocation)this.xmlRevocationsMap.get(id);
            if (xmlRevocation == null) continue;
            XmlRelatedRevocation xmlRelatedRevocation = new XmlRelatedRevocation();
            xmlRelatedRevocation.setRevocation(xmlRevocation);
            xmlRelatedRevocation.setType(token.getRevocationType());
            xmlRelatedRevocation.getOrigins().addAll((Collection)entry.getValue());
            xmlRelatedRevocation.getRevocationRefs().addAll(this.getXmlRevocationRefs(xmlRevocation.getId(), source.findRefsAndOriginsForRevocationToken(token)));
            result.add(xmlRelatedRevocation);
        }
    }

    private List<XmlOrphanRevocation> getXmlOrphanRevocations(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlOrphanRevocation> xmlOrphanRevocations = new ArrayList<XmlOrphanRevocation>();
        this.addOrphanRevocations(xmlOrphanRevocations, crlSource);
        this.addOrphanRevocations(xmlOrphanRevocations, ocspSource);
        return xmlOrphanRevocations;
    }

    private <R extends Revocation> void addOrphanRevocations(List<XmlOrphanRevocation> xmlOrphanRevocations, OfflineRevocationSource<R> source) {
        Map allBinariesWithOrigins = source.getAllRevocationBinariesWithOrigins();
        for (Map.Entry entry : allBinariesWithOrigins.entrySet()) {
            EncapsulatedRevocationTokenIdentifier token = (EncapsulatedRevocationTokenIdentifier)entry.getKey();
            String tokenId = token.asXmlId();
            if (this.xmlRevocationsMap.containsKey(tokenId)) continue;
            XmlOrphanRevocation xmlOrphanRevocation = this.getXmlOrphanRevocation(token, (Set)entry.getValue());
            xmlOrphanRevocation.getRevocationRefs().addAll(this.getXmlRevocationRefs(tokenId, source.findRefsAndOriginsForBinary(token)));
            xmlOrphanRevocations.add(xmlOrphanRevocation);
        }
    }

    private List<XmlOrphanRevocation> getXmlOrphanRevocationRefs(OfflineRevocationSource<CRL> crlSource, OfflineRevocationSource<OCSP> ocspSource) {
        ArrayList<XmlOrphanRevocation> xmlOrphanRevocationRefs = new ArrayList<XmlOrphanRevocation>();
        this.addOrphanRevocationRefs(xmlOrphanRevocationRefs, crlSource, this.documentCRLSource);
        this.addOrphanRevocationRefs(xmlOrphanRevocationRefs, ocspSource, this.documentOCSPSource);
        return xmlOrphanRevocationRefs;
    }

    private <R extends Revocation> void addOrphanRevocationRefs(List<XmlOrphanRevocation> xmlOrphanRevocationRefs, OfflineRevocationSource<R> source, ListRevocationSource<R> allSources) {
        Map orphanRevocationReferencesWithOrigins = source.getOrphanRevocationReferencesWithOrigins();
        for (Map.Entry entry : orphanRevocationReferencesWithOrigins.entrySet()) {
            RevocationRef ref = (RevocationRef)entry.getKey();
            if (!allSources.isOrphan(ref) || !this.sourceDoesNotContainOrphanBinaries(source, ref)) continue;
            xmlOrphanRevocationRefs.add(this.createOrphanRevocationFromRef(ref, (Set)entry.getValue()));
        }
    }

    private <R extends Revocation> boolean sourceDoesNotContainOrphanBinaries(OfflineRevocationSource<R> source, RevocationRef<R> ref) {
        String tokenId = (String)this.referenceMap.get(ref.getDSSIdAsString());
        if (tokenId == null) {
            return true;
        }
        for (Identifier revocationIdentifier : source.getAllRevocationBinaries()) {
            if (!tokenId.equals(revocationIdentifier.asXmlId())) continue;
            return false;
        }
        return true;
    }

    private <R extends Revocation> XmlOrphanRevocation getXmlOrphanRevocation(EncapsulatedRevocationTokenIdentifier<R> token, Set<RevocationOrigin> origins) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        if (token instanceof CRLBinary) {
            xmlOrphanRevocation.setType(RevocationType.CRL);
        } else {
            xmlOrphanRevocation.setType(RevocationType.OCSP);
        }
        xmlOrphanRevocation.getOrigins().addAll(origins);
        xmlOrphanRevocation.setToken(this.createOrphanTokenFromRevocationIdentifier(token));
        return xmlOrphanRevocation;
    }

    protected <R extends Revocation> XmlOrphanRevocationToken createOrphanTokenFromRevocationIdentifier(EncapsulatedRevocationTokenIdentifier<R> revocationIdentifier) {
        XmlOrphanRevocationToken orphanToken = new XmlOrphanRevocationToken();
        orphanToken.setEncapsulationType(XmlEncapsulationType.BINARIES);
        orphanToken.setId(this.identifierProvider.getIdAsString(revocationIdentifier));
        if (this.tokenExtractionStrategy.isRevocationData()) {
            orphanToken.setBase64Encoded(revocationIdentifier.getBinaries());
        } else {
            byte[] digestValue = revocationIdentifier.getDigestValue(this.defaultDigestAlgorithm);
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, digestValue));
        }
        if (revocationIdentifier instanceof CRLBinary) {
            orphanToken.setRevocationType(RevocationType.CRL);
        } else if (revocationIdentifier instanceof OCSPResponseBinary) {
            orphanToken.setRevocationType(RevocationType.OCSP);
            OCSPResponseBinary ocspResponseBinary = (OCSPResponseBinary)revocationIdentifier;
            OCSPCertificateSource ocspCertificateSource = new OCSPCertificateSource(ocspResponseBinary.getBasicOCSPResp());
            this.getXmlFoundCertificates((Identifier)ocspResponseBinary, (TokenCertificateSource)ocspCertificateSource);
        }
        this.xmlOrphanRevocationTokensMap.put(revocationIdentifier.asXmlId(), orphanToken);
        return orphanToken;
    }

    private <R extends Revocation> XmlOrphanRevocation createOrphanRevocationFromRef(RevocationRef<R> ref, Set<RevocationRefOrigin> origins) {
        XmlOrphanRevocation xmlOrphanRevocation = new XmlOrphanRevocation();
        XmlOrphanRevocationToken orphanToken = new XmlOrphanRevocationToken();
        orphanToken.setEncapsulationType(XmlEncapsulationType.REFERENCE);
        orphanToken.setId(this.identifierProvider.getIdAsString(ref));
        if (ref.getDigest() != null) {
            orphanToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(ref.getDigest()));
        }
        this.xmlOrphanRevocationTokensMap.put(ref.getDSSIdAsString(), orphanToken);
        xmlOrphanRevocation.setToken(orphanToken);
        if (ref instanceof CRLRef) {
            orphanToken.setRevocationType(RevocationType.CRL);
            xmlOrphanRevocation.setType(RevocationType.CRL);
            xmlOrphanRevocation.getRevocationRefs().add(this.getXmlCRLRevocationRef((CRLRef)ref, origins));
        } else {
            orphanToken.setRevocationType(RevocationType.OCSP);
            xmlOrphanRevocation.setType(RevocationType.OCSP);
            xmlOrphanRevocation.getRevocationRefs().add(this.getXmlOCSPRevocationRef((OCSPRef)ref, origins));
        }
        return xmlOrphanRevocation;
    }

    private List<XmlSignatureScope> getXmlSignatureScopes(List<SignatureScope> scopes) {
        ArrayList<XmlSignatureScope> xmlScopes = new ArrayList<XmlSignatureScope>();
        if (Utils.isCollectionNotEmpty(scopes)) {
            for (SignatureScope signatureScope : scopes) {
                xmlScopes.add(this.getXmlSignatureScope(signatureScope));
                if (!Utils.isCollectionNotEmpty((Collection)signatureScope.getChildren())) continue;
                xmlScopes.addAll(this.getXmlSignatureScopes(signatureScope.getChildren()));
            }
        }
        return xmlScopes;
    }

    private XmlSignatureScope getXmlSignatureScope(SignatureScope scope) {
        XmlSignatureScope xmlSignatureScope = new XmlSignatureScope();
        xmlSignatureScope.setName(scope.getName(this.identifierProvider));
        xmlSignatureScope.setScope(scope.getType());
        xmlSignatureScope.setDescription(scope.getDescription(this.identifierProvider));
        xmlSignatureScope.setTransformations(scope.getTransformations());
        xmlSignatureScope.setSignerData(this.xmlSignedDataMap.get(scope.getDSSIdAsString()));
        return xmlSignatureScope;
    }

    private List<XmlEvidenceRecord> buildXmlEvidenceRecords(Collection<EvidenceRecord> evidenceRecords) {
        ArrayList<XmlEvidenceRecord> xmlEvidenceRecords = new ArrayList<XmlEvidenceRecord>();
        if (Utils.isCollectionNotEmpty(evidenceRecords)) {
            for (EvidenceRecord evidenceRecord : evidenceRecords) {
                String id = evidenceRecord.getId();
                XmlEvidenceRecord xmlEvidenceRecord = this.xmlEvidenceRecordMap.get(id);
                if (xmlEvidenceRecord != null) continue;
                xmlEvidenceRecord = this.buildXmlEvidenceRecord(evidenceRecord);
                xmlEvidenceRecords.add(xmlEvidenceRecord);
            }
        }
        return xmlEvidenceRecords;
    }

    private XmlEvidenceRecord buildXmlEvidenceRecord(EvidenceRecord evidenceRecord) {
        XmlEvidenceRecord xmlEvidenceRecord = new XmlEvidenceRecord();
        this.checkDuplicates(xmlEvidenceRecord, evidenceRecord);
        xmlEvidenceRecord.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)evidenceRecord));
        xmlEvidenceRecord.setDocumentName(evidenceRecord.getFilename());
        xmlEvidenceRecord.setType(evidenceRecord.getReferenceRecordType());
        xmlEvidenceRecord.setStructuralValidation(this.getXmlStructuralValidation(evidenceRecord));
        xmlEvidenceRecord.setDigestMatchers(this.getXmlDigestMatchers(evidenceRecord));
        xmlEvidenceRecord.setEvidenceRecordScopes(this.getXmlSignatureScopes(evidenceRecord.getEvidenceRecordScopes()));
        xmlEvidenceRecord.setFoundCertificates(this.getXmlFoundCertificates(evidenceRecord.getCertificateSource()));
        xmlEvidenceRecord.setFoundRevocations(this.getXmlFoundRevocations((OfflineRevocationSource<CRL>)evidenceRecord.getCRLSource(), (OfflineRevocationSource<OCSP>)evidenceRecord.getOCSPSource()));
        byte[] encoded = evidenceRecord.getEncoded();
        if (this.tokenExtractionStrategy.isEvidenceRecord()) {
            xmlEvidenceRecord.setBase64Encoded(encoded);
        } else {
            byte[] digest = DSSUtils.digest((DigestAlgorithm)this.defaultDigestAlgorithm, (byte[])encoded);
            xmlEvidenceRecord.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, digest));
        }
        this.xmlEvidenceRecordMap.put(evidenceRecord.getId(), xmlEvidenceRecord);
        return xmlEvidenceRecord;
    }

    private void checkDuplicates(XmlEvidenceRecord xmlEvidenceRecord, EvidenceRecord evidenceRecord) {
        if (this.hasDuplicate(evidenceRecord)) {
            xmlEvidenceRecord.setDuplicated(Boolean.valueOf(true));
        }
    }

    private boolean hasDuplicate(EvidenceRecord currentEvidenceRecord) {
        for (EvidenceRecord evidenceRecord : this.evidenceRecords) {
            if (currentEvidenceRecord == evidenceRecord || !currentEvidenceRecord.getId().equals(evidenceRecord.getId())) continue;
            return true;
        }
        return false;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(EvidenceRecord evidenceRecord) {
        return this.getXmlDigestMatchers(evidenceRecord.getReferenceValidation(), Collections.emptyList());
    }

    private void linkSignaturesAndEvidenceRecords(Collection<AdvancedSignature> signatures) {
        for (AdvancedSignature signature : signatures) {
            XmlSignature xmlSignature = this.xmlSignaturesMap.get(signature.getId());
            xmlSignature.setFoundEvidenceRecords(this.getXmlSignatureEvidenceRecords(signature));
        }
    }

    private List<XmlFoundEvidenceRecord> getXmlSignatureEvidenceRecords(AdvancedSignature signature) {
        ArrayList<XmlFoundEvidenceRecord> foundEvidenceRecords = new ArrayList<XmlFoundEvidenceRecord>();
        for (EvidenceRecord evidenceRecord : signature.getAllEvidenceRecords()) {
            XmlFoundEvidenceRecord foundEvidenceRecord = new XmlFoundEvidenceRecord();
            foundEvidenceRecord.setEvidenceRecord(this.xmlEvidenceRecordMap.get(evidenceRecord.getId()));
            foundEvidenceRecords.add(foundEvidenceRecord);
        }
        return foundEvidenceRecords;
    }

    private void linkTimestampsAndEvidenceRecords(Collection<TimestampToken> timestampTokens) {
        for (TimestampToken timestampToken : timestampTokens) {
            XmlTimestamp xmlTimestamp = this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString());
            xmlTimestamp.setFoundEvidenceRecords(this.getXmlTimestampEvidenceRecords(timestampToken));
        }
    }

    private List<XmlFoundEvidenceRecord> getXmlTimestampEvidenceRecords(TimestampToken timestampToken) {
        ArrayList<XmlFoundEvidenceRecord> foundEvidenceRecords = new ArrayList<XmlFoundEvidenceRecord>();
        for (EvidenceRecord evidenceRecord : timestampToken.getDetachedEvidenceRecords()) {
            XmlFoundEvidenceRecord foundEvidenceRecord = new XmlFoundEvidenceRecord();
            foundEvidenceRecord.setEvidenceRecord(this.xmlEvidenceRecordMap.get(evidenceRecord.getId()));
            foundEvidenceRecords.add(foundEvidenceRecord);
        }
        return foundEvidenceRecords;
    }

    private void linkEvidenceRecordsAndTimestamps(Collection<EvidenceRecord> evidenceRecords) {
        for (EvidenceRecord evidenceRecord : evidenceRecords) {
            XmlEvidenceRecord currentEvidenceRecord = this.xmlEvidenceRecordMap.get(evidenceRecord.getId());
            currentEvidenceRecord.setEvidenceRecordTimestamps(this.getXmlEvidenceRecordTimestamps(evidenceRecord));
        }
    }

    private List<XmlFoundTimestamp> getXmlEvidenceRecordTimestamps(EvidenceRecord evidenceRecord) {
        ArrayList<XmlFoundTimestamp> foundTimestamps = new ArrayList<XmlFoundTimestamp>();
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            XmlFoundTimestamp foundTimestamp = new XmlFoundTimestamp();
            foundTimestamp.setTimestamp(this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString()));
            foundTimestamps.add(foundTimestamp);
        }
        return foundTimestamps;
    }

    private XmlStructuralValidation getXmlStructuralValidation(EvidenceRecord evidenceRecord) {
        return this.getXmlStructuralValidation(evidenceRecord.getStructureValidationResult());
    }

    private List<XmlTimestamp> buildXmlTimestamps(Collection<TimestampToken> timestamps) {
        ArrayList<XmlTimestamp> xmlTimestampsList = new ArrayList<XmlTimestamp>();
        if (Utils.isCollectionNotEmpty(timestamps)) {
            ArrayList<TimestampToken> tokens = new ArrayList<TimestampToken>(timestamps);
            tokens.sort((Comparator<TimestampToken>)new TimestampTokenComparator());
            for (TimestampToken timestampToken : tokens) {
                String id = timestampToken.getDSSIdAsString();
                XmlTimestamp xmlTimestamp = this.xmlTimestampsMap.get(id);
                if (xmlTimestamp != null) continue;
                xmlTimestamp = this.buildDetachedXmlTimestamp(timestampToken);
                xmlTimestampsList.add(xmlTimestamp);
            }
        }
        return xmlTimestampsList;
    }

    protected XmlTimestamp buildDetachedXmlTimestamp(TimestampToken timestampToken) {
        XmlTimestamp xmlTimestampToken = new XmlTimestamp();
        this.checkDuplicates(xmlTimestampToken, timestampToken);
        xmlTimestampToken.setId(this.identifierProvider.getIdAsString((IdentifierBasedObject)timestampToken));
        xmlTimestampToken.setType(timestampToken.getTimeStampType());
        xmlTimestampToken.setArchiveTimestampType(timestampToken.getArchiveTimestampType());
        xmlTimestampToken.setEvidenceRecordTimestampType(timestampToken.getEvidenceRecordTimestampType());
        xmlTimestampToken.setProductionTime(timestampToken.getGenerationTime());
        xmlTimestampToken.setTimestampFilename(timestampToken.getFileName());
        xmlTimestampToken.getDigestMatchers().addAll(this.getXmlDigestMatchers(timestampToken));
        xmlTimestampToken.setBasicSignature(this.getXmlBasicSignature((Token)timestampToken));
        xmlTimestampToken.setSignerInformationStore(this.getXmlSignerInformationStore(timestampToken.getSignerInformationStoreInfos()));
        xmlTimestampToken.setTSAGeneralName(this.getXmlTSAGeneralName(timestampToken));
        CandidatesForSigningCertificate candidatesForSigningCertificate = timestampToken.getCandidatesForSigningCertificate();
        CertificateValidity theCertificateValidity = candidatesForSigningCertificate.getTheCertificateValidity();
        if (theCertificateValidity != null) {
            xmlTimestampToken.setSigningCertificate(this.getXmlSigningCertificate((Identifier)timestampToken.getDSSId(), theCertificateValidity));
            xmlTimestampToken.setCertificateChain(this.getXmlForCertificateChain(theCertificateValidity, (CertificateSource)timestampToken.getCertificateSource()));
        }
        xmlTimestampToken.setFoundCertificates(this.getXmlFoundCertificates((Identifier)timestampToken.getDSSId(), (TokenCertificateSource)timestampToken.getCertificateSource()));
        xmlTimestampToken.setFoundRevocations(this.getXmlFoundRevocations((OfflineRevocationSource<CRL>)timestampToken.getCRLSource(), (OfflineRevocationSource<OCSP>)timestampToken.getOCSPSource()));
        if (Utils.isCollectionNotEmpty((Collection)timestampToken.getTimestampScopes())) {
            xmlTimestampToken.setTimestampScopes(this.getXmlSignatureScopes(timestampToken.getTimestampScopes()));
        }
        if (this.tokenExtractionStrategy.isTimestamp()) {
            xmlTimestampToken.setBase64Encoded(timestampToken.getEncoded());
        } else {
            byte[] tstDigest = timestampToken.getDigest(this.defaultDigestAlgorithm);
            xmlTimestampToken.setDigestAlgoAndValue(this.getXmlDigestAlgoAndValue(this.defaultDigestAlgorithm, tstDigest));
        }
        this.xmlTimestampsMap.put(timestampToken.getDSSIdAsString(), xmlTimestampToken);
        return xmlTimestampToken;
    }

    private void checkDuplicates(XmlTimestamp xmlTimestamp, TimestampToken timestampToken) {
        if (this.hasDuplicate(timestampToken)) {
            xmlTimestamp.setDuplicated(Boolean.valueOf(true));
        }
    }

    private boolean hasDuplicate(TimestampToken currentTimestampToken) {
        for (TimestampToken timestampToken : this.usedTimestamps) {
            if (currentTimestampToken == timestampToken || !currentTimestampToken.getDSSIdAsString().equals(timestampToken.getDSSIdAsString())) continue;
            return true;
        }
        return false;
    }

    private List<XmlDigestMatcher> getXmlDigestMatchers(TimestampToken timestampToken) {
        ArrayList<XmlDigestMatcher> digestMatchers = new ArrayList<XmlDigestMatcher>();
        digestMatchers.add(this.getImprintDigestMatcher(timestampToken));
        digestMatchers.addAll(this.getManifestEntriesDigestMatchers(timestampToken.getManifestFile()));
        digestMatchers.addAll(this.getTimestampReferenceValidationDigestMatchers(timestampToken.getReferenceValidations()));
        return digestMatchers;
    }

    private XmlDigestMatcher getImprintDigestMatcher(TimestampToken timestampToken) {
        XmlDigestMatcher digestMatcher = new XmlDigestMatcher();
        digestMatcher.setType(DigestMatcherType.MESSAGE_IMPRINT);
        Digest messageImprint = timestampToken.getMessageImprint();
        if (messageImprint != null) {
            digestMatcher.setDigestMethod(messageImprint.getAlgorithm());
            digestMatcher.setDigestValue(messageImprint.getValue());
        }
        digestMatcher.setDataFound(timestampToken.isMessageImprintDataFound());
        digestMatcher.setDataIntact(timestampToken.isMessageImprintDataIntact());
        ManifestFile manifestFile = timestampToken.getManifestFile();
        if (manifestFile != null) {
            digestMatcher.setDocumentName(manifestFile.getFilename());
        }
        return digestMatcher;
    }

    private List<XmlDigestMatcher> getManifestEntriesDigestMatchers(ManifestFile manifestFile) {
        ArrayList<XmlDigestMatcher> digestMatchers = new ArrayList<XmlDigestMatcher>();
        if (manifestFile != null && Utils.isCollectionNotEmpty((Collection)manifestFile.getEntries())) {
            for (ManifestEntry entry : manifestFile.getEntries()) {
                XmlDigestMatcher digestMatcher = new XmlDigestMatcher();
                digestMatcher.setType(DigestMatcherType.MANIFEST_ENTRY);
                Digest digest = entry.getDigest();
                if (digest != null) {
                    digestMatcher.setDigestMethod(digest.getAlgorithm());
                    digestMatcher.setDigestValue(digest.getValue());
                }
                digestMatcher.setDataFound(entry.isFound());
                digestMatcher.setDataIntact(entry.isIntact());
                digestMatcher.setUri(entry.getUri());
                digestMatcher.setDocumentName(entry.getDocumentName());
                digestMatchers.add(digestMatcher);
            }
        }
        return digestMatchers;
    }

    protected List<XmlSignerInfo> getXmlSignerInformationStore(Set<SignerIdentifier> signerIdentifiers) {
        if (Utils.isCollectionNotEmpty(signerIdentifiers)) {
            ArrayList<XmlSignerInfo> signerInfos = new ArrayList<XmlSignerInfo>();
            for (SignerIdentifier signerIdentifier : signerIdentifiers) {
                signerInfos.add(this.getXmlSignerInfo(signerIdentifier));
            }
            return signerInfos;
        }
        return null;
    }

    private XmlTSAGeneralName getXmlTSAGeneralName(TimestampToken timestampToken) {
        X500Principal tstInfoTsa = timestampToken.getTSTInfoTsa();
        if (tstInfoTsa != null) {
            XmlTSAGeneralName xmlTSAGeneralName = new XmlTSAGeneralName();
            X500PrincipalHelper x500PrincipalHelper = new X500PrincipalHelper(tstInfoTsa);
            xmlTSAGeneralName.setValue(x500PrincipalHelper.getRFC2253());
            X500Principal issuerX500Principal = timestampToken.getIssuerX500Principal();
            if (issuerX500Principal != null) {
                xmlTSAGeneralName.setContentMatch(DSSASN1Utils.x500PrincipalAreEquals((X500Principal)tstInfoTsa, (X500Principal)issuerX500Principal));
                xmlTSAGeneralName.setOrderMatch(tstInfoTsa.equals(issuerX500Principal));
            }
            return xmlTSAGeneralName;
        }
        return null;
    }

    private void linkSignaturesAndTimestamps(Collection<AdvancedSignature> signatures) {
        for (AdvancedSignature advancedSignature : signatures) {
            XmlSignature currentSignature = this.xmlSignaturesMap.get(advancedSignature.getId());
            currentSignature.setFoundTimestamps(this.getXmlFoundTimestamps(advancedSignature));
        }
    }

    private List<XmlFoundTimestamp> getXmlFoundTimestamps(AdvancedSignature signature) {
        ArrayList<XmlFoundTimestamp> foundTimestamps = new ArrayList<XmlFoundTimestamp>();
        for (TimestampToken timestampToken : signature.getAllTimestamps()) {
            XmlFoundTimestamp foundTimestamp = new XmlFoundTimestamp();
            foundTimestamp.setTimestamp(this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString()));
            foundTimestamps.add(foundTimestamp);
        }
        return foundTimestamps;
    }

    private void linkTimestampsAndTimestampsObjects(Collection<TimestampToken> timestamps) {
        for (TimestampToken timestampToken : timestamps) {
            XmlTimestamp xmlTimestampToken = this.xmlTimestampsMap.get(timestampToken.getDSSIdAsString());
            xmlTimestampToken.setTimestampedObjects(this.getXmlTimestampedObjects(timestampToken.getTimestampedReferences()));
        }
    }

    private void linkEvidenceRecordsAndTimestampsObjects(Collection<EvidenceRecord> evidenceRecords) {
        for (EvidenceRecord evidenceRecord : evidenceRecords) {
            XmlEvidenceRecord xmlEvidenceRecord = this.xmlEvidenceRecordMap.get(evidenceRecord.getId());
            xmlEvidenceRecord.setTimestampedObjects(this.getXmlTimestampedObjects(evidenceRecord.getTimestampedReferences()));
        }
    }

    private List<XmlTimestampedObject> getXmlTimestampedObjects(List<TimestampedReference> timestampReferences) {
        if (Utils.isCollectionNotEmpty(timestampReferences)) {
            ArrayList<XmlTimestampedObject> objects = new ArrayList<XmlTimestampedObject>();
            HashSet<String> addedTokenIds = new HashSet<String>();
            for (TimestampedReference timestampReference : timestampReferences) {
                String id = timestampReference.getObjectId();
                XmlTimestampedObject timestampedObject = this.createXmlTimestampedObject(timestampReference);
                if (timestampedObject.getToken() == null) {
                    throw new DSSException(String.format("Token with Id '%s' not found", id));
                }
                id = timestampedObject.getToken().getId();
                if (addedTokenIds.contains(id)) continue;
                addedTokenIds.add(id);
                objects.add(timestampedObject);
            }
            return objects;
        }
        return null;
    }

    private XmlTimestampedObject createXmlTimestampedObject(TimestampedReference timestampReference) {
        XmlTimestampedObject timestampedObj = new XmlTimestampedObject();
        timestampedObj.setCategory(timestampReference.getCategory());
        String objectId = timestampReference.getObjectId();
        switch (timestampReference.getCategory()) {
            case SIGNATURE: {
                timestampedObj.setToken((XmlAbstractToken)this.xmlSignaturesMap.get(objectId));
                return timestampedObj;
            }
            case CERTIFICATE: {
                String relatedCertificateId;
                if (!this.isUsedToken(objectId, this.usedCertificates) && ((relatedCertificateId = (String)this.referenceMap.get(objectId)) == null || !this.isUsedToken(objectId = relatedCertificateId, this.usedCertificates))) break;
                timestampedObj.setToken((XmlAbstractToken)this.xmlCertsMap.get(objectId));
                return timestampedObj;
            }
            case REVOCATION: {
                String relatedRevocationId;
                if (!this.isUsedToken(objectId, this.usedRevocations) && ((relatedRevocationId = (String)this.referenceMap.get(objectId)) == null || !this.isUsedToken(objectId = relatedRevocationId, this.usedRevocations))) break;
                timestampedObj.setToken((XmlAbstractToken)this.xmlRevocationsMap.get(objectId));
                return timestampedObj;
            }
            case TIMESTAMP: {
                timestampedObj.setToken((XmlAbstractToken)this.xmlTimestampsMap.get(objectId));
                return timestampedObj;
            }
            case EVIDENCE_RECORD: {
                timestampedObj.setToken((XmlAbstractToken)this.xmlEvidenceRecordMap.get(objectId));
                return timestampedObj;
            }
            case SIGNED_DATA: {
                timestampedObj.setToken((XmlAbstractToken)this.xmlSignedDataMap.get(objectId));
                return timestampedObj;
            }
            default: {
                throw new DSSException(String.format("Unsupported category '%s'", timestampReference.getCategory()));
            }
        }
        if (TimestampedObjectType.CERTIFICATE.equals((Object)timestampedObj.getCategory())) {
            timestampedObj.setToken((XmlAbstractToken)this.xmlOrphanCertificateTokensMap.get(objectId));
            timestampedObj.setCategory(TimestampedObjectType.ORPHAN_CERTIFICATE);
        } else if (TimestampedObjectType.REVOCATION.equals((Object)timestampedObj.getCategory())) {
            timestampedObj.setToken((XmlAbstractToken)this.xmlOrphanRevocationTokensMap.get(objectId));
            timestampedObj.setCategory(TimestampedObjectType.ORPHAN_REVOCATION);
        } else {
            throw new DSSException(String.format("The type of object [%s] is not supported for Orphan Tokens!", timestampedObj.getCategory()));
        }
        return timestampedObj;
    }

    private <T extends Token> boolean isUsedToken(String tokenId, Collection<T> usedTokens) {
        for (Token token : usedTokens) {
            if (!token.getDSSIdAsString().equals(tokenId)) continue;
            return true;
        }
        return false;
    }
}

