/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.fc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlFC;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class CAdESV3HashIndexCheck
extends ChainItem<XmlFC> {
    private final TimestampWrapper timestamp;

    public CAdESV3HashIndexCheck(I18nProvider i18nProvider, XmlFC result, TimestampWrapper timestamp, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.timestamp = timestamp;
    }

    @Override
    protected boolean process() {
        if (TimestampType.ARCHIVE_TIMESTAMP == this.timestamp.getType() && ArchiveTimestampType.CAdES_V3 == this.timestamp.getArchiveTimestampType()) {
            return this.timestamp.isAtsHashIndexValid();
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_FC_IAHIV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_FC_IAHIV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

