/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public class ControlTimeCheck
extends ChainItem<XmlVTS> {
    private final Date controlTime;

    public ControlTimeCheck(I18nProvider i18nProvider, XmlVTS result, Date controlTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.controlTime = controlTime;
    }

    @Override
    protected boolean process() {
        return this.controlTime != null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_ICTD;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_ICTD_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_POE;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (this.controlTime != null) {
            return this.i18nProvider.getMessage(MessageTag.CONTROL_TIME_ALONE, new Object[]{ValidationProcessUtils.getFormattedDate(this.controlTime)});
        }
        return null;
    }
}

