/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.evidencerecord.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessEvidenceRecord;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.Collection;
import java.util.List;

public class EvidenceRecordSignedFilesCoveredCheck
extends ChainItem<XmlValidationProcessEvidenceRecord> {
    private final EvidenceRecordWrapper evidenceRecord;

    public EvidenceRecordSignedFilesCoveredCheck(I18nProvider i18nProvider, XmlValidationProcessEvidenceRecord result, EvidenceRecordWrapper evidenceRecord, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.evidenceRecord = evidenceRecord;
    }

    @Override
    protected boolean process() {
        List coveredSignatures = this.evidenceRecord.getCoveredSignatures();
        List evidenceRecordDigestMatchers = this.evidenceRecord.getDigestMatchers();
        if (Utils.isCollectionNotEmpty((Collection)coveredSignatures)) {
            for (SignatureWrapper signature : coveredSignatures) {
                List digestMatchers = signature.getDigestMatchers();
                if (digestMatchers.stream().allMatch(s -> s.getDocumentName() == null || evidenceRecordDigestMatchers.stream().anyMatch(e -> s.getDocumentName().equals(e.getDocumentName())))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_CV_ER_HASSDOC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_CV_ER_HASSDOC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.FORMAT_FAILURE;
    }
}

