/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpftsp;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlEvidenceRecord;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalDataTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessBasicTimestamp;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationTimestampQualification;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.EvidenceRecordWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationLevel;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.qualification.timestamp.TimestampQualificationBlock;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpftsp.TimestampBasicValidationProcess;
import eu.europa.esig.dss.validation.process.vpftspwatsp.ValidationProcessForTimestampsWithArchivalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TimestampsValidationBlock {
    private final I18nProvider i18nProvider;
    protected final List<TimestampWrapper> timestamps;
    private final DiagnosticData diagnosticData;
    protected final ValidationPolicy policy;
    protected final Date currentTime;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final Map<String, XmlEvidenceRecord> evidenceRecordValidations;
    private final List<XmlTLAnalysis> tlAnalysis;
    private final ValidationLevel validationLevel;
    private final POEExtraction poe;

    public TimestampsValidationBlock(I18nProvider i18nProvider, List<TimestampWrapper> timestamps, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, Map<String, XmlEvidenceRecord> evidenceRecordValidations, List<XmlTLAnalysis> tlAnalysis, ValidationLevel validationLevel, POEExtraction poe) {
        this.i18nProvider = i18nProvider;
        this.timestamps = timestamps;
        this.diagnosticData = diagnosticData;
        this.policy = policy;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.evidenceRecordValidations = evidenceRecordValidations;
        this.tlAnalysis = tlAnalysis;
        this.validationLevel = validationLevel;
        this.poe = poe;
    }

    protected TimestampsValidationBlock(I18nProvider i18nProvider, List<TimestampWrapper> timestamps, DiagnosticData diagnosticData, ValidationPolicy policy, Date currentTime, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis, ValidationLevel validationLevel) {
        this.i18nProvider = i18nProvider;
        this.timestamps = timestamps;
        this.diagnosticData = diagnosticData;
        this.policy = policy;
        this.currentTime = currentTime;
        this.bbbs = bbbs;
        this.evidenceRecordValidations = Collections.emptyMap();
        this.tlAnalysis = tlAnalysis;
        this.validationLevel = validationLevel;
        this.poe = new POEExtraction();
        this.poe.init(diagnosticData, currentTime);
    }

    public Map<String, XmlTimestamp> execute() {
        HashMap<String, XmlTimestamp> result = new HashMap<String, XmlTimestamp>();
        for (TimestampWrapper newestTimestamp : this.getTimestamps()) {
            XmlTimestamp xmlTimestamp = this.buildXmlTimestamp(newestTimestamp, this.bbbs, this.tlAnalysis);
            result.put(newestTimestamp.getId(), xmlTimestamp);
        }
        return result;
    }

    protected List<TimestampWrapper> getTimestamps() {
        ArrayList<TimestampWrapper> timestampList = new ArrayList<TimestampWrapper>(this.timestamps);
        timestampList.sort(Comparator.comparing(TimestampWrapper::getProductionTime).reversed());
        return timestampList;
    }

    private XmlTimestamp buildXmlTimestamp(TimestampWrapper timestamp, Map<String, XmlBasicBuildingBlocks> bbbs, List<XmlTLAnalysis> tlAnalysis) {
        XmlTimestamp xmlTimestamp = new XmlTimestamp();
        xmlTimestamp.setId(timestamp.getId());
        POEExtraction currentPOE = this.getPoe(timestamp);
        TimestampBasicValidationProcess vpftsp = new TimestampBasicValidationProcess(this.i18nProvider, this.diagnosticData, timestamp, bbbs);
        XmlValidationProcessBasicTimestamp validationProcessBasicTimestamp = (XmlValidationProcessBasicTimestamp)vpftsp.execute();
        xmlTimestamp.setValidationProcessBasicTimestamp(validationProcessBasicTimestamp);
        XmlConclusion conclusion = validationProcessBasicTimestamp.getConclusion();
        if (this.policy.isEIDASConstraintPresent()) {
            TimestampQualificationBlock timestampQualificationBlock = new TimestampQualificationBlock(this.i18nProvider, timestamp, tlAnalysis, currentPOE);
            xmlTimestamp.setValidationTimestampQualification((XmlValidationTimestampQualification)timestampQualificationBlock.execute());
        }
        if (ValidationLevel.ARCHIVAL_DATA.equals((Object)this.validationLevel)) {
            for (EvidenceRecordWrapper sigEvidenceRecord : timestamp.getEvidenceRecords()) {
                xmlTimestamp.getEvidenceRecords().add(this.evidenceRecordValidations.get(sigEvidenceRecord.getId()));
            }
            ValidationProcessForTimestampsWithArchivalData vpftspwatst = new ValidationProcessForTimestampsWithArchivalData(this.i18nProvider, timestamp, validationProcessBasicTimestamp, bbbs, this.evidenceRecordValidations, this.currentTime, this.policy, currentPOE);
            XmlValidationProcessArchivalDataTimestamp validationProcessTimestampArchivalData = (XmlValidationProcessArchivalDataTimestamp)vpftspwatst.execute();
            if (validationProcessTimestampArchivalData.getConclusion() != null && Indication.PASSED == validationProcessTimestampArchivalData.getConclusion().getIndication()) {
                currentPOE.extractPOE(timestamp);
            }
            xmlTimestamp.setValidationProcessArchivalDataTimestamp(validationProcessTimestampArchivalData);
            conclusion = validationProcessTimestampArchivalData.getConclusion();
        }
        xmlTimestamp.setConclusion(conclusion);
        return xmlTimestamp;
    }

    protected POEExtraction getPoe(TimestampWrapper timestamp) {
        return this.poe;
    }
}

