/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.reports.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateContentEquivalence;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateExtension;
import eu.europa.esig.dss.diagnostic.jaxb.XmlLangAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlMRACertificateMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlMRATrustServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryQcStatementsMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOriginalThirdCountryTrustServiceMapping;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQcStatements;
import eu.europa.esig.dss.diagnostic.jaxb.XmlQualifier;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceEquivalenceInformation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustServiceProvider;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;
import eu.europa.esig.dss.enumerations.MRAEquivalenceContext;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.QCTypeEnum;
import eu.europa.esig.dss.model.timedependent.MutableTimeDependentValues;
import eu.europa.esig.dss.model.timedependent.TimeDependentValues;
import eu.europa.esig.dss.model.tsl.CertificateContentEquivalence;
import eu.europa.esig.dss.model.tsl.Condition;
import eu.europa.esig.dss.model.tsl.ConditionForQualifiers;
import eu.europa.esig.dss.model.tsl.LOTLInfo;
import eu.europa.esig.dss.model.tsl.MRA;
import eu.europa.esig.dss.model.tsl.QCStatementOids;
import eu.europa.esig.dss.model.tsl.ServiceEquivalence;
import eu.europa.esig.dss.model.tsl.ServiceTypeASi;
import eu.europa.esig.dss.model.tsl.TLInfo;
import eu.europa.esig.dss.model.tsl.TrustProperties;
import eu.europa.esig.dss.model.tsl.TrustServiceProvider;
import eu.europa.esig.dss.model.tsl.TrustServiceStatusAndInformationExtensions;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.QcStatementUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.reports.diagnostic.XmlQcStatementsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlTrustServiceProviderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(XmlTrustServiceProviderBuilder.class);
    private final Map<String, XmlCertificate> xmlCertsMap;
    private final Map<String, XmlTrustedList> xmlTrustedListsMap;
    private final Map<String, TLInfo> tlInfoMap;
    private final XmlQcStatementsBuilder qcStatementsBuilder = new XmlQcStatementsBuilder();

    public XmlTrustServiceProviderBuilder(Map<String, XmlCertificate> xmlCertsMap, Map<String, XmlTrustedList> xmlTrustedListsMap, Map<String, TLInfo> tlInfoMap) {
        this.xmlCertsMap = xmlCertsMap;
        this.xmlTrustedListsMap = xmlTrustedListsMap;
        this.tlInfoMap = tlInfoMap;
    }

    public List<XmlTrustServiceProvider> build(CertificateToken certificateToken, Map<CertificateToken, List<TrustProperties>> relatedTrustServices) {
        ArrayList<XmlTrustServiceProvider> result = new ArrayList<XmlTrustServiceProvider>();
        for (Map.Entry<CertificateToken, List<TrustProperties>> entry : relatedTrustServices.entrySet()) {
            CertificateToken trustedCert = entry.getKey();
            List<TrustProperties> services = entry.getValue();
            Map<TrustServiceProvider, List<TrustProperties>> servicesByProviders = this.classifyByServiceProvider(services);
            for (Map.Entry<TrustServiceProvider, List<TrustProperties>> servicesByProvider : servicesByProviders.entrySet()) {
                List<TrustProperties> trustServices = servicesByProvider.getValue();
                if (!Utils.isCollectionNotEmpty(trustServices)) continue;
                result.add(this.getXmlTrustServiceProvider(certificateToken, trustServices, trustedCert));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private Map<TrustServiceProvider, List<TrustProperties>> classifyByServiceProvider(List<TrustProperties> trustPropertiesList) {
        HashMap<TrustServiceProvider, List<TrustProperties>> servicesByProviders = new HashMap<TrustServiceProvider, List<TrustProperties>>();
        if (Utils.isCollectionNotEmpty(trustPropertiesList)) {
            for (TrustProperties trustProperties : trustPropertiesList) {
                TrustServiceProvider currentTrustServiceProvider = trustProperties.getTrustServiceProvider();
                List list = servicesByProviders.computeIfAbsent(currentTrustServiceProvider, k -> new ArrayList());
                list.add(trustProperties);
            }
        }
        return servicesByProviders;
    }

    private XmlTrustServiceProvider getXmlTrustServiceProvider(CertificateToken certificateToken, List<TrustProperties> trustServices, CertificateToken trustAnchor) {
        TLInfo tlInfo;
        TrustProperties trustProperties = trustServices.iterator().next();
        XmlTrustServiceProvider result = new XmlTrustServiceProvider();
        LOTLInfo lotlInfo = trustProperties.getLOTLInfo();
        if (lotlInfo != null) {
            XmlTrustedList xmlLOTL = this.xmlTrustedListsMap.get(lotlInfo.getDSSIdAsString());
            if (xmlLOTL == null) {
                throw new IllegalStateException(String.format("LOTL with Id '%s' has not been found! Please verify TrustedListsCertificateSource contains TLValidationSummary.", lotlInfo.getDSSIdAsString()));
            }
            result.setLOTL(xmlLOTL);
        }
        if ((tlInfo = trustProperties.getTLInfo()) != null) {
            XmlTrustedList xmlTL = this.xmlTrustedListsMap.get(tlInfo.getDSSIdAsString());
            if (xmlTL == null) {
                throw new IllegalStateException(String.format("TL with Id '%s' has not been found! Please verify TrustedListsCertificateSource contains TLValidationSummary.", tlInfo.getDSSIdAsString()));
            }
            result.setTL(xmlTL);
        }
        TrustServiceProvider tsp = trustProperties.getTrustServiceProvider();
        result.setTSPNames(this.getLangAndValues(tsp.getNames()));
        result.setTSPTradeNames(this.getLangAndValues(tsp.getTradeNames()));
        result.setTSPRegistrationIdentifiers(tsp.getRegistrationIdentifiers());
        result.setTrustServices(this.buildXmlTrustServicesList(certificateToken, trustServices, trustAnchor));
        return result;
    }

    private List<XmlLangAndValue> getLangAndValues(Map<String, List<String>> map) {
        if (Utils.isMapNotEmpty(map)) {
            ArrayList<XmlLangAndValue> result = new ArrayList<XmlLangAndValue>();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String lang = entry.getKey();
                for (String value : entry.getValue()) {
                    XmlLangAndValue langAndValue = new XmlLangAndValue();
                    langAndValue.setLang(lang);
                    langAndValue.setValue(value);
                    result.add(langAndValue);
                }
            }
            return result;
        }
        return null;
    }

    private List<XmlTrustService> buildXmlTrustServicesList(CertificateToken certToken, List<TrustProperties> trustServices, CertificateToken trustAnchor) {
        ArrayList<XmlTrustService> result = new ArrayList<XmlTrustService>();
        for (TrustProperties trustProperties : trustServices) {
            TimeDependentValues trustService = trustProperties.getTrustService();
            List serviceStatusAfterOfEqualsCertIssuance = trustService.getAfter(certToken.getNotBefore());
            if (!Utils.isCollectionNotEmpty((Collection)serviceStatusAfterOfEqualsCertIssuance)) continue;
            for (TrustServiceStatusAndInformationExtensions serviceInfoStatus : serviceStatusAfterOfEqualsCertIssuance) {
                MRA mra = this.getMRA(trustProperties);
                if (mra != null) {
                    result.addAll(this.buildXmlTrustServicesWithMRA(serviceInfoStatus, certToken, trustAnchor, mra));
                    continue;
                }
                result.add(this.getXmlTrustService(serviceInfoStatus, certToken, trustAnchor));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private MRA getMRA(TrustProperties trustProperties) {
        TLInfo tlInfo;
        if (trustProperties.getTLInfo() != null && (tlInfo = this.tlInfoMap.get(trustProperties.getTLInfo().getDSSIdAsString())) != null && tlInfo.getOtherTSLPointer() != null) {
            return tlInfo.getOtherTSLPointer().getMra();
        }
        return null;
    }

    private XmlTrustService getXmlTrustService(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor) {
        List serviceSupplyPoints;
        List additionalServiceInfoUris;
        XmlTrustService trustService = new XmlTrustService();
        trustService.setServiceDigitalIdentifier(this.xmlCertsMap.get(trustAnchor.getDSSIdAsString()));
        trustService.setServiceNames(this.getLangAndValues(serviceInfoStatus.getNames()));
        trustService.setServiceType(serviceInfoStatus.getType());
        trustService.setStatus(serviceInfoStatus.getStatus());
        trustService.setStartDate(serviceInfoStatus.getStartDate());
        trustService.setEndDate(serviceInfoStatus.getEndDate());
        List<XmlQualifier> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            trustService.setCapturedQualifiers(qualifiers);
        }
        if (Utils.isCollectionNotEmpty((Collection)(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris()))) {
            trustService.setAdditionalServiceInfoUris(additionalServiceInfoUris);
        }
        if (Utils.isCollectionNotEmpty((Collection)(serviceSupplyPoints = serviceInfoStatus.getServiceSupplyPoints()))) {
            trustService.setServiceSupplyPoints(serviceSupplyPoints);
        }
        trustService.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
        return trustService;
    }

    private List<XmlQualifier> getQualifiers(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certificateToken) {
        LOG.trace("--> GET_QUALIFIERS()");
        ArrayList<XmlQualifier> list = new ArrayList<XmlQualifier>();
        List conditionsForQualifiers = serviceInfoStatus.getConditionsForQualifiers();
        if (Utils.isCollectionNotEmpty((Collection)conditionsForQualifiers)) {
            for (ConditionForQualifiers conditionForQualifiers : conditionsForQualifiers) {
                Condition condition = conditionForQualifiers.getCondition();
                if (!condition.check(certificateToken)) continue;
                for (String qualifier : conditionForQualifiers.getQualifiers()) {
                    list.add(this.getXmlQualifier(qualifier, conditionForQualifiers.isCritical()));
                }
            }
        }
        return list;
    }

    private XmlQualifier getXmlQualifier(String value, boolean critical) {
        XmlQualifier xmlQualifier = new XmlQualifier();
        xmlQualifier.setValue(value);
        xmlQualifier.setCritical(Boolean.valueOf(critical));
        return xmlQualifier;
    }

    private List<XmlTrustService> buildXmlTrustServicesWithMRA(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor, MRA mra) {
        if (Utils.isCollectionNotEmpty((Collection)serviceInfoStatus.getAdditionalServiceInfoUris())) {
            ArrayList<XmlTrustService> result = new ArrayList<XmlTrustService>();
            for (String aSI : serviceInfoStatus.getAdditionalServiceInfoUris()) {
                TrustServiceStatusAndInformationExtensions serviceInfoStatusCopy = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder(serviceInfoStatus).setAdditionalServiceInfoUris(Collections.singletonList(aSI)).build();
                result.addAll(this.getXmlTrustServicesForMRA(serviceInfoStatusCopy, certToken, trustAnchor, mra));
            }
            return result;
        }
        return this.getXmlTrustServicesForMRA(serviceInfoStatus, certToken, trustAnchor, mra);
    }

    private List<XmlTrustService> getXmlTrustServicesForMRA(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, CertificateToken trustAnchor, MRA mra) {
        List<MutableTimeDependentValues<ServiceEquivalence>> mraEquivalences = this.getMRAServiceEquivalences(serviceInfoStatus, certToken, mra);
        boolean enactedMra = Utils.isCollectionNotEmpty(mraEquivalences);
        if (enactedMra) {
            if (mraEquivalences.size() == 1) {
                MutableTimeDependentValues<ServiceEquivalence> serviceEquivalenceValues = mraEquivalences.iterator().next();
                LOG.info("MRA equivalence is applied for a Trusted Service : '{}'", (Object)((ServiceEquivalence)serviceEquivalenceValues.getLatest()).getLegalInfoIdentifier());
                ArrayList<XmlTrustService> result = new ArrayList<XmlTrustService>();
                List serviceEquivalenceList = serviceEquivalenceValues.getAfter(certToken.getNotBefore());
                for (ServiceEquivalence serviceEquivalence : serviceEquivalenceList) {
                    TrustServiceStatusAndInformationExtensions equivalent = this.getEquivalent(serviceInfoStatus, serviceEquivalence);
                    XmlTrustService xmlTrustService = this.getXmlTrustService(equivalent, certToken, trustAnchor);
                    xmlTrustService.setMRATrustServiceMapping(this.getXmlMRATrustServiceMapping(serviceInfoStatus, certToken, serviceEquivalence));
                    xmlTrustService.setEnactedMRA(Boolean.valueOf(serviceEquivalence.getStatus().isEnacted()));
                    result.add(xmlTrustService);
                }
                this.translateCertificate(certToken, serviceEquivalenceList);
                return result;
            }
            LOG.warn("More than one MRA equivalence found for a Trusted Service! MRA rules are not applied!");
        }
        return Collections.singletonList(this.getXmlTrustService(serviceInfoStatus, certToken, trustAnchor));
    }

    private List<MutableTimeDependentValues<ServiceEquivalence>> getMRAServiceEquivalences(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, MRA mra) {
        LOG.debug("MRA");
        ArrayList<MutableTimeDependentValues<ServiceEquivalence>> equivalences = new ArrayList<MutableTimeDependentValues<ServiceEquivalence>>();
        block0: for (MutableTimeDependentValues serviceEquivalenceList : mra.getServiceEquivalence()) {
            for (ServiceEquivalence serviceEquivalence : serviceEquivalenceList.getAfter(certToken.getNotBefore())) {
                if (!this.check(serviceInfoStatus, serviceEquivalence)) continue;
                equivalences.add((MutableTimeDependentValues<ServiceEquivalence>)serviceEquivalenceList);
                continue block0;
            }
        }
        return equivalences;
    }

    private boolean check(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        if (!this.checkServiceTypeAsiEquivalence(serviceInfoStatus, serviceEquivalence.getTypeAsiEquivalence())) {
            return false;
        }
        Map statusEquivalence = serviceEquivalence.getStatusEquivalence();
        return this.checkStatusEquivalence(serviceInfoStatus, statusEquivalence);
    }

    private boolean checkServiceTypeAsiEquivalence(TrustServiceStatusAndInformationExtensions serviceInfoStatus, Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalenceMap) {
        for (ServiceTypeASi typeAsiEquivalence : typeAsiEquivalenceMap.keySet()) {
            if (!this.checkServiceTypeASi(serviceInfoStatus, typeAsiEquivalence)) continue;
            return true;
        }
        return false;
    }

    private boolean checkServiceTypeASi(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceTypeASi serviceTypeASi) {
        return serviceInfoStatus.getType().equals(serviceTypeASi.getType()) && (serviceTypeASi.getAsi() == null || serviceInfoStatus.getAdditionalServiceInfoUris().contains(serviceTypeASi.getAsi()));
    }

    private boolean checkCertTypeAsiEquivalence(CertificateToken certToken, Map<ServiceTypeASi, ServiceTypeASi> typeAsiEquivalenceMap) {
        XmlCertificate xmlCertificate = this.xmlCertsMap.get(certToken.getDSSIdAsString());
        if (xmlCertificate == null) {
            throw new IllegalStateException(String.format("XML certificate with Id '%s' is not yet created!", certToken.getDSSIdAsString()));
        }
        CertificateWrapper certificateWrapper = new CertificateWrapper(xmlCertificate);
        boolean qcCompliance = certificateWrapper.isQcCompliance();
        List qcTypes = certificateWrapper.getQcTypes();
        for (ServiceTypeASi serviceTypeASi : typeAsiEquivalenceMap.values()) {
            if (serviceTypeASi.getAsi() == null) {
                return true;
            }
            if (Utils.isCollectionNotEmpty((Collection)qcTypes)) {
                for (QCType qcType : qcTypes) {
                    if (!this.isQcTypeMatch(qcType, serviceTypeASi)) continue;
                    return true;
                }
                continue;
            }
            if (qcCompliance) {
                if (!this.isQcTypeMatch((QCType)QCTypeEnum.QCT_ESIGN, serviceTypeASi)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean isQcTypeMatch(QCType qcType, ServiceTypeASi serviceTypeASi) {
        String asi = serviceTypeASi.getAsi();
        if (QCTypeEnum.QCT_ESIGN.equals((Object)qcType)) {
            return AdditionalServiceInformation.isForeSignatures((String)asi);
        }
        if (QCTypeEnum.QCT_ESEAL.equals((Object)qcType)) {
            return AdditionalServiceInformation.isForeSeals((String)asi);
        }
        if (QCTypeEnum.QCT_WEB.equals((Object)qcType)) {
            return AdditionalServiceInformation.isForWebAuth((String)asi);
        }
        return false;
    }

    private boolean checkStatusEquivalence(TrustServiceStatusAndInformationExtensions serviceInfoStatus, Map<List<String>, List<String>> statusEquivalenceMap) {
        for (Map.Entry<List<String>, List<String>> statusEquivalence : statusEquivalenceMap.entrySet()) {
            if (!statusEquivalence.getKey().contains(serviceInfoStatus.getStatus())) continue;
            return true;
        }
        return false;
    }

    private XmlMRATrustServiceMapping getXmlMRATrustServiceMapping(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken, ServiceEquivalence serviceEquivalence) {
        XmlMRATrustServiceMapping mraTrustServiceMapping = new XmlMRATrustServiceMapping();
        mraTrustServiceMapping.setTrustServiceLegalIdentifier(serviceEquivalence.getLegalInfoIdentifier());
        mraTrustServiceMapping.setEquivalenceStatusStartingTime(serviceEquivalence.getStartDate());
        mraTrustServiceMapping.setEquivalenceStatusEndingTime(serviceEquivalence.getEndDate());
        mraTrustServiceMapping.setOriginalThirdCountryMapping(this.getXmlOriginalThirdCountryTrustServiceMapping(serviceInfoStatus, certToken));
        return mraTrustServiceMapping;
    }

    private XmlOriginalThirdCountryTrustServiceMapping getXmlOriginalThirdCountryTrustServiceMapping(TrustServiceStatusAndInformationExtensions serviceInfoStatus, CertificateToken certToken) {
        List additionalServiceInfoUris;
        XmlOriginalThirdCountryTrustServiceMapping originalThirdCountryMapping = new XmlOriginalThirdCountryTrustServiceMapping();
        originalThirdCountryMapping.setServiceType(serviceInfoStatus.getType());
        originalThirdCountryMapping.setStatus(serviceInfoStatus.getStatus());
        List<XmlQualifier> qualifiers = this.getQualifiers(serviceInfoStatus, certToken);
        if (Utils.isCollectionNotEmpty(qualifiers)) {
            originalThirdCountryMapping.setCapturedQualifiers(qualifiers);
        }
        if (Utils.isCollectionNotEmpty((Collection)(additionalServiceInfoUris = serviceInfoStatus.getAdditionalServiceInfoUris()))) {
            originalThirdCountryMapping.setAdditionalServiceInfoUris(additionalServiceInfoUris);
        }
        return originalThirdCountryMapping;
    }

    private void translateCertificate(CertificateToken certToken, List<ServiceEquivalence> serviceEquivalenceList) {
        XmlQcStatements qcStatements = null;
        for (ServiceEquivalence serviceEquivalence : serviceEquivalenceList) {
            if (serviceEquivalence.getStatus().isEnacted() && this.check(certToken, serviceEquivalence)) {
                XmlQcStatements currentQcStatement = this.applyCertContentEquivalence(certToken, serviceEquivalence);
                if (qcStatements == null) {
                    qcStatements = currentQcStatement;
                    continue;
                }
                if (this.checkQcStatementsEquivalence(qcStatements, currentQcStatement)) continue;
                LOG.warn("Enacted MRA equivalences with legal identifier '{}' lead to different certificate content results for a certificate with id '{}'! The equivalence is not applied.", (Object)serviceEquivalence.getLegalInfoIdentifier(), (Object)certToken.getDSSIdAsString());
                return;
            }
            LOG.debug("MRA equivalence was not applied for a certificate with Id '{}' : '{}'", (Object)certToken.getDSSIdAsString(), (Object)serviceEquivalence.getLegalInfoIdentifier());
        }
        if (qcStatements != null) {
            LOG.info("MRA equivalence is applied for a certificate with Id '{}' : '{}'", (Object)certToken.getDSSIdAsString(), (Object)serviceEquivalenceList.iterator().next().getLegalInfoIdentifier());
            XmlCertificate xmlCertificate = this.xmlCertsMap.get(certToken.getDSSIdAsString());
            this.setQcStatements(xmlCertificate, qcStatements);
        }
    }

    private boolean check(CertificateToken certificateToken, ServiceEquivalence serviceEquivalence) {
        Date certIssuance = certificateToken.getNotBefore();
        if (certIssuance.before(serviceEquivalence.getStartDate())) {
            return false;
        }
        if (serviceEquivalence.getEndDate() != null && certIssuance.after(serviceEquivalence.getEndDate())) {
            return false;
        }
        return this.checkCertTypeAsiEquivalence(certificateToken, serviceEquivalence.getTypeAsiEquivalence());
    }

    private TrustServiceStatusAndInformationExtensions getEquivalent(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        ServiceTypeASi typeASiSubstitution = this.getTypeASiSubstitution(serviceInfoStatus, serviceEquivalence);
        String status = this.getStatusSubstitution(serviceInfoStatus, serviceEquivalence);
        List<ConditionForQualifiers> qualifiersSubstitution = this.getQualifiersSubstitution(serviceInfoStatus, serviceEquivalence);
        TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder builder = new TrustServiceStatusAndInformationExtensions.TrustServiceStatusAndInformationExtensionsBuilder();
        if (typeASiSubstitution != null) {
            builder.setType(typeASiSubstitution.getType());
            if (typeASiSubstitution.getAsi() != null) {
                builder.setAdditionalServiceInfoUris(Collections.singletonList(typeASiSubstitution.getAsi()));
            }
        }
        builder.setStatus(status);
        builder.setConditionsForQualifiers(qualifiersSubstitution);
        builder.setStartDate(serviceInfoStatus.getStartDate());
        builder.setEndDate(serviceInfoStatus.getEndDate());
        builder.setNames(serviceInfoStatus.getNames());
        builder.setExpiredCertsRevocationInfo(serviceInfoStatus.getExpiredCertsRevocationInfo());
        builder.setServiceSupplyPoints(serviceInfoStatus.getServiceSupplyPoints());
        return new TrustServiceStatusAndInformationExtensions(builder);
    }

    private ServiceTypeASi getTypeASiSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        for (Map.Entry expectedSubstitution : serviceEquivalence.getTypeAsiEquivalence().entrySet()) {
            ServiceTypeASi expected = (ServiceTypeASi)expectedSubstitution.getKey();
            if (!this.checkServiceTypeASi(serviceInfoStatus, expected)) continue;
            return this.substituteTypeASi(serviceInfoStatus, expected, (ServiceTypeASi)expectedSubstitution.getValue());
        }
        return null;
    }

    private ServiceTypeASi substituteTypeASi(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceTypeASi pointed, ServiceTypeASi pointing) {
        String asiResult;
        ServiceTypeASi serviceTypeASi = new ServiceTypeASi();
        serviceTypeASi.setType(pointing.getType());
        if (Utils.isCollectionNotEmpty((Collection)serviceInfoStatus.getAdditionalServiceInfoUris())) {
            asiResult = (String)serviceInfoStatus.getAdditionalServiceInfoUris().iterator().next();
            if (asiResult.equals(pointed.getAsi())) {
                asiResult = pointing.getAsi();
            }
        } else {
            asiResult = pointing.getAsi();
        }
        serviceTypeASi.setAsi(asiResult);
        return serviceTypeASi;
    }

    private String getStatusSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        Map statusEquivalence = serviceEquivalence.getStatusEquivalence();
        for (Map.Entry equivalence : statusEquivalence.entrySet()) {
            List expected = (List)equivalence.getKey();
            if (!expected.contains(serviceInfoStatus.getStatus())) continue;
            return (String)((List)equivalence.getValue()).iterator().next();
        }
        return null;
    }

    private List<ConditionForQualifiers> getQualifiersSubstitution(TrustServiceStatusAndInformationExtensions serviceInfoStatus, ServiceEquivalence serviceEquivalence) {
        ArrayList<ConditionForQualifiers> result = new ArrayList<ConditionForQualifiers>();
        Map qualifierEquivalence = serviceEquivalence.getQualifierEquivalence();
        for (ConditionForQualifiers qualifierCondition : serviceInfoStatus.getConditionsForQualifiers()) {
            ArrayList<String> qualifiers = new ArrayList<String>();
            for (String qualifier : qualifierCondition.getQualifiers()) {
                String pointingQualifier = (String)qualifierEquivalence.get(qualifier);
                if (Utils.isStringNotEmpty((String)pointingQualifier)) {
                    qualifier = pointingQualifier;
                }
                qualifiers.add(qualifier);
            }
            result.add(new ConditionForQualifiers(qualifierCondition.getCondition(), qualifiers, qualifierCondition.isCritical()));
        }
        return result;
    }

    private XmlQcStatements applyCertContentEquivalence(CertificateToken certToken, ServiceEquivalence serviceEquivalence) {
        List certificateContentEquivalences = serviceEquivalence.getCertificateContentEquivalences();
        if (Utils.isCollectionEmpty((Collection)certificateContentEquivalences)) {
            LOG.debug("No MRA equivalence is defined for certificate content.");
            return null;
        }
        this.assertCertificateContentEquivalenceListIsConsistent(certificateContentEquivalences);
        XmlCertificate xmlCertificate = this.xmlCertsMap.get(certToken.getDSSIdAsString());
        if (xmlCertificate == null) {
            throw new IllegalStateException(String.format("XmlCertificate with Id '%s' is not yet created!", certToken.getDSSIdAsString()));
        }
        XmlQcStatements qcStatements = this.getQcStatements(xmlCertificate);
        qcStatements.setEnactedMRA(Boolean.valueOf(true));
        XmlMRACertificateMapping xmlMRACertificateMapping = this.getXmlMRACertificateMapping(qcStatements, serviceEquivalence);
        qcStatements.setMRACertificateMapping(xmlMRACertificateMapping);
        XmlTrustServiceEquivalenceInformation trustServiceEquivalenceInformation = xmlMRACertificateMapping.getTrustServiceEquivalenceInformation();
        for (CertificateContentEquivalence certificateContentEquivalence : certificateContentEquivalences) {
            MRAEquivalenceContext equivalenceContext = certificateContentEquivalence.getContext();
            if (equivalenceContext == null) continue;
            XmlCertificateContentEquivalence xmlCertificateContentEquivalence = new XmlCertificateContentEquivalence();
            xmlCertificateContentEquivalence.setUri(equivalenceContext.getUri());
            Condition condition = certificateContentEquivalence.getCondition();
            if (condition.check(certToken)) {
                LOG.info("MRA condition match ({})", (Object)equivalenceContext);
                QCStatementOids contentReplacement = certificateContentEquivalence.getContentReplacement();
                switch (equivalenceContext) {
                    case QC_COMPLIANCE: {
                        this.replaceCompliance(qcStatements, contentReplacement);
                        xmlCertificateContentEquivalence.setEnacted(true);
                        break;
                    }
                    case QC_TYPE: {
                        this.replaceType(qcStatements, contentReplacement);
                        xmlCertificateContentEquivalence.setEnacted(true);
                        break;
                    }
                    case QC_QSCD: {
                        this.replaceQSCD(qcStatements, contentReplacement);
                        xmlCertificateContentEquivalence.setEnacted(true);
                        break;
                    }
                    default: {
                        LOG.warn("Unsupported equivalence context {}", (Object)equivalenceContext);
                    }
                }
            }
            trustServiceEquivalenceInformation.getCertificateContentEquivalenceList().add(xmlCertificateContentEquivalence);
        }
        return qcStatements;
    }

    private void assertCertificateContentEquivalenceListIsConsistent(List<CertificateContentEquivalence> certificateContentEquivalences) {
        HashSet<MRAEquivalenceContext> processedValues = new HashSet<MRAEquivalenceContext>();
        for (CertificateContentEquivalence certificateContentEquivalence : certificateContentEquivalences) {
            MRAEquivalenceContext context = certificateContentEquivalence.getContext();
            if (processedValues.contains(context)) {
                LOG.warn("The MRA certificate content reference equivalence contains more than one element with '{}' context!", (Object)context.getUri());
            }
            processedValues.add(context);
        }
    }

    private XmlQcStatements getQcStatements(XmlCertificate xmlCertificate) {
        for (XmlCertificateExtension certificateExtension : xmlCertificate.getCertificateExtensions()) {
            if (!CertificateExtensionEnum.QC_STATEMENTS.getOid().equals(certificateExtension.getOID())) continue;
            return this.qcStatementsBuilder.copy((XmlQcStatements)certificateExtension);
        }
        return new XmlQcStatements();
    }

    private void setQcStatements(XmlCertificate xmlCertificate, XmlQcStatements xmlQcStatements) {
        Iterator it = xmlCertificate.getCertificateExtensions().iterator();
        while (it.hasNext()) {
            XmlCertificateExtension certificateExtension = (XmlCertificateExtension)it.next();
            if (!CertificateExtensionEnum.QC_STATEMENTS.getOid().equals(certificateExtension.getOID())) continue;
            it.remove();
            break;
        }
        xmlCertificate.getCertificateExtensions().add(xmlQcStatements);
    }

    private boolean checkQcStatementsEquivalence(XmlQcStatements qcStatementsOne, XmlQcStatements qcStatementsTwo) {
        if (qcStatementsOne == null && qcStatementsTwo == null) {
            return true;
        }
        if (qcStatementsOne == null || qcStatementsTwo == null) {
            return false;
        }
        if (Utils.isTrue((Boolean)qcStatementsOne.isEnactedMRA()) != Utils.isTrue((Boolean)qcStatementsTwo.isEnactedMRA())) {
            return false;
        }
        if ((qcStatementsOne.getQcCompliance() != null && qcStatementsOne.getQcCompliance().isPresent()) != (qcStatementsTwo.getQcCompliance() != null && qcStatementsTwo.getQcCompliance().isPresent())) {
            return false;
        }
        if (!qcStatementsOne.getQcTypes().stream().map(XmlOID::getValue).collect(Collectors.toSet()).equals(qcStatementsTwo.getQcTypes().stream().map(XmlOID::getValue).collect(Collectors.toSet()))) {
            return false;
        }
        return (qcStatementsOne.getQcSSCD() != null && qcStatementsOne.getQcSSCD().isPresent()) == (qcStatementsTwo.getQcSSCD() != null && qcStatementsTwo.getQcSSCD().isPresent());
    }

    private XmlMRACertificateMapping getXmlMRACertificateMapping(XmlQcStatements qcStatements, ServiceEquivalence serviceEquivalence) {
        XmlMRACertificateMapping xmlMRACertificateMapping = new XmlMRACertificateMapping();
        xmlMRACertificateMapping.setTrustServiceEquivalenceInformation(this.getXmlTrustServiceEquivalenceInformation(serviceEquivalence));
        xmlMRACertificateMapping.setOriginalThirdCountryMapping(this.getXmlOriginalThirdCountryQcStatementsMapping(qcStatements));
        return xmlMRACertificateMapping;
    }

    private XmlTrustServiceEquivalenceInformation getXmlTrustServiceEquivalenceInformation(ServiceEquivalence serviceEquivalence) {
        XmlTrustServiceEquivalenceInformation xmlTrustServiceEquivalenceInformation = new XmlTrustServiceEquivalenceInformation();
        xmlTrustServiceEquivalenceInformation.setTrustServiceLegalIdentifier(serviceEquivalence.getLegalInfoIdentifier());
        return xmlTrustServiceEquivalenceInformation;
    }

    private XmlOriginalThirdCountryQcStatementsMapping getXmlOriginalThirdCountryQcStatementsMapping(XmlQcStatements qcStatements) {
        List otherOIDs;
        List qcCClegislations;
        List originalQcTypes;
        XmlOriginalThirdCountryQcStatementsMapping originalQcStatements = new XmlOriginalThirdCountryQcStatementsMapping();
        if (qcStatements.getQcCompliance() != null) {
            originalQcStatements.setQcCompliance(this.qcStatementsBuilder.buildXmlQcCompliance(qcStatements.getQcCompliance().isPresent()));
        }
        if (qcStatements.getQcSSCD() != null) {
            originalQcStatements.setQcSSCD(this.qcStatementsBuilder.buildXmlQcSSCD(qcStatements.getQcSSCD().isPresent()));
        }
        if (Utils.isCollectionNotEmpty((Collection)(originalQcTypes = qcStatements.getQcTypes()))) {
            originalQcStatements.setQcTypes(new ArrayList(originalQcTypes));
        }
        if (Utils.isCollectionNotEmpty((Collection)(qcCClegislations = qcStatements.getQcCClegislation()))) {
            originalQcStatements.setQcCClegislation(new ArrayList(qcCClegislations));
        }
        if (Utils.isCollectionNotEmpty((Collection)(otherOIDs = qcStatements.getOtherOIDs()))) {
            originalQcStatements.setOtherOIDs(new ArrayList(otherOIDs));
        }
        return originalQcStatements;
    }

    private void replaceCompliance(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        boolean isQcCompliance = false;
        List qcCClegislations = qcStatements.getQcCClegislation();
        for (String oid : contentReplacement.getQcStatementIds()) {
            if (!QcStatementUtils.isQcCompliance((String)oid)) continue;
            isQcCompliance = true;
        }
        if (Utils.isCollectionNotEmpty((Collection)contentReplacement.getQcCClegislations())) {
            qcCClegislations = contentReplacement.getQcCClegislations();
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (QcStatementUtils.isQcCompliance((String)oid)) {
                isQcCompliance = false;
            }
            if (!QcStatementUtils.isQcCClegislation((String)oid)) continue;
            if (Utils.isCollectionNotEmpty((Collection)contentReplacement.getQcCClegislationsToRemove())) {
                qcCClegislations.removeAll(contentReplacement.getQcCClegislationsToRemove());
                continue;
            }
            qcCClegislations.clear();
        }
        qcStatements.setQcCompliance(this.qcStatementsBuilder.buildXmlQcCompliance(isQcCompliance));
        qcStatements.setQcCClegislation(qcCClegislations);
    }

    private void replaceType(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        List originalQcTypes = qcStatements.getQcTypes();
        List qcTypesIds = originalQcTypes.stream().map(XmlOID::getValue).collect(Collectors.toList());
        if (Utils.isCollectionNotEmpty((Collection)contentReplacement.getQcTypeIds())) {
            qcTypesIds = contentReplacement.getQcTypeIds();
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (!QcStatementUtils.isQcType((String)oid)) continue;
            if (Utils.isCollectionNotEmpty((Collection)contentReplacement.getQcTypeIdsToRemove())) {
                qcTypesIds.removeAll(contentReplacement.getQcTypeIdsToRemove());
                continue;
            }
            qcTypesIds.clear();
        }
        List qcTypes = QcStatementUtils.getQcTypes((List)qcTypesIds);
        qcStatements.setQcTypes(this.qcStatementsBuilder.buildXmlQcTypes(qcTypes));
    }

    private void replaceQSCD(XmlQcStatements qcStatements, QCStatementOids contentReplacement) {
        boolean isQcSSCD = false;
        for (String oid : contentReplacement.getQcStatementIds()) {
            if (!QcStatementUtils.isQcSSCD((String)oid)) continue;
            isQcSSCD = true;
        }
        for (String oid : contentReplacement.getQcStatementIdsToRemove()) {
            if (!QcStatementUtils.isQcSSCD((String)oid)) continue;
            isQcSSCD = false;
        }
        qcStatements.setQcSSCD(this.qcStatementsBuilder.buildXmlQcSSCD(isQcSSCD));
    }
}

