/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.cc;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCC;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CryptographicSuite;
import eu.europa.esig.dss.validation.policy.CryptographicSuiteUtils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.cc.AbstractCryptographicChecker;
import java.util.Date;

public class DigestCryptographicChecker
extends AbstractCryptographicChecker {
    public DigestCryptographicChecker(I18nProvider i18nProvider, DigestAlgorithm digestAlgorithm, Date validationDate, MessageTag position, CryptographicSuite constraint) {
        super(i18nProvider, digestAlgorithm, validationDate, position, constraint);
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCC> item = this.firstItem = this.digestAlgorithmReliable();
        if (this.isExpirationDateAvailable(this.digestAlgorithm)) {
            item = item.setNextItem(this.digestAlgorithmOnValidationTime());
        }
    }

    @Override
    protected Date getNotAfter() {
        if (CryptographicSuiteUtils.isDigestAlgorithmReliable(this.cryptographicSuite, this.digestAlgorithm) && (this.encryptionAlgorithm == null || CryptographicSuiteUtils.isEncryptionAlgorithmReliable(this.cryptographicSuite, this.encryptionAlgorithm) && CryptographicSuiteUtils.isEncryptionAlgorithmWithKeySizeReliable(this.cryptographicSuite, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken))) {
            Date notAfter = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.digestAlgorithm);
            Date expirationEncryption = CryptographicSuiteUtils.getExpirationDate(this.cryptographicSuite, this.encryptionAlgorithm, this.keyLengthUsedToSignThisToken);
            if (notAfter == null || expirationEncryption != null && expirationEncryption.before(notAfter)) {
                notAfter = expirationEncryption;
            }
            return notAfter;
        }
        return null;
    }
}

