/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.vci;

import eu.europa.esig.dss.detailedreport.jaxb.XmlVCI;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.SignaturePolicyType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyHashValidCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyIdentifiedCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyStoreCheck;
import eu.europa.esig.dss.validation.process.bbb.vci.checks.SignaturePolicyZeroHashCheck;

public class ValidationContextInitialization
extends Chain<XmlVCI> {
    private final SignatureWrapper signature;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public ValidationContextInitialization(I18nProvider i18nProvider, SignatureWrapper signature, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlVCI());
        this.signature = signature;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VALIDATION_CONTEXT_INITIALIZATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlVCI> item = this.firstItem = this.signaturePolicyIdentifier();
        if (this.signature.isPolicyPresent() && !SignaturePolicyType.IMPLICIT_POLICY.name().equals(this.signature.getPolicyId())) {
            item = item.setNextItem(this.signaturePolicyIdentified());
            item = item.setNextItem(this.signaturePolicyStorePresent());
            if (this.signature.isPolicyIdentified()) {
                item = !this.signature.isPolicyZeroHash() ? item.setNextItem(this.signaturePolicyHashValid()) : item.setNextItem(this.signaturePolicyZeroHash());
            }
        }
    }

    private ChainItem<XmlVCI> signaturePolicyIdentifier() {
        MultiValuesRule signaturePolicyConstraint = this.validationPolicy.getSignaturePolicyConstraint(this.context);
        return new SignaturePolicyIdentifierCheck(this.i18nProvider, (XmlVCI)this.result, this.signature, signaturePolicyConstraint);
    }

    private ChainItem<XmlVCI> signaturePolicyIdentified() {
        LevelRule constraint = this.validationPolicy.getSignaturePolicyIdentifiedConstraint(this.context);
        return new SignaturePolicyIdentifiedCheck(this.i18nProvider, (XmlVCI)this.result, this.signature, constraint);
    }

    private ChainItem<XmlVCI> signaturePolicyStorePresent() {
        LevelRule constraint = this.validationPolicy.getSignaturePolicyStorePresentConstraint(this.context);
        return new SignaturePolicyStoreCheck(this.i18nProvider, (XmlVCI)this.result, this.signature, constraint);
    }

    private ChainItem<XmlVCI> signaturePolicyHashValid() {
        LevelRule constraint = this.validationPolicy.getSignaturePolicyPolicyHashValid(this.context);
        return new SignaturePolicyHashValidCheck(this.i18nProvider, (XmlVCI)this.result, this.signature, constraint);
    }

    private ChainItem<XmlVCI> signaturePolicyZeroHash() {
        return new SignaturePolicyZeroHashCheck(this.i18nProvider, (XmlVCI)this.result, this.signature, this.getWarnLevelRule());
    }
}

