/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TrustServiceStatusCheck
extends AbstractMultiValuesCheckItem<XmlXCV> {
    private final CertificateWrapper certificate;
    private final Date usageTime;
    private final Context context;
    private String serviceStatusStr;

    public TrustServiceStatusCheck(I18nProvider i18nProvider, XmlXCV result, CertificateWrapper certificate, Date usageTime, Context context, MultiValuesRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.usageTime = usageTime;
        this.context = context;
    }

    @Override
    protected boolean process() {
        if (this.certificate.isCertificateChainFromTrustedStore()) {
            return true;
        }
        List trustServices = this.certificate.getTrustServices();
        if (Utils.isCollectionNotEmpty((Collection)trustServices)) {
            for (TrustServiceWrapper trustService : trustServices) {
                this.serviceStatusStr = Utils.trim((String)trustService.getStatus());
                Date statusStartDate = trustService.getStartDate();
                if (!this.processValueCheck(this.serviceStatusStr) || statusStartDate == null) continue;
                Date statusEndDate = trustService.getEndDate();
                if (this.usageTime.compareTo(statusStartDate) < 0 || statusEndDate != null && !this.usageTime.before(statusEndDate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (Utils.isStringNotEmpty((String)this.serviceStatusStr)) {
            return this.i18nProvider.getMessage(MessageTag.TRUSTED_SERVICE_STATUS, new Object[]{this.serviceStatusStr});
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.XCV_TSL_ESP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.XCV_TSL_ESP_SIG_ANS;
            }
            case TIMESTAMP: {
                return MessageTag.XCV_TSL_ESP_TSP_ANS;
            }
            case REVOCATION: {
                return MessageTag.XCV_TSL_ESP_REV_ANS;
            }
        }
        return MessageTag.XCV_TSL_ESP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND;
    }
}

