/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCRS;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SubContext;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.CertificateApplicabilityRule;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.model.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactCheck;
import eu.europa.esig.dss.validation.process.bbb.cv.checks.SignatureIntactWithIdCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.crs.CertificateRevocationSelector;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationAfterCertificateIssuanceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationCertHashPresenceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationDataKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationHasInformationAboutCertificateCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationIssuerKnownCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationIssuerRevocationDataAvailableCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationIssuerValidAtProductionTimeCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.RevocationResponderIdMatchCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.SelfIssuedOCSPCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks.ThisUpdatePresenceCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateRevocationSelectorResultCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.CertificateSelfSignedCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks.RevocationDataRequiredCheck;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

public class RevocationAcceptanceChecker
extends Chain<XmlRAC> {
    private final CertificateWrapper certificate;
    private final CertificateRevocationWrapper revocationData;
    private final Date controlTime;
    private final ValidationPolicy policy;
    private final Set<String> validatedTokens;

    public RevocationAcceptanceChecker(I18nProvider i18nProvider, CertificateWrapper certificate, CertificateRevocationWrapper revocationData, Date controlTime, ValidationPolicy policy, Set<String> validatedTokens) {
        super(i18nProvider, new XmlRAC());
        this.certificate = certificate;
        this.revocationData = revocationData;
        this.controlTime = controlTime;
        this.policy = policy;
        this.validatedTokens = validatedTokens;
        ((XmlRAC)this.result).setId(revocationData.getId());
        ((XmlRAC)this.result).setRevocationThisUpdate(revocationData.getThisUpdate());
        ((XmlRAC)this.result).setRevocationProductionDate(revocationData.getProductionDate());
        this.validatedTokens.add(certificate.getId());
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.RAC;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlRAC> item = this.firstItem = this.revocationDataKnown();
        item = item.setNextItem(this.issuerCertificateKnown());
        item = item.setNextItem(this.prospectiveCertificateChain(this.revocationData.getSigningCertificate()));
        item = item.setNextItem(this.revocationDataIntact());
        item = item.setNextItem(this.thisUpdate());
        if (RevocationType.OCSP.equals((Object)this.revocationData.getRevocationType())) {
            item = item.setNextItem(this.issuerValidAtProductionTime());
            item = item.setNextItem(this.revocationResponderIdMatch());
            item = item.setNextItem(this.revocationCertHashPresent());
            if (this.revocationData.isCertHashExtensionPresent()) {
                item = item.setNextItem(this.revocationCertHashMatch());
            }
            item = item.setNextItem(this.selfIssuedOcsp());
        }
        item = item.setNextItem(this.revocationAfterCertIssuance());
        item = item.setNextItem(this.revocationHasInformationAboutCertificate());
        for (CertificateWrapper revocationCertificate : this.revocationData.getCertificateChain()) {
            RevocationDataRequiredCheck<XmlRAC> revocationDataRequired;
            SubContext subContext;
            SubContext subContext2 = subContext = this.revocationData.getSigningCertificate().getId().equals(revocationCertificate.getId()) ? SubContext.SIGNING_CERT : SubContext.CA_CERTIFICATE;
            if (this.isTrustAnchor(revocationCertificate, subContext)) break;
            if (this.isTokenValidated((TokenProxy)revocationCertificate)) continue;
            item = item.setNextItem(this.certificateIntact(revocationCertificate));
            if (revocationCertificate.isSelfSigned()) {
                item = item.setNextItem(this.selfSigned(revocationCertificate));
            }
            if ((revocationDataRequired = this.revocationDataRequired(revocationCertificate, subContext)).process()) {
                item = item.setNextItem(this.revocationDataPresentForRevocationChain(revocationCertificate, subContext));
                if (!Utils.isCollectionNotEmpty((Collection)revocationCertificate.getCertificateRevocationData())) continue;
                CertificateRevocationSelector certificateRevocationSelector = new CertificateRevocationSelector(this.i18nProvider, revocationCertificate, this.controlTime, this.policy, this.validatedTokens);
                XmlCRS xmlCRS = (XmlCRS)certificateRevocationSelector.execute();
                ((XmlRAC)this.result).setCRS(xmlCRS);
                item = item.setNextItem(this.checkCertificateRevocationSelectorResult(xmlCRS, subContext));
                continue;
            }
            item = item.setNextItem(revocationDataRequired);
        }
    }

    private ChainItem<XmlRAC> revocationDataKnown() {
        return new RevocationDataKnownCheck(this.i18nProvider, (XmlRAC)this.result, this.revocationData, this.policy.getUnknownStatusConstraint());
    }

    private ChainItem<XmlRAC> revocationResponderIdMatch() {
        LevelRule constraint = this.policy.getOCSPResponseResponderIdMatchConstraint();
        return new RevocationResponderIdMatchCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationCertHashPresent() {
        LevelRule constraint = this.policy.getOCSPResponseCertHashPresentConstraint();
        return new RevocationCertHashPresenceCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationCertHashMatch() {
        LevelRule constraint = this.policy.getOCSPResponseCertHashMatchConstraint();
        return new RevocationCertHashMatchCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> selfIssuedOcsp() {
        LevelRule constraint = this.policy.getSelfIssuedOCSPConstraint();
        return new SelfIssuedOCSPCheck(this.i18nProvider, (XmlRAC)this.result, this.certificate, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> thisUpdate() {
        LevelRule constraint = this.policy.getThisUpdatePresentConstraint();
        return new ThisUpdatePresenceCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> issuerCertificateKnown() {
        LevelRule constraint = this.policy.getRevocationIssuerKnownConstraint();
        return new RevocationIssuerKnownCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> issuerValidAtProductionTime() {
        LevelRule constraint = this.policy.getRevocationIssuerValidAtProductionTimeConstraint();
        return new RevocationIssuerValidAtProductionTimeCheck(this.i18nProvider, (XmlRAC)this.result, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationAfterCertIssuance() {
        LevelRule constraint = this.policy.getRevocationAfterCertificateIssuanceConstraint();
        return new RevocationAfterCertificateIssuanceCheck(this.i18nProvider, (XmlRAC)this.result, this.certificate, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationHasInformationAboutCertificate() {
        LevelRule constraint = this.policy.getRevocationHasInformationAboutCertificateConstraint();
        return new RevocationHasInformationAboutCertificateCheck(this.i18nProvider, (XmlRAC)this.result, this.certificate, (RevocationWrapper)this.revocationData, constraint);
    }

    private ChainItem<XmlRAC> revocationDataIntact() {
        LevelRule constraint = this.policy.getSignatureIntactConstraint(Context.REVOCATION);
        return new SignatureIntactCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, (TokenProxy)this.revocationData, Context.REVOCATION, constraint);
    }

    private ChainItem<XmlRAC> prospectiveCertificateChain(CertificateWrapper signingCertificate) {
        LevelRule constraint = this.policy.getProspectiveCertificateChainConstraint(Context.REVOCATION);
        return new ProspectiveCertificateChainCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, signingCertificate, Context.REVOCATION, constraint);
    }

    private boolean isTokenValidated(TokenProxy token) {
        boolean validated = this.validatedTokens.contains(token.getId());
        this.validatedTokens.add(token.getId());
        return validated;
    }

    private ChainItem<XmlRAC> certificateIntact(CertificateWrapper certificate) {
        LevelRule constraint = this.policy.getSignatureIntactConstraint(Context.CERTIFICATE);
        return new SignatureIntactWithIdCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, (TokenProxy)certificate, Context.CERTIFICATE, constraint);
    }

    private ChainItem<XmlRAC> selfSigned(CertificateWrapper certificate) {
        return new CertificateSelfSignedCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificate, this.getWarnLevelRule());
    }

    private ChainItem<XmlRAC> revocationDataPresentForRevocationChain(CertificateWrapper certificate, SubContext subContext) {
        LevelRule constraint = this.policy.getRevocationDataAvailableConstraint(Context.REVOCATION, subContext);
        return new RevocationIssuerRevocationDataAvailableCheck(this.i18nProvider, (XmlRAC)this.result, certificate, constraint);
    }

    private ChainItem<XmlRAC> checkCertificateRevocationSelectorResult(XmlCRS crsResult, SubContext subContext) {
        LevelRule constraint = this.policy.getAcceptableRevocationDataFoundConstraint(Context.REVOCATION, subContext);
        return new CertificateRevocationSelectorResultCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, crsResult, constraint);
    }

    private RevocationDataRequiredCheck<XmlRAC> revocationDataRequired(CertificateWrapper certificate, SubContext subContext) {
        CertificateApplicabilityRule constraint = this.policy.getRevocationDataSkipConstraint(Context.REVOCATION, subContext);
        LevelRule sunsetDateConstraint = this.policy.getCertificateSunsetDateConstraint(Context.REVOCATION, subContext);
        return new RevocationDataRequiredCheck<XmlRAC>(this.i18nProvider, (XmlRAC)this.result, certificate, this.controlTime, sunsetDateConstraint, constraint);
    }

    private boolean isTrustAnchor(CertificateWrapper certificateWrapper, SubContext subContext) {
        LevelRule sunsetDateConstraint = this.policy.getCertificateSunsetDateConstraint(Context.REVOCATION, subContext);
        return ValidationProcessUtils.isTrustAnchor(certificateWrapper, this.controlTime, sunsetDateConstraint);
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        super.collectAdditionalMessages(conclusion);
        XmlCRS crs = ((XmlRAC)this.result).getCRS();
        if (crs != null) {
            super.collectAllMessages(conclusion, crs.getConclusion());
        }
    }
}

