/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rac.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRAC;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevocationHasInformationAboutCertificateCheck
extends ChainItem<XmlRAC> {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationHasInformationAboutCertificateCheck.class);
    private final CertificateWrapper certificate;
    private final RevocationWrapper revocationData;
    private Date notAfterRevoc;

    public RevocationHasInformationAboutCertificateCheck(I18nProvider i18nProvider, XmlRAC result, CertificateWrapper certificate, RevocationWrapper revocationData, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.revocationData = revocationData;
    }

    @Override
    protected boolean process() {
        return this.checkCertHashMatches() || this.checkIssuerHasInformationForExpiredCertificate();
    }

    private boolean checkIssuerHasInformationForExpiredCertificate() {
        Date certNotAfter = this.certificate.getNotAfter();
        Date revocationIssuerKnowsCertStatusSince = this.getNotAfterRevoc();
        return certNotAfter != null && revocationIssuerKnowsCertStatusSince != null && certNotAfter.compareTo(revocationIssuerKnowsCertStatusSince) >= 0;
    }

    private boolean checkCertHashMatches() {
        return this.revocationData.isCertHashExtensionPresent() && this.revocationData.isCertHashExtensionMatch();
    }

    private Date getNotAfterRevoc() {
        if (this.notAfterRevoc == null) {
            Date expiredCertsRevocationInfo;
            Date archiveCutOff;
            this.notAfterRevoc = this.revocationData.getThisUpdate();
            Date expiredCertsOnCRL = this.revocationData.getExpiredCertsOnCRL();
            if (expiredCertsOnCRL != null) {
                if (expiredCertsOnCRL.before(this.notAfterRevoc)) {
                    this.notAfterRevoc = expiredCertsOnCRL;
                } else {
                    LOG.info("ExpiredCertsOnCRL : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(expiredCertsOnCRL), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
                }
            }
            if ((archiveCutOff = this.revocationData.getArchiveCutOff()) != null) {
                if (archiveCutOff.before(this.notAfterRevoc)) {
                    this.notAfterRevoc = archiveCutOff;
                } else {
                    LOG.info("ArchiveCutoff : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(archiveCutOff), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
                }
            }
            if (expiredCertsOnCRL == null && archiveCutOff == null && (expiredCertsRevocationInfo = this.getExpiredCertsRevocationInfo(this.revocationData)) != null) {
                if (expiredCertsRevocationInfo.before(this.notAfterRevoc)) {
                    this.notAfterRevoc = expiredCertsRevocationInfo;
                } else {
                    LOG.info("ExpiredCertsRevocationInfo : '{}' is not before revocation's thisUpdate : '{}'.", (Object)ValidationProcessUtils.getFormattedDate(expiredCertsRevocationInfo), (Object)ValidationProcessUtils.getFormattedDate(this.notAfterRevoc));
                }
            }
        }
        return this.notAfterRevoc;
    }

    private Date getExpiredCertsRevocationInfo(RevocationWrapper revocationData) {
        CertificateWrapper revocCert = revocationData.getSigningCertificate();
        if (revocCert != null) {
            return revocCert.getCertificateTSPServiceExpiredCertsRevocationInfo();
        }
        return null;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (!this.process()) {
            return this.getNotAfterAfterCertificateNotAfterMessage();
        }
        if (this.checkRevocationThisUpdateIsInCertificateValidityRange()) {
            return this.getRevocationConsistentMessage();
        }
        if (this.checkCertHashMatches()) {
            return this.getRevocationCertHashOkMessage();
        }
        if (this.checkExpiredCertsOnCRLPresent()) {
            return this.getRevocationConsistentWithExpiredCertsOnCRLMessage();
        }
        if (this.checkArchiveCutOffPresent()) {
            return this.getRevocationConsistentWithArchiveCutoffMessage();
        }
        if (this.checkExpiredCertsRevocationInfoPresent()) {
            return this.getRevocationConsistentWithExpiredCertsRevocationInfoMessage();
        }
        return this.getRevocationInfoMessage();
    }

    private boolean checkRevocationThisUpdateIsInCertificateValidityRange() {
        return this.revocationData.getThisUpdate().compareTo(this.certificate.getNotBefore()) >= 0 && this.revocationData.getThisUpdate().compareTo(this.certificate.getNotAfter()) <= 0;
    }

    private boolean checkExpiredCertsOnCRLPresent() {
        return this.revocationData.getExpiredCertsOnCRL() != null;
    }

    private boolean checkArchiveCutOffPresent() {
        return this.revocationData.getArchiveCutOff() != null;
    }

    private boolean checkExpiredCertsRevocationInfoPresent() {
        return this.getExpiredCertsRevocationInfo(this.revocationData) != null;
    }

    protected String getNotAfterAfterCertificateNotAfterMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_NOT_AFTER_AFTER, new Object[]{ValidationProcessUtils.getFormattedDate(this.notAfterRevoc), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    private String getRevocationConsistentMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    private String getRevocationCertHashOkMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CERT_HASH_OK, new Object[0]);
    }

    private String getRevocationConsistentWithExpiredCertsOnCRLMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_CRL, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.revocationData.getExpiredCertsOnCRL()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    private String getRevocationConsistentWithArchiveCutoffMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_OCSP, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.revocationData.getArchiveCutOff()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    private String getRevocationConsistentWithExpiredCertsRevocationInfoMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_CONSISTENT_TL, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.getExpiredCertsRevocationInfo(this.revocationData)), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    private String getRevocationInfoMessage() {
        return this.i18nProvider.getMessage(MessageTag.REVOCATION_INFO, new Object[]{ValidationProcessUtils.getFormattedDate(this.revocationData.getThisUpdate()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotBefore()), ValidationProcessUtils.getFormattedDate(this.certificate.getNotAfter())});
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_REVOC_HAS_CERT_INFO;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_REVOC_HAS_CERT_INFO_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

