/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.validation.process.ChainItem;
import java.util.List;

public class BasicConstraintsMaxPathLengthCheck
extends ChainItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public BasicConstraintsMaxPathLengthCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        List certificateChain = this.certificate.getCertificateChain();
        int maxPathLength = certificateChain.size() + 1;
        for (int i = certificateChain.size() - 1; i > -1; --i) {
            int pathLenConstraint;
            CertificateWrapper cert = (CertificateWrapper)certificateChain.get(i);
            if (!cert.isSelfSigned()) {
                --maxPathLength;
            }
            if ((pathLenConstraint = cert.getPathLenConstraint()) == -1 || pathLenConstraint >= maxPathLength) continue;
            maxPathLength = pathLenConstraint;
        }
        return maxPathLength > 0;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_ICPDV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_ICPDV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

