/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlGeneralSubtree;
import eu.europa.esig.dss.enumerations.GeneralNameType;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateNameConstraintsCheck
extends ChainItem<XmlSubXCV> {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateNameConstraintsCheck.class);
    private final CertificateWrapper certificate;

    public CertificateNameConstraintsCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        ArrayList<CertificateWrapper> certificateChain = new ArrayList<CertificateWrapper>();
        certificateChain.add(this.certificate);
        certificateChain.addAll(this.certificate.getCertificateChain());
        Map<GeneralNameType, Set<XmlGeneralName>> permittedSubtrees = null;
        Map<GeneralNameType, Set<XmlGeneralName>> excludedSubtrees = null;
        for (int i = certificateChain.size() - 1; i > -1; --i) {
            CertificateWrapper cert = (CertificateWrapper)certificateChain.get(i);
            if (i == 0) {
                Set<XmlGeneralName> subtreesOfType;
                Set dnGeneralNames;
                String certDN = cert.getCertificateDN();
                List subAltNames = cert.getSubjectAlternativeNames();
                if (!this.containsRFC822SubjectAlternativeName(subAltNames)) {
                    subAltNames.addAll(this.getEmailAddressDNIfPresent(certDN));
                }
                if (permittedSubtrees != null) {
                    dnGeneralNames = (Set)permittedSubtrees.get(GeneralNameType.DIRECTORY_NAME);
                    if (dnGeneralNames != null && !this.isWithinDNSubtrees(certDN, dnGeneralNames)) {
                        return false;
                    }
                    for (XmlGeneralName subAltName : subAltNames) {
                        subtreesOfType = permittedSubtrees.get(subAltName.getType());
                        if (subtreesOfType == null || this.isWithinSubtrees(subAltName, subtreesOfType)) continue;
                        return false;
                    }
                }
                if (excludedSubtrees != null) {
                    dnGeneralNames = (Set)excludedSubtrees.get(GeneralNameType.DIRECTORY_NAME);
                    if (dnGeneralNames != null && this.isWithinDNSubtrees(certDN, dnGeneralNames)) {
                        return false;
                    }
                    for (XmlGeneralName subAltName : subAltNames) {
                        subtreesOfType = excludedSubtrees.get(subAltName.getType());
                        if (subtreesOfType == null || !this.isWithinSubtrees(subAltName, subtreesOfType)) continue;
                        return false;
                    }
                }
            }
            Map<GeneralNameType, Set<XmlGeneralName>> certPermittedSubtrees = this.toXmlGeneralNameMap(cert.getPermittedSubtrees());
            Map<GeneralNameType, Set<XmlGeneralName>> certExcludedSubtrees = this.toXmlGeneralNameMap(cert.getExcludedSubtrees());
            if (certPermittedSubtrees != null) {
                permittedSubtrees = permittedSubtrees != null ? this.intersectNew(permittedSubtrees, certPermittedSubtrees) : certPermittedSubtrees;
            }
            if (certExcludedSubtrees == null) continue;
            excludedSubtrees = excludedSubtrees != null ? this.unionNew(excludedSubtrees, certExcludedSubtrees) : certExcludedSubtrees;
        }
        return true;
    }

    private boolean containsRFC822SubjectAlternativeName(List<XmlGeneralName> subAltNames) {
        return Utils.isCollectionNotEmpty(subAltNames) && subAltNames.stream().anyMatch(n -> GeneralNameType.RFC822_NAME.equals((Object)n.getType()));
    }

    private Set<XmlGeneralName> getEmailAddressDNIfPresent(String certDN) {
        Map<String, Set<String>> dnMap = this.toDNMap(certDN);
        Set<String> emailAddressValues = dnMap.get("1.2.840.113549.1.9.1");
        HashSet<XmlGeneralName> result = new HashSet<XmlGeneralName>();
        if (emailAddressValues != null) {
            for (String emailAddress : emailAddressValues) {
                XmlGeneralName xmlGeneralName = new XmlGeneralName();
                xmlGeneralName.setType(GeneralNameType.RFC822_NAME);
                xmlGeneralName.setValue(emailAddress);
                result.add(xmlGeneralName);
            }
        }
        return result;
    }

    private Map<String, Set<String>> toDNMap(String rfc2253EncodedString) {
        Map.Entry<String, String> rdn;
        if (Utils.isStringEmpty((String)rfc2253EncodedString)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        int nextEnd = rfc2253EncodedString.indexOf(44);
        int searchOffset = 0;
        int dnOffset = 0;
        while (nextEnd >= 0) {
            if (nextEnd > 0 && rfc2253EncodedString.charAt(nextEnd - 1) != '\\') {
                String nextStr = rfc2253EncodedString.substring(dnOffset, nextEnd);
                rdn = this.getRDN(nextStr);
                if (rdn != null) {
                    this.enrichMap(result, rdn.getKey(), rdn.getValue());
                }
                dnOffset = nextEnd + 1;
            }
            searchOffset = nextEnd + 1;
            nextEnd = rfc2253EncodedString.indexOf(44, searchOffset);
        }
        String substring = rfc2253EncodedString.substring(dnOffset);
        rdn = this.getRDN(substring);
        if (rdn != null) {
            this.enrichMap(result, rdn.getKey(), rdn.getValue());
        }
        return result;
    }

    private void enrichMap(Map<String, Set<String>> dnMap, String rdnKey, String rdnValue) {
        Set values = dnMap.computeIfAbsent(rdnKey, k -> new HashSet());
        values.add(rdnValue);
    }

    private Map.Entry<String, String> getRDN(String str) {
        int nextEquals = str.indexOf(61);
        if (nextEquals >= 0 && str.length() >= nextEquals + 1) {
            return new AbstractMap.SimpleEntry<String, String>(str.substring(0, nextEquals), str.substring(nextEquals + 1));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to build an RDN for string '{}'! Not a DN.", (Object)str);
        }
        return null;
    }

    private boolean isWithinSubtrees(XmlGeneralName generalName, Set<XmlGeneralName> permittedSubtrees) {
        for (XmlGeneralName permittedSubtree : permittedSubtrees) {
            if (!this.isWithinSubtree(generalName, permittedSubtree)) continue;
            return true;
        }
        return false;
    }

    private boolean isWithinDNSubtrees(String certDN, Set<XmlGeneralName> permittedSubtrees) {
        if (Utils.isStringEmpty((String)certDN) && Utils.isCollectionEmpty(permittedSubtrees)) {
            return true;
        }
        for (XmlGeneralName permittedSubtree : permittedSubtrees) {
            if (!this.isWithinDNSubtree(certDN, permittedSubtree.getValue())) continue;
            return true;
        }
        return false;
    }

    private Map<GeneralNameType, Set<XmlGeneralName>> toXmlGeneralNameMap(Collection<XmlGeneralSubtree> generalSubtrees) {
        if (Utils.isCollectionEmpty(generalSubtrees)) {
            return null;
        }
        EnumMap<GeneralNameType, Set<XmlGeneralName>> result = new EnumMap<GeneralNameType, Set<XmlGeneralName>>(GeneralNameType.class);
        for (XmlGeneralSubtree generalSubtree : generalSubtrees) {
            Set values = result.computeIfAbsent(generalSubtree.getType(), k -> new HashSet());
            values.add(generalSubtree);
        }
        return result;
    }

    private Map<GeneralNameType, Set<XmlGeneralName>> intersectNew(Map<GeneralNameType, Set<XmlGeneralName>> originalConstraints, Map<GeneralNameType, Set<XmlGeneralName>> currentConstraints) {
        EnumMap<GeneralNameType, Set<XmlGeneralName>> result = new EnumMap<GeneralNameType, Set<XmlGeneralName>>(GeneralNameType.class);
        for (Map.Entry<GeneralNameType, Set<XmlGeneralName>> currentEntry : currentConstraints.entrySet()) {
            GeneralNameType type = currentEntry.getKey();
            Set<XmlGeneralName> currentGeneralNames = currentEntry.getValue();
            Set intersection = result.computeIfAbsent(type, k -> new HashSet());
            Set<XmlGeneralName> originalSubtrees = originalConstraints.get(type);
            if (Utils.isCollectionNotEmpty(originalSubtrees)) {
                for (XmlGeneralName currentGeneralName : currentGeneralNames) {
                    for (XmlGeneralName originalGeneralName : originalSubtrees) {
                        if (this.isWithinSubtree(originalGeneralName, currentGeneralName)) {
                            intersection.add(originalGeneralName);
                            continue;
                        }
                        if (!this.isWithinSubtree(currentGeneralName, originalGeneralName)) continue;
                        intersection.add(currentGeneralName);
                    }
                }
                continue;
            }
            intersection.addAll(currentGeneralNames);
        }
        for (Map.Entry<GeneralNameType, Set<XmlGeneralName>> originalEntry : originalConstraints.entrySet()) {
            if (result.containsKey(originalEntry.getKey())) continue;
            Set intersection = result.computeIfAbsent(originalEntry.getKey(), k -> new HashSet());
            intersection.addAll((Collection)originalEntry.getValue());
        }
        return result;
    }

    private Map<GeneralNameType, Set<XmlGeneralName>> unionNew(Map<GeneralNameType, Set<XmlGeneralName>> originalConstraints, Map<GeneralNameType, Set<XmlGeneralName>> currentConstraints) {
        EnumMap<GeneralNameType, Set<XmlGeneralName>> result = new EnumMap<GeneralNameType, Set<XmlGeneralName>>(GeneralNameType.class);
        for (Map.Entry<GeneralNameType, Set<XmlGeneralName>> currentEntry : currentConstraints.entrySet()) {
            GeneralNameType type = currentEntry.getKey();
            Set<XmlGeneralName> currentGeneralNames = currentEntry.getValue();
            Set union = result.computeIfAbsent(type, k -> new HashSet());
            Set<XmlGeneralName> originalSubtrees = originalConstraints.get(type);
            if (Utils.isCollectionNotEmpty(originalSubtrees)) {
                for (XmlGeneralName currentGeneralName : currentGeneralNames) {
                    for (XmlGeneralName originalGeneralName : originalSubtrees) {
                        if (this.isWithinSubtree(originalGeneralName, currentGeneralName)) {
                            union.add(currentGeneralName);
                            continue;
                        }
                        if (this.isWithinSubtree(currentGeneralName, originalGeneralName)) {
                            union.add(originalGeneralName);
                            continue;
                        }
                        union.add(currentGeneralName);
                        union.add(originalGeneralName);
                    }
                }
                continue;
            }
            union.addAll(currentGeneralNames);
        }
        for (Map.Entry<GeneralNameType, Set<XmlGeneralName>> originalEntry : originalConstraints.entrySet()) {
            if (result.containsKey(originalEntry.getKey())) continue;
            Set union = result.computeIfAbsent(originalEntry.getKey(), k -> new HashSet());
            union.addAll((Collection)originalEntry.getValue());
        }
        return result;
    }

    private boolean isWithinSubtree(XmlGeneralName generalName, XmlGeneralName subtreeGeneralName) {
        if (Utils.isStringEmpty((String)generalName.getValue()) || Utils.isStringEmpty((String)subtreeGeneralName.getValue())) {
            return false;
        }
        if (!GeneralNameType.IP_ADDRESS.equals((Object)generalName.getType()) && subtreeGeneralName.getValue().length() > generalName.getValue().length()) {
            return false;
        }
        switch (generalName.getType()) {
            case UNIFORM_RESOURCE_IDENTIFIER: {
                return this.isWithinURISubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
            case RFC822_NAME: {
                return this.isWithinEmailSubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
            case DNS_NAME: {
                return this.isWithinDNSSubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
            case DIRECTORY_NAME: {
                return this.isWithinDNSubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
            case IP_ADDRESS: {
                return this.isWithinIPAddressSubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
            case OTHER_NAME: 
            case X400_ADDRESS: 
            case EDI_PARTY_NAME: 
            case REGISTERED_ID: {
                LOG.warn("The NameConstraint of type '{}' is not supported. Full comparison is executed.", (Object)generalName.getType());
                return this.isWithinOtherNameSubtree(generalName.getValue(), subtreeGeneralName.getValue());
            }
        }
        return false;
    }

    private boolean isWithinURISubtree(String value, String subtree) {
        String domainNameSubtree = ValidationProcessUtils.getDomainName(subtree);
        String domainNameValue = ValidationProcessUtils.getDomainName(value);
        return this.isWithinDomain(domainNameValue, domainNameSubtree);
    }

    private boolean isWithinDomain(String value, String domain) {
        if (domain.startsWith(".")) {
            return value.toLowerCase().endsWith(domain.toLowerCase());
        }
        return domain.equalsIgnoreCase(value);
    }

    private boolean isWithinEmailSubtree(String value, String subtree) {
        if (this.isEmail(subtree)) {
            return value.equalsIgnoreCase(subtree);
        }
        if (this.isEmail(value)) {
            value = this.getDomainNameFromEmail(value);
        }
        return this.isWithinDomain(value, subtree);
    }

    private boolean isEmail(String str) {
        return str.indexOf(64) != -1;
    }

    private String getDomainNameFromEmail(String email) {
        return email.substring(email.indexOf(64) + 1);
    }

    private boolean isWithinDNSSubtree(String value, String subtree) {
        Object[] subTreeArray;
        Object[] valueArray = value.split("\\.");
        int diff = valueArray.length - (subTreeArray = subtree.split("\\.")).length;
        if (diff == 0) {
            return Arrays.equals(subTreeArray, valueArray);
        }
        if (diff > 0) {
            for (int i = subTreeArray.length - 1; i > -1; --i) {
                if (((String)subTreeArray[i]).equals(valueArray[i + diff])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isWithinDNSubtree(String value, String subtree) {
        Map<String, Set<String>> dnMap = this.toDNMap(value);
        Map<String, Set<String>> subtreeMap = this.toDNMap(subtree);
        for (Map.Entry<String, Set<String>> entry : subtreeMap.entrySet()) {
            String subtreeKey = entry.getKey();
            Set<String> subtreeValues = entry.getValue();
            if (dnMap.containsKey(subtreeKey) && dnMap.get(subtreeKey).containsAll(subtreeValues)) continue;
            return false;
        }
        return true;
    }

    private boolean isWithinIPAddressSubtree(String value, String subtree) {
        byte[] constraint;
        byte[] ipAddress = this.toByteArrayIPAddress(value);
        int length = ipAddress.length;
        if (length != (constraint = this.toByteArrayIPAddress(subtree)).length / 2) {
            return false;
        }
        byte[] subnetMask = Utils.subarray((byte[])constraint, (int)length, (int)constraint.length);
        byte[] constraintSubnetAddress = new byte[length];
        byte[] ipSubnetAddress = new byte[length];
        for (int i = 0; i < length; ++i) {
            constraintSubnetAddress[i] = (byte)(constraint[i] & subnetMask[i]);
            ipSubnetAddress[i] = (byte)(ipAddress[i] & subnetMask[i]);
        }
        return Arrays.equals(constraintSubnetAddress, ipSubnetAddress);
    }

    private byte[] toByteArrayIPAddress(String ipAddress) {
        if (ipAddress.startsWith("#") && Utils.isHexEncoded((String)(ipAddress = ipAddress.replace("#", "")))) {
            return Utils.fromHex((String)ipAddress);
        }
        LOG.debug("Incorrectly encoded IP Address value: {}", (Object)ipAddress);
        return ipAddress.getBytes();
    }

    private boolean isWithinOtherNameSubtree(String value, String subtree) {
        return subtree.equals(value);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_DCSBSINC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_DCSBSINC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

