/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.sub.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateExtension;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.MultiValuesRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.ArrayList;
import java.util.List;

public class CertificateSupportedCriticalExtensionsCheck
extends AbstractMultiValuesCheckItem<XmlSubXCV> {
    private final CertificateWrapper certificate;

    public CertificateSupportedCriticalExtensionsCheck(I18nProvider i18nProvider, XmlSubXCV result, CertificateWrapper certificate, MultiValuesRule constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
    }

    @Override
    protected boolean process() {
        return Utils.isCollectionEmpty(this.getUnsupportedCertificateExtensionsOids());
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_XCV_DCCUCE;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_XCV_DCCUCE_ANS;
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(this.getErrorMessageTag(), this.getUnsupportedCertificateExtensionsOids());
    }

    private List<String> getUnsupportedCertificateExtensionsOids() {
        ArrayList<String> values = new ArrayList<String>();
        for (XmlCertificateExtension certificateExtension : this.certificate.getCertificateExtensions()) {
            if (certificateExtension.isCritical() == null || !certificateExtension.isCritical().booleanValue() || this.processValueCheck(certificateExtension.getOID())) continue;
            values.add(certificateExtension.getOID());
        }
        return values;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.CERTIFICATE_CHAIN_GENERAL_FAILURE;
    }
}

