/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.timestamp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlMessage;
import eu.europa.esig.dss.diagnostic.TrustServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.model.policy.LevelRule;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.List;

public class GrantedStatusAtTimeCheck<T extends XmlConstraintsConclusion>
extends ChainItem<T> {
    private final List<TrustServiceWrapper> trustServicesAtTime;
    private final ValidationTime validationTime;

    public GrantedStatusAtTimeCheck(I18nProvider i18nProvider, T result, List<TrustServiceWrapper> trustServicesAtTime, ValidationTime validationTime, LevelRule constraint) {
        super(i18nProvider, result, constraint);
        this.trustServicesAtTime = trustServicesAtTime;
        this.validationTime = validationTime;
    }

    @Override
    protected boolean process() {
        return Utils.isCollectionNotEmpty(this.trustServicesAtTime);
    }

    @Override
    protected XmlMessage buildConstraintMessage() {
        return this.buildXmlMessage(MessageTag.QUAL_HAS_GRANTED_AT, ValidationProcessUtils.getValidationTimeMessageTag(this.validationTime));
    }

    @Override
    protected XmlMessage buildErrorMessage() {
        return this.buildXmlMessage(MessageTag.QUAL_HAS_GRANTED_AT_ANS, ValidationProcessUtils.getValidationTimeMessageTag(this.validationTime));
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

