/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.Base64Transform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.ReferenceOutputType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReferenceProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReferenceProcessor.class);
    private XAdESSignatureParameters signatureParameters;

    public ReferenceProcessor() {
    }

    public ReferenceProcessor(XAdESSignatureParameters signatureParameters) {
        this.signatureParameters = signatureParameters;
    }

    public DSSDocument getReferenceOutput(DSSReference reference) {
        if (reference.getContents() instanceof DigestDocument) {
            return reference.getContents();
        }
        Node nodeToTransform = this.dereferenceNode(reference);
        if (nodeToTransform == null) {
            return reference.getContents();
        }
        List<DSSTransform> transforms = reference.getTransforms();
        if (this.isUniqueBase64Transform(transforms)) {
            return reference.getContents();
        }
        byte[] referenceOutputResult = DSSXMLUtils.applyTransforms(nodeToTransform, reference.getTransforms());
        if (ReferenceOutputType.NODE_SET.equals((Object)DSSXMLUtils.getReferenceOutputType(reference)) && DomUtils.isDOM((byte[])referenceOutputResult)) {
            referenceOutputResult = DSSXMLUtils.canonicalize("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", referenceOutputResult);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reference output : ");
            LOG.trace(new String(referenceOutputResult));
        }
        return new InMemoryDocument(referenceOutputResult);
    }

    private Node dereferenceNode(DSSReference reference) {
        Node deReferencedNode = this.getNodeToTransform(reference);
        if (deReferencedNode != null && DSSXMLUtils.isSameDocumentReference(reference.getUri())) {
            deReferencedNode = DomUtils.excludeComments((Node)deReferencedNode);
        }
        return deReferencedNode;
    }

    private Node getNodeToTransform(DSSReference reference) {
        DSSDocument contents = reference.getContents();
        if (!DomUtils.isDOM((DSSDocument)contents)) {
            return null;
        }
        Document doc = DomUtils.buildDOM((DSSDocument)contents);
        String uri = reference.getUri();
        if (this.signatureParameters != null && this.signatureParameters.isEmbedXML()) {
            Element root = doc.getDocumentElement();
            Document doc2 = DomUtils.buildDOM();
            Element dom = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.signatureParameters.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            Element dom2 = DomUtils.createElementNS((Document)doc2, (DSSNamespace)this.signatureParameters.getXmldsigNamespace(), (DSSElement)XMLDSigElement.OBJECT);
            doc2.appendChild(dom2);
            dom2.appendChild(dom);
            dom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), DomUtils.getId((String)uri));
            Node adopted = doc2.adoptNode(root);
            dom.appendChild(adopted);
            return dom;
        }
        if (DomUtils.isElementReference((String)uri)) {
            DSSXMLUtils.recursiveIdBrowse(doc.getDocumentElement());
            String targetId = DomUtils.getId((String)uri);
            Element elementById = doc.getElementById(targetId);
            if (elementById != null) {
                return elementById;
            }
        }
        if (Utils.isCollectionNotEmpty(reference.getTransforms())) {
            return doc;
        }
        return null;
    }

    private boolean isUniqueBase64Transform(List<DSSTransform> transforms) {
        return transforms != null && transforms.size() == 1 && transforms.get(0) instanceof Base64Transform;
    }

    public void incorporateReferences(Element referenceContainer, List<DSSReference> references, DSSNamespace namespace) {
        if (Utils.isCollectionNotEmpty(references)) {
            Document documentDom = referenceContainer.getOwnerDocument();
            for (DSSReference dssReference : references) {
                String referenceType;
                String uri;
                Element referenceDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)namespace, (DSSElement)XMLDSigElement.REFERENCE);
                referenceContainer.appendChild(referenceDom);
                if (dssReference.getId() != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), dssReference.getId());
                }
                if ((uri = dssReference.getUri()) != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.URI.getAttributeName(), uri);
                }
                if ((referenceType = dssReference.getType()) != null) {
                    referenceDom.setAttribute(XMLDSigAttribute.TYPE.getAttributeName(), referenceType);
                }
                DSSXMLUtils.incorporateTransforms(referenceDom, dssReference.getTransforms(), namespace);
                DSSXMLUtils.incorporateDigestMethod(referenceDom, dssReference.getDigestMethodAlgorithm(), namespace);
                DSSDocument documentAfterTransforms = this.getReferenceOutput(dssReference);
                String base64EncodedDigestBytes = documentAfterTransforms.getDigest(dssReference.getDigestMethodAlgorithm());
                DSSXMLUtils.incorporateDigestValue(referenceDom, base64EncodedDigestBytes, namespace);
            }
        }
    }
}

