/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigPaths;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceIdProvider;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.signature.XAdESCounterSignatureParameters;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XMLDocumentValidator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CounterSignatureBuilder
extends ExtensionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CounterSignatureBuilder.class);
    private static final String COUNTER_SIGNATURE_PREFIX = "CS-";

    protected CounterSignatureBuilder(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    public DSSDocument getCanonicalizedSignatureValue(DSSDocument signatureDocument, XAdESCounterSignatureParameters parameters) {
        this.params = parameters;
        this.documentValidator = new XMLDocumentValidator(signatureDocument);
        this.documentDom = this.documentValidator.getRootElement();
        this.xadesSignature = this.extractSignatureById(parameters);
        Element signatureValueElement = this.getSignatureValueElement(this.xadesSignature);
        byte[] canonicalizedSignatureValue = DSSXMLUtils.canonicalizeSubtree(parameters.getCounterSignatureCanonicalizationMethod(), signatureValueElement);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canonicalized SignatureValue:");
            LOG.trace(new String(canonicalizedSignatureValue));
        }
        return new InMemoryDocument(canonicalizedSignatureValue);
    }

    public DSSReference buildCounterSignatureDSSReference(DSSDocument signatureDocument, XAdESCounterSignatureParameters parameters) {
        this.documentValidator = new XMLDocumentValidator(signatureDocument);
        this.documentDom = this.documentValidator.getRootElement();
        this.xadesSignature = this.extractSignatureById(parameters);
        this.initializeSignatureBuilder(this.xadesSignature);
        DSSReference reference = new DSSReference();
        ReferenceIdProvider referenceIdProvider = new ReferenceIdProvider();
        referenceIdProvider.setSignatureParameters(parameters);
        reference.setId(referenceIdProvider.getReferenceId());
        byte[] signatureElementBinaries = DSSXMLUtils.serializeNode(this.xadesSignature.getSignatureElement());
        reference.setContents((DSSDocument)new InMemoryDocument(signatureElementBinaries));
        reference.setDigestMethodAlgorithm(this.getReferenceDigestAlgorithmOrDefault(parameters));
        reference.setType(this.xadesPaths.getCounterSignatureUri());
        String signatureValueId = this.xadesSignature.getSignatureValueId();
        if (!Utils.isStringNotEmpty((String)signatureValueId)) {
            throw new IllegalInputException(String.format("The signature with Id '%s' does not have an Id for a SignatureValue element! Unable to counter sign.", parameters.getSignatureIdToCounterSign()));
        }
        reference.setUri(DomUtils.toElementReference((String)signatureValueId));
        CanonicalizationTransform transform = new CanonicalizationTransform(parameters.getCounterSignatureCanonicalizationMethod());
        reference.setTransforms(Collections.singletonList(transform));
        return reference;
    }

    public DSSDocument buildEmbeddedCounterSignature(DSSDocument signatureDocument, DSSDocument counterSignature, XAdESCounterSignatureParameters parameters) {
        this.params = parameters;
        this.documentValidator = new XMLDocumentValidator(signatureDocument);
        this.documentDom = this.documentValidator.getRootElement();
        this.xadesSignature = this.extractSignatureById(parameters);
        this.initializeSignatureBuilder(this.xadesSignature);
        Element levelBUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        this.incorporateCounterSignature(counterSignature);
        this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelBUnsignedProperties);
        return this.createXmlDocument();
    }

    private void incorporateCounterSignature(DSSDocument counterSignature) {
        Document counterSignatureDom = DomUtils.buildDOM((DSSDocument)counterSignature);
        NodeList signatureNodeList = counterSignatureDom.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", XMLDSigElement.SIGNATURE.getTagName());
        if (signatureNodeList.getLength() != 1) {
            throw new IllegalInputException(String.format("The counterSignature document shall have one counter signature, when %s signatures found!", signatureNodeList.getLength()));
        }
        Element signatureElement = (Element)signatureNodeList.item(0);
        Node adopted = this.documentDom.importNode(signatureElement, true);
        Element counterSignatureElement = DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)this.getXadesNamespace(), (DSSElement)this.getCurrentXAdESElements().getElementCounterSignature());
        counterSignatureElement.setAttribute(XMLDSigAttribute.ID.getAttributeName(), COUNTER_SIGNATURE_PREFIX + this.params.getDeterministicId());
        counterSignatureElement.appendChild(adopted);
    }

    private XAdESSignature extractSignatureById(XAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignatureIdToCounterSign(), "The Id of a signature to be counter signed shall be defined! Please use SerializableCounterSignatureParameters.setSignatureIdToCounterSign(signatureId) method.");
        List signatures = this.documentValidator.getSignatures();
        for (AdvancedSignature signature : signatures) {
            XAdESSignature signatureById = this.getSignatureOrItsCounterSignatureById((XAdESSignature)signature, parameters.getSignatureIdToCounterSign());
            if (signatureById == null) continue;
            return signatureById;
        }
        throw new IllegalArgumentException(String.format("A signature with Id '%s' has not been found in the file! Unable to counter sign.", parameters.getSignatureIdToCounterSign()));
    }

    private XAdESSignature getSignatureOrItsCounterSignatureById(XAdESSignature signature, String signatureId) {
        if (signatureId.equals(signature.getDAIdentifier()) || signatureId.equals(signature.getId())) {
            return signature;
        }
        for (AdvancedSignature counterSignature : signature.getCounterSignatures()) {
            XAdESSignature counterSignatureById = this.getSignatureOrItsCounterSignatureById((XAdESSignature)counterSignature, signatureId);
            if (counterSignatureById == null) continue;
            if (signature.getTimestampSource().isTimestamped(signatureId, TimestampedObjectType.SIGNATURE)) {
                throw new IllegalInputException(String.format("Unable to counter sign a signature with Id '%s'. The signature is timestamped by a master signature!", signatureId));
            }
            return counterSignatureById;
        }
        return null;
    }

    private Element getSignatureValueElement(XAdESSignature xadesSignature) {
        Element signatureElement = xadesSignature.getSignatureElement();
        Element signatureValueElement = DomUtils.getElement((Node)signatureElement, (String)XMLDSigPaths.SIGNATURE_VALUE_PATH);
        if (signatureValueElement != null) {
            return signatureValueElement;
        }
        throw new IllegalInputException(String.format("Unable to counter sign a signature with Id '%s'. The SignatureValue element is not found!", xadesSignature.getDAIdentifier()));
    }
}

