/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSElement;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.ReferenceBuilder;
import eu.europa.esig.dss.xades.reference.ReferenceIdProvider;
import eu.europa.esig.dss.xades.reference.ReferenceProcessor;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManifestBuilder {
    private static final String DEFAULT_MANIFEST_ID = "manifest";
    private static final DSSNamespace DEFAULT_NAMESPACE = XAdESNamespaces.XMLDSIG;
    private final String manifestId;
    private final List<DSSReference> references;
    private final DSSNamespace xmldsigNamespace;

    public ManifestBuilder(DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this(DEFAULT_MANIFEST_ID, digestAlgorithm, documents);
    }

    public ManifestBuilder(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        this(manifestId, digestAlgorithm, documents, DEFAULT_NAMESPACE);
    }

    public ManifestBuilder(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents, DSSNamespace xmldsigNamespace) {
        this(manifestId, ManifestBuilder.createReferences(manifestId, digestAlgorithm, documents), xmldsigNamespace);
    }

    public ManifestBuilder(List<DSSReference> references) {
        this(DEFAULT_MANIFEST_ID, references);
    }

    public ManifestBuilder(String manifestId, List<DSSReference> references) {
        this(manifestId, references, DEFAULT_NAMESPACE);
    }

    public ManifestBuilder(String manifestId, List<DSSReference> references, DSSNamespace xmldsigNamespace) {
        if (Utils.isCollectionEmpty(references)) {
            throw new IllegalArgumentException("List of references cannot be empty!");
        }
        this.manifestId = manifestId;
        this.references = references;
        this.xmldsigNamespace = xmldsigNamespace;
    }

    private static List<DSSReference> createReferences(String manifestId, DigestAlgorithm digestAlgorithm, List<DSSDocument> documents) {
        if (Utils.isCollectionEmpty(documents)) {
            throw new IllegalArgumentException("List of documents cannot be empty!");
        }
        ReferenceIdProvider referenceIdProvider = new ReferenceIdProvider();
        referenceIdProvider.setReferenceIdPrefix("r-" + manifestId);
        ReferenceBuilder referenceBuilder = new ReferenceBuilder(documents, digestAlgorithm, referenceIdProvider);
        return referenceBuilder.build();
    }

    public DSSDocument build() {
        Document documentDom = DomUtils.buildDOM();
        Element manifestDom = DomUtils.createElementNS((Document)documentDom, (DSSNamespace)this.xmldsigNamespace, (DSSElement)XMLDSigElement.MANIFEST);
        manifestDom.setAttribute(XMLDSigAttribute.ID.getAttributeName(), this.manifestId);
        documentDom.appendChild(manifestDom);
        ReferenceProcessor referenceProcessor = new ReferenceProcessor();
        referenceProcessor.incorporateReferences(manifestDom, this.references, this.xmldsigNamespace);
        return DomUtils.createDssDocumentFromDomDocument((Document)documentDom, (String)this.manifestId);
    }
}

