/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.SignatureScopeType;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.validation.scope.SignatureScopeWithTransformations;
import java.util.List;
import java.util.Objects;

public class XPointerSignatureScope
extends SignatureScopeWithTransformations {
    private static final long serialVersionUID = 203530674533107438L;
    private final String uri;

    protected XPointerSignatureScope(String uri, List<String> transformations, Digest digest) {
        super(XPointerSignatureScope.getDocumentNameFromXPointer(uri), digest, transformations);
        this.uri = uri;
    }

    private static String getDocumentNameFromXPointer(String uri) {
        return DomUtils.isRootXPointer((String)uri) ? "Full XML file" : DomUtils.getXPointerId((String)uri);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder("XPointer query to ");
        if (DomUtils.isRootXPointer((String)this.uri)) {
            sb.append("root XML element");
        } else {
            sb.append("element with Id '");
            sb.append(this.getName());
            sb.append("'");
        }
        return this.addTransformationIfNeeded(sb.toString());
    }

    public SignatureScopeType getType() {
        return DomUtils.isRootXPointer((String)this.uri) ? SignatureScopeType.FULL : SignatureScopeType.PARTIAL;
    }

    public String toString() {
        return "XPointerSignatureScope{uri='" + this.uri + '\'' + "} " + super.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XPointerSignatureScope)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XPointerSignatureScope that = (XPointerSignatureScope)((Object)o);
        return Objects.equals(this.uri, that.uri);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
        return result;
    }
}

