/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.BLevelParameters;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.signature.AbstractSignatureParametersBuilder;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.EnvelopedSignatureTransform;
import java.util.ArrayList;

public class TrustedListSignatureParametersBuilder
extends AbstractSignatureParametersBuilder<XAdESSignatureParameters> {
    private static final String DEFAULT_CANONICALIZATION = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private static final String DEFAULT_REFERENCE_PREFIX = "ref-enveloped-signature";
    private final DSSDocument tlXmlDocument;
    private String referenceId;
    private DigestAlgorithm referenceDigestAlgorithm = DigestAlgorithm.SHA512;

    public TrustedListSignatureParametersBuilder(CertificateToken signingCertificate, DSSDocument tlXmlDocument) {
        super(signingCertificate);
        this.tlXmlDocument = tlXmlDocument;
    }

    public TrustedListSignatureParametersBuilder setReferenceId(String referenceId) {
        this.referenceId = referenceId;
        return this;
    }

    public TrustedListSignatureParametersBuilder setReferenceDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.referenceDigestAlgorithm = digestAlgorithm;
        return this;
    }

    public TrustedListSignatureParametersBuilder setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return (TrustedListSignatureParametersBuilder)super.setDigestAlgorithm(digestAlgorithm);
    }

    public TrustedListSignatureParametersBuilder setEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        return (TrustedListSignatureParametersBuilder)super.setEncryptionAlgorithm(encryptionAlgorithm);
    }

    @Deprecated
    public TrustedListSignatureParametersBuilder setMaskGenerationFunction(MaskGenerationFunction maskGenerationFunction) {
        return (TrustedListSignatureParametersBuilder)super.setMaskGenerationFunction(maskGenerationFunction);
    }

    public TrustedListSignatureParametersBuilder setBLevelParams(BLevelParameters bLevelParams) {
        return (TrustedListSignatureParametersBuilder)super.setBLevelParams(bLevelParams);
    }

    protected XAdESSignatureParameters initParameters() {
        return new XAdESSignatureParameters();
    }

    public XAdESSignatureParameters build() {
        XAdESSignatureParameters signatureParameters = (XAdESSignatureParameters)super.build();
        signatureParameters.setSignaturePackaging(SignaturePackaging.ENVELOPED);
        signatureParameters.setSignatureLevel(SignatureLevel.XAdES_BASELINE_B);
        signatureParameters.setEn319132(false);
        ArrayList<DSSReference> references = new ArrayList<DSSReference>();
        DSSReference dssReference = new DSSReference();
        if (this.referenceId != null) {
            dssReference.setId(this.referenceId);
        } else {
            dssReference.setId(DEFAULT_REFERENCE_PREFIX);
        }
        dssReference.setUri("");
        dssReference.setContents(this.tlXmlDocument);
        dssReference.setDigestMethodAlgorithm(this.referenceDigestAlgorithm);
        ArrayList<DSSTransform> transforms = new ArrayList<DSSTransform>();
        EnvelopedSignatureTransform signatureTransform = new EnvelopedSignatureTransform();
        transforms.add(signatureTransform);
        CanonicalizationTransform dssTransform = new CanonicalizationTransform(DEFAULT_CANONICALIZATION);
        transforms.add(dssTransform);
        dssReference.setTransforms(transforms);
        references.add(dssReference);
        signatureParameters.setReferences(references);
        return signatureParameters;
    }
}

