/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.signature.SignatureRequirementsChecker;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.ValidationData;
import eu.europa.esig.dss.spi.validation.ValidationDataContainer;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;

public class XAdESLevelBaselineLT
extends XAdESLevelBaselineT {
    public XAdESLevelBaselineLT(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures) {
        super.extendSignatures(signatures);
        List<AdvancedSignature> signaturesToExtend = this.getExtendToLTLevelSignatures(signatures);
        if (Utils.isCollectionEmpty(signaturesToExtend)) {
            return;
        }
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            this.xadesSignature.resetCertificateSource();
            this.xadesSignature.resetRevocationSources();
            this.xadesSignature.resetTimestampSource();
        }
        SignatureRequirementsChecker signatureRequirementsChecker = this.getSignatureRequirementsChecker();
        if (SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel())) {
            signatureRequirementsChecker.assertExtendToLTLevelPossible(signaturesToExtend);
        }
        signatureRequirementsChecker.assertSignaturesValid(signaturesToExtend);
        signatureRequirementsChecker.assertCertificateChainValidForLTLevel(signaturesToExtend);
        ValidationDataContainer validationDataContainer = this.documentAnalyzer.getValidationData(signaturesToExtend);
        for (AdvancedSignature signature : signaturesToExtend) {
            this.initializeSignatureBuilder((XAdESSignature)signature);
            if (signatureRequirementsChecker.hasLTALevelOrHigher(signature)) continue;
            String indent = this.removeOldCertificateValues();
            this.removeOldRevocationValues();
            Element levelTUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
            ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
            Set certificateValuesToAdd = validationDataForInclusion.getCertificateTokens();
            Set crlsToAdd = validationDataForInclusion.getCrlTokens();
            Set ocspsToAdd = validationDataForInclusion.getOcspTokens();
            this.incorporateCertificateValues(this.unsignedSignaturePropertiesDom, certificateValuesToAdd, indent);
            this.incorporateRevocationValues(this.unsignedSignaturePropertiesDom, crlsToAdd, ocspsToAdd, indent);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelTUnsignedProperties);
        }
    }

    private List<AdvancedSignature> getExtendToLTLevelSignatures(List<AdvancedSignature> signatures) {
        ArrayList<AdvancedSignature> toBeExtended = new ArrayList<AdvancedSignature>();
        for (AdvancedSignature signature : signatures) {
            if (!this.ltLevelExtensionRequired(signature)) continue;
            toBeExtended.add(signature);
        }
        return toBeExtended;
    }

    private boolean ltLevelExtensionRequired(AdvancedSignature signature) {
        return SignatureLevel.XAdES_BASELINE_LT.equals((Object)this.params.getSignatureLevel()) || !signature.hasLTAProfile();
    }
}

