/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation.scope;

import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.scope.SignatureScope;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.spi.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.CounterSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.DigestSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.spi.validation.scope.SignatureScopeFinder;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.reference.XAdESReferenceValidation;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.scope.ManifestEntrySignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XPointerSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlElementSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlFullSignatureScope;
import eu.europa.esig.dss.xades.validation.scope.XmlRootSignatureScope;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder
implements SignatureScopeFinder<XAdESSignature> {
    public List<SignatureScope> findSignatureScope(XAdESSignature xadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        List<ReferenceValidation> referenceValidations = xadesSignature.getReferenceValidations();
        for (ReferenceValidation referenceValidation : referenceValidations) {
            if (DigestMatcherType.SIGNED_PROPERTIES.equals((Object)referenceValidation.getType()) || DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || DigestMatcherType.SIGNATURE_PROPERTIES.equals((Object)referenceValidation.getType()) || !(referenceValidation instanceof XAdESReferenceValidation)) continue;
            XAdESReferenceValidation xadesReferenceValidation = (XAdESReferenceValidation)referenceValidation;
            String uri = xadesReferenceValidation.getUri();
            String xmlIdOfSignedElement = DomUtils.getId((String)uri);
            List<String> transformations = xadesReferenceValidation.getTransformationNames();
            if (xadesReferenceValidation.isFound() && DigestMatcherType.XPOINTER.equals((Object)xadesReferenceValidation.getType())) {
                result.add((SignatureScope)new XPointerSignatureScope(uri, this.createInMemoryDocument(xadesReferenceValidation.getOriginalContentBytes()), transformations));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.OBJECT.equals((Object)xadesReferenceValidation.getType())) {
                Element objectById = DSSXMLUtils.getObjectById(xadesSignature.getSignatureElement(), uri);
                if (objectById == null || !objectById.hasChildNodes()) continue;
                Node referencedObject = objectById.getFirstChild();
                result.add((SignatureScope)new XmlElementSignatureScope(xmlIdOfSignedElement, this.createInMemoryDocument(DomUtils.getNodeBytes((Node)referencedObject)), transformations));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.MANIFEST.equals((Object)xadesReferenceValidation.getType())) {
                ManifestSignatureScope manifestSignatureScope = new ManifestSignatureScope(this.getReferenceName(xadesReferenceValidation), this.createDigestDocument(xadesReferenceValidation.getDigest()), xadesReferenceValidation.getTransformationNames());
                result.add((SignatureScope)manifestSignatureScope);
                for (ReferenceValidation manifestEntry : xadesReferenceValidation.getDependentValidations()) {
                    String manifestEntryReferenceName = this.getReferenceName(manifestEntry);
                    if (manifestEntryReferenceName == null || !manifestEntry.isFound()) continue;
                    SignatureScope detachedSignatureScopeResult = this.getFromDetachedContent(xadesSignature, transformations, this.getReferencedDocumentName(manifestEntry));
                    if (detachedSignatureScopeResult != null) {
                        manifestSignatureScope.addChildSignatureScope(detachedSignatureScopeResult);
                        continue;
                    }
                    if (manifestEntry.getDigest() == null) continue;
                    manifestSignatureScope.addChildSignatureScope((SignatureScope)new ManifestEntrySignatureScope(manifestEntryReferenceName, this.createDigestDocument(manifestEntry.getDigest()), this.getReferenceName(xadesReferenceValidation), manifestEntry.getTransformationNames()));
                }
                continue;
            }
            if (xadesReferenceValidation.isFound() && DigestMatcherType.COUNTER_SIGNATURE.equals((Object)xadesReferenceValidation.getType()) && xadesSignature.getMasterSignature() != null) {
                result.add((SignatureScope)new CounterSignatureScope(xadesSignature.getMasterSignature(), this.createInMemoryDocument(xadesReferenceValidation.getOriginalContentBytes())));
                continue;
            }
            if (xadesReferenceValidation.isFound() && "".equals(uri)) {
                byte[] originalContentBytes = xadesReferenceValidation.getOriginalContentBytes();
                if (originalContentBytes == null) continue;
                result.add((SignatureScope)new XmlRootSignatureScope(this.createInMemoryDocument(originalContentBytes), transformations));
                continue;
            }
            if (xadesReferenceValidation.isFound() && DomUtils.isElementReference((String)uri)) {
                Element signedElement = DomUtils.getElementById((Node)xadesSignature.getSignatureElement().getOwnerDocument(), (String)DomUtils.getId((String)uri));
                if (signedElement == null) continue;
                if (this.isEverythingCovered(xadesSignature, xmlIdOfSignedElement)) {
                    result.add((SignatureScope)new XmlRootSignatureScope(this.createInMemoryDocument(DomUtils.getNodeBytes((Node)signedElement)), transformations));
                    continue;
                }
                result.add((SignatureScope)new XmlElementSignatureScope(xmlIdOfSignedElement, this.createInMemoryDocument(DomUtils.getNodeBytes((Node)signedElement)), transformations));
                continue;
            }
            if (xadesReferenceValidation.isIntact() && Utils.isCollectionNotEmpty((Collection)xadesSignature.getDetachedContents())) {
                String referencedDocumentName = this.getReferencedDocumentName(xadesReferenceValidation);
                SignatureScope signatureScope = this.getFromDetachedContent(xadesSignature, transformations, referencedDocumentName);
                if (signatureScope == null) continue;
                result.add(signatureScope);
                continue;
            }
            if (!Utils.isCollectionEmpty(transformations)) continue;
            result.add((SignatureScope)new FullSignatureScope(uri, this.createDigestDocument(xadesReferenceValidation.getDigest())));
        }
        return result;
    }

    private String getReferencedDocumentName(ReferenceValidation referenceValidation) {
        if (Utils.isStringNotEmpty((String)referenceValidation.getDocumentName())) {
            return referenceValidation.getDocumentName();
        }
        if (Utils.isStringNotEmpty((String)referenceValidation.getUri())) {
            return DomUtils.getId((String)referenceValidation.getUri());
        }
        return null;
    }

    private String getReferenceName(ReferenceValidation referenceValidation) {
        if (Utils.isStringNotEmpty((String)referenceValidation.getDocumentName())) {
            return referenceValidation.getDocumentName();
        }
        if (Utils.isStringNotEmpty((String)referenceValidation.getId())) {
            return DomUtils.getId((String)referenceValidation.getId());
        }
        if (referenceValidation.getUri() != null) {
            return DomUtils.getId((String)referenceValidation.getUri());
        }
        return null;
    }

    private SignatureScope getFromDetachedContent(XAdESSignature xadesSignature, List<String> transformations, String relatedDocumentName) {
        List detachedContents = xadesSignature.getDetachedContents();
        if (Utils.isCollectionNotEmpty((Collection)detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                String fileName;
                if ((detachedDocument.getName() != null || relatedDocumentName != null || Utils.collectionSize((Collection)detachedContents) != 1) && (relatedDocumentName == null || !relatedDocumentName.equals(detachedDocument.getName()))) continue;
                String string = fileName = detachedDocument.getName() != null ? detachedDocument.getName() : relatedDocumentName;
                if (detachedDocument instanceof DigestDocument) {
                    DigestDocument digestDocument = (DigestDocument)detachedDocument;
                    return new DigestSignatureScope(fileName, (DSSDocument)digestDocument);
                }
                if (Utils.isCollectionNotEmpty(transformations)) {
                    return new XmlFullSignatureScope(fileName, detachedDocument, transformations);
                }
                if (this.isASiCSArchive((AdvancedSignature)xadesSignature)) {
                    ContainerSignatureScope containerSignatureScope = new ContainerSignatureScope(relatedDocumentName, detachedDocument);
                    for (DSSDocument archivedDocument : xadesSignature.getContainerContents()) {
                        containerSignatureScope.addChildSignatureScope((SignatureScope)new ContainerContentSignatureScope(archivedDocument));
                    }
                    return containerSignatureScope;
                }
                return new FullSignatureScope(fileName, detachedDocument);
            }
        }
        return null;
    }

    private boolean isEverythingCovered(XAdESSignature signature, String coveredObjectId) {
        Element parent = signature.getSignatureElement().getOwnerDocument().getDocumentElement();
        return parent != null && this.isRelatedToUri(parent, coveredObjectId);
    }

    private boolean isRelatedToUri(Node currentNode, String id) {
        String idValue = DSSXMLUtils.getIDIdentifier(currentNode);
        if (idValue == null) {
            return Utils.isStringBlank((String)id);
        }
        return id.equals(idValue) || id.equals("");
    }
}

