/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.evidencerecord;

import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EvidenceRecordTypeEnum;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.spi.exception.IllegalInputException;
import eu.europa.esig.dss.spi.signature.AdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.validation.CertificateVerifierBuilder;
import eu.europa.esig.dss.spi.validation.SignatureValidationAlerter;
import eu.europa.esig.dss.spi.validation.SignatureValidationContext;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzer;
import eu.europa.esig.dss.spi.validation.analyzer.evidencerecord.EvidenceRecordAnalyzerFactory;
import eu.europa.esig.dss.spi.validation.evidencerecord.EmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.evidencerecord.EvidenceRecord;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.xadesen.XAdESEvidencerecordNamespaceElement;
import eu.europa.esig.dss.xades.evidencerecord.XAdESEmbeddedEvidenceRecordHelper;
import eu.europa.esig.dss.xades.evidencerecord.XAdESEvidenceRecordIncorporationParameters;
import eu.europa.esig.dss.xades.signature.ExtensionBuilder;
import eu.europa.esig.dss.xades.validation.XAdESAttribute;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.XAdESUnsignedSigProperties;
import eu.europa.esig.dss.xades.validation.XMLDocumentAnalyzer;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.utils.DOMDocument;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbeddedEvidenceRecordBuilder
extends ExtensionBuilder {
    public EmbeddedEvidenceRecordBuilder(CertificateVerifier certificateVerifier) {
        super(new CertificateVerifierBuilder(certificateVerifier).buildOfflineCopy());
    }

    public DSSDocument addEvidenceRecord(DSSDocument signatureDocument, DSSDocument evidenceRecordDocument, XAdESEvidenceRecordIncorporationParameters parameters) {
        Objects.requireNonNull(signatureDocument, "Signature document must be provided!");
        Objects.requireNonNull(evidenceRecordDocument, "Evidence record document must be provided!");
        Objects.requireNonNull(parameters, "XAdESEvidenceRecordIncorporationParameters must be provided!");
        XAdESSignature signature = this.getXAdESSignature(signatureDocument, parameters.getSignatureId(), parameters.getDetachedContents());
        return this.addEvidenceRecord(signature, evidenceRecordDocument, parameters);
    }

    protected XAdESSignature getXAdESSignature(DSSDocument signatureDocument, String signatureId, List<DSSDocument> detachedContent) {
        XMLDocumentAnalyzer documentAnalyzer = this.initDocumentAnalyzer(signatureDocument, detachedContent);
        if (signatureId != null) {
            AdvancedSignature signature = documentAnalyzer.getSignatureById(signatureId);
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Unable to find a signature with Id : %s!", signatureId));
            }
            return (XAdESSignature)signature;
        }
        List signatures = documentAnalyzer.getSignatures();
        if (Utils.isCollectionEmpty((Collection)signatures)) {
            throw new IllegalInputException(String.format("No signatures found in the document with name '%s'", documentAnalyzer.getDocument().getName()));
        }
        if (Utils.collectionSize((Collection)signatures) > 1) {
            throw new IllegalArgumentException(String.format("More than one signature found in a document with name '%s'! Please provide a signatureId within the parameters.", documentAnalyzer.getDocument().getName()));
        }
        return (XAdESSignature)((Object)signatures.get(0));
    }

    protected DSSDocument addEvidenceRecord(XAdESSignature xadesSignature, DSSDocument evidenceRecordDocument, XAdESEvidenceRecordIncorporationParameters parameters) {
        Element evidenceRecordElement;
        xadesSignature = this.initializeSignatureBuilder(xadesSignature);
        this.ensureUnsignedProperties();
        this.ensureUnsignedSignatureProperties();
        XAdESAttribute unsignedAttribute = this.getUnsignedAttributeToEmbed(parameters);
        EvidenceRecord evidenceRecord = this.getEvidenceRecord(evidenceRecordDocument, xadesSignature, unsignedAttribute, parameters);
        Element sealingEvidenceRecordElement = this.getSealingEvidenceRecordElement(unsignedAttribute, parameters);
        switch (evidenceRecord.getEvidenceRecordType()) {
            case XML_EVIDENCE_RECORD: {
                Document erDom = DomUtils.buildDOM((DSSDocument)evidenceRecordDocument);
                List nodes = DomUtils.adoptChildren((Element)sealingEvidenceRecordElement, (Node)erDom);
                evidenceRecordElement = this.getEvidenceRecordElement(nodes);
                break;
            }
            case ASN1_EVIDENCE_RECORD: {
                String base64EncodedER = Utils.toBase64((byte[])evidenceRecord.getEncoded());
                evidenceRecordElement = DomUtils.addTextElement((Document)this.documentDom, (Element)sealingEvidenceRecordElement, (DSSNamespace)parameters.getXadesERNamespace(), (DSSElement)XAdESEvidencerecordNamespaceElement.ASN1_EVIDENCE_RECORD, (String)base64EncodedER);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The Evidence Record type '%s' is not supported!", evidenceRecord.getEvidenceRecordType()));
            }
        }
        if (EvidenceRecordTypeEnum.XML_EVIDENCE_RECORD == evidenceRecord.getEvidenceRecordType()) {
            DOMDocument signatureDocument = new DOMDocument((Node)evidenceRecordElement.getOwnerDocument());
            xadesSignature = this.getXAdESSignature((DSSDocument)signatureDocument, parameters.getSignatureId(), parameters.getDetachedContents());
            xadesSignature = this.initializeSignatureBuilder(xadesSignature);
            unsignedAttribute = this.getLastSealingEvidenceRecordAttribute();
            evidenceRecordDocument = new DOMDocument((Node)evidenceRecordElement);
            evidenceRecord = this.getEvidenceRecord(evidenceRecordDocument, xadesSignature, unsignedAttribute, parameters);
        }
        this.assertEvidenceRecordValid(evidenceRecord, unsignedAttribute, parameters);
        return this.createXmlDocument();
    }

    private Element getEvidenceRecordElement(Collection<Node> nodes) {
        for (Node node : nodes) {
            if (1 != node.getNodeType() || !XAdESEvidencerecordNamespaceElement.EVIDENCE_RECORD.isSameTagName(node.getLocalName())) continue;
            return (Element)node;
        }
        throw new IllegalStateException("No EvidenceRecord element found!");
    }

    private XAdESAttribute getUnsignedAttributeToEmbed(XAdESEvidenceRecordIncorporationParameters parameters) {
        if (parameters.isParallelEvidenceRecord()) {
            return this.getLastSealingEvidenceRecordAttribute();
        }
        return null;
    }

    private XAdESAttribute getLastSealingEvidenceRecordAttribute() {
        XAdESUnsignedSigProperties unsignedSigProperties = new XAdESUnsignedSigProperties(this.unsignedSignaturePropertiesDom, this.xadesPath);
        return XAdESSignatureUtils.getLastSealingEvidenceRecordAttribute(unsignedSigProperties);
    }

    private EvidenceRecord getEvidenceRecord(DSSDocument evidenceRecordDocument, XAdESSignature signature, XAdESAttribute unsignedAttribute, XAdESEvidenceRecordIncorporationParameters parameters) {
        try {
            EvidenceRecordAnalyzer evidenceRecordAnalyzer = EvidenceRecordAnalyzerFactory.fromDocument((DSSDocument)evidenceRecordDocument);
            XAdESEmbeddedEvidenceRecordHelper embeddedEvidenceRecordHelper = new XAdESEmbeddedEvidenceRecordHelper(signature, unsignedAttribute);
            embeddedEvidenceRecordHelper.setDetachedContents(parameters.getDetachedContents());
            evidenceRecordAnalyzer.setEmbeddedEvidenceRecordHelper((EmbeddedEvidenceRecordHelper)embeddedEvidenceRecordHelper);
            return evidenceRecordAnalyzer.getEvidenceRecord();
        }
        catch (Exception e) {
            throw new IllegalInputException(String.format("Unable to build an evidence record from the provided document. Reason : %s", e.getMessage()), (Throwable)e);
        }
    }

    private void assertEvidenceRecordValid(EvidenceRecord evidenceRecord, XAdESAttribute unsignedAttribute, XAdESEvidenceRecordIncorporationParameters parameters) {
        if (unsignedAttribute != null) {
            this.assertContainsOnlySameTypeEvidenceRecords(unsignedAttribute, evidenceRecord.getEvidenceRecordType());
        }
        for (ReferenceValidation referenceValidation : evidenceRecord.getReferenceValidation()) {
            if (DigestMatcherType.EVIDENCE_RECORD_ORPHAN_REFERENCE == referenceValidation.getType() || referenceValidation.isIntact()) continue;
            if (Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
                throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the signature and/or detached content! In case of detached signature, please use #setDetachedContent method to provide original documents.");
            }
            throw new IllegalInputException("The digest covered by the evidence record do not correspond to the digest computed on the signature and/or detached content!");
        }
        this.validateTimestamps(evidenceRecord);
    }

    private void assertContainsOnlySameTypeEvidenceRecords(XAdESAttribute unsignedAttribute, EvidenceRecordTypeEnum evidenceRecordType) {
        Element sealingEvidenceRecordElement = unsignedAttribute.getElement();
        NodeList childNodes = sealingEvidenceRecordElement.getChildNodes();
        block4: for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (1 != childNode.getNodeType()) continue;
            switch (evidenceRecordType) {
                case XML_EVIDENCE_RECORD: {
                    if (XAdESEvidencerecordNamespaceElement.EVIDENCE_RECORD.isSameTagName(childNode.getLocalName())) continue block4;
                    throw new IllegalInputException("The latest signature unsigned property contains evidence records other than ers:EvidenceRecordType type specified in IETF RFC 6283. The incorporation of different evidence record types within the same unsigned property is not supported.");
                }
                case ASN1_EVIDENCE_RECORD: {
                    if (XAdESEvidencerecordNamespaceElement.ASN1_EVIDENCE_RECORD.isSameTagName(childNode.getLocalName())) continue block4;
                    throw new IllegalInputException("The latest signature unsigned property contains evidence records other than EvidenceRecord type specified in IETF RFC 4998. The incorporation of different evidence record types within the same unsigned property is not supported.");
                }
                default: {
                    throw new UnsupportedOperationException(String.format("The evidence record type '%s' is not supported!", evidenceRecordType));
                }
            }
        }
    }

    private void validateTimestamps(EvidenceRecord evidenceRecord) {
        SignatureValidationContext validationContext = new SignatureValidationContext();
        validationContext.initialize(this.certificateVerifier);
        validationContext.addDocumentCertificateSource((CertificateSource)evidenceRecord.getCertificateSource());
        for (TimestampToken timestampToken : evidenceRecord.getTimestamps()) {
            validationContext.addTimestampTokenForVerification(timestampToken);
        }
        validationContext.validate();
        SignatureValidationAlerter signatureValidationAlerter = new SignatureValidationAlerter(validationContext);
        signatureValidationAlerter.setSigningOperation(SigningOperation.ADD_EVIDENCE_RECORD);
        signatureValidationAlerter.assertAllTimestampsValid();
    }

    private Element getSealingEvidenceRecordElement(XAdESAttribute unsignedAttribute, XAdESEvidenceRecordIncorporationParameters parameters) {
        if (unsignedAttribute != null) {
            return unsignedAttribute.getElement();
        }
        return DomUtils.addElement((Document)this.documentDom, (Element)this.unsignedSignaturePropertiesDom, (DSSNamespace)parameters.getXadesERNamespace(), (DSSElement)XAdESEvidencerecordNamespaceElement.SEALING_EVIDENCE_RECORDS);
    }

    private XMLDocumentAnalyzer initDocumentAnalyzer(DSSDocument signatureDocument, List<DSSDocument> detachedContents) {
        XMLDocumentAnalyzer analyzer = this.initDocumentAnalyzer(signatureDocument);
        analyzer.setDetachedContents(detachedContents);
        return analyzer;
    }
}

