/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.XPathPlacementSignatureBuilder;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class InternallyDetachedSignatureBuilder
extends XPathPlacementSignatureBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InternallyDetachedSignatureBuilder.class);
    private static final String DEFAULT_SIGNATURE_CONTAINER_NAME = "internally-detached";

    public InternallyDetachedSignatureBuilder(XAdESSignatureParameters params, DSSDocument document, CertificateVerifier certificateVerifier) {
        super(params, document, certificateVerifier);
    }

    @Override
    protected Document buildRootDocumentDom() {
        if (this.params.getRootDocument() != null) {
            return this.params.getRootDocument();
        }
        if (Utils.isStringNotEmpty((String)this.params.getXPathLocationString())) {
            return DomUtils.buildDOM((DSSDocument)this.document);
        }
        return this.createDefaultContainer();
    }

    private Document createDefaultContainer() {
        Document rootDocument = DomUtils.buildDOM();
        Element rootElement = rootDocument.createElement(DEFAULT_SIGNATURE_CONTAINER_NAME);
        rootDocument.appendChild(rootElement);
        return rootDocument;
    }

    @Override
    protected void incorporateFiles() {
        List<DSSReference> references = this.params.getReferences();
        for (DSSReference ref : references) {
            String elementId = DomUtils.getId((String)ref.getUri());
            if (DomUtils.getElementById((Node)this.documentDom, (String)elementId) == null) {
                Document doc = DomUtils.buildDOM((DSSDocument)ref.getContents());
                Element root = doc.getDocumentElement();
                Node adopted = this.documentDom.importNode(root, true);
                this.documentDom.getDocumentElement().appendChild(adopted);
                continue;
            }
            LOG.info("The element with Id '{}' is already present in the signing document! The addition is skipped.", (Object)elementId);
        }
    }
}

