/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.enumerations.SigningOperation;
import eu.europa.esig.dss.evidencerecord.EvidenceRecordIncorporationService;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.SignaturePolicyStore;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.signature.AbstractSignatureParameters;
import eu.europa.esig.dss.signature.AbstractSignatureService;
import eu.europa.esig.dss.signature.CounterSignatureService;
import eu.europa.esig.dss.signature.MultipleDocumentsSignatureService;
import eu.europa.esig.dss.signature.SignatureExtension;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.SignatureProfile;
import eu.europa.esig.dss.xades.XAdESProfileParameters;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.evidencerecord.EmbeddedEvidenceRecordBuilder;
import eu.europa.esig.dss.xades.evidencerecord.XAdESEvidenceRecordIncorporationParameters;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.signature.AllDataObjectsTimeStampBuilder;
import eu.europa.esig.dss.xades.signature.CounterSignatureBuilder;
import eu.europa.esig.dss.xades.signature.SignaturePolicyStoreBuilder;
import eu.europa.esig.dss.xades.signature.XAdESCounterSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESLevelA;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineB;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLT;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineLTA;
import eu.europa.esig.dss.xades.signature.XAdESLevelBaselineT;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import eu.europa.esig.dss.xades.signature.XAdESLevelX;
import eu.europa.esig.dss.xades.signature.XAdESLevelXL;
import eu.europa.esig.dss.xml.utils.SantuarioInitializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAdESService
extends AbstractSignatureService<XAdESSignatureParameters, XAdESTimestampParameters>
implements MultipleDocumentsSignatureService<XAdESSignatureParameters, XAdESTimestampParameters>,
CounterSignatureService<XAdESCounterSignatureParameters>,
EvidenceRecordIncorporationService<XAdESEvidenceRecordIncorporationParameters> {
    private static final long serialVersionUID = -391276429698752703L;
    private static final Logger LOG;

    public XAdESService(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
        LOG.debug("+ XAdESService created");
    }

    public TimestampToken getContentTimestamp(DSSDocument toSignDocument, XAdESSignatureParameters parameters) {
        return this.getContentTimestamp(Collections.singletonList(toSignDocument), parameters);
    }

    public TimestampToken getContentTimestamp(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters) {
        Objects.requireNonNull(this.tspSource, "A TSPSource is required !");
        AllDataObjectsTimeStampBuilder builder = new AllDataObjectsTimeStampBuilder(this.tspSource, parameters);
        return builder.build(toSignDocuments);
    }

    public ToBeSigned getDataToSign(DSSDocument toSignDocument, XAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocument, "toSignDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertSigningCertificateValid(parameters);
        XAdESLevelBaselineB levelBaselineB = new XAdESLevelBaselineB(this.certificateVerifier);
        byte[] dataToSign = levelBaselineB.getDataToSign(toSignDocument, parameters);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Data to sign: ");
            LOG.trace(new String(dataToSign));
        }
        parameters.getContext().setProfile(levelBaselineB);
        return new ToBeSigned(dataToSign);
    }

    public ToBeSigned getDataToSign(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.assertMultiDocumentsAllowed(parameters);
        this.assertDocumentsValid(toSignDocuments);
        parameters.getContext().setDetachedContents(toSignDocuments);
        return this.getDataToSign(toSignDocuments.get(0), parameters);
    }

    public DSSDocument signDocument(DSSDocument toSignDocument, XAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocument, "toSignDocument is not defined!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel must be defined!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertSigningCertificateValid(parameters);
        parameters.getContext().setOperationKind(SigningOperation.SIGN);
        XAdESProfileParameters context = parameters.getContext();
        SignatureProfile profile = context.getProfile() != null ? context.getProfile() : new XAdESLevelBaselineB(this.certificateVerifier);
        DSSDocument result = profile.signDocument(toSignDocument, parameters, signatureValue.getValue());
        SignatureExtension<XAdESSignatureParameters> extension = this.getExtensionProfile(parameters);
        if (extension != null) {
            if (SignaturePackaging.DETACHED.equals((Object)parameters.getSignaturePackaging()) && Utils.isCollectionEmpty((Collection)parameters.getDetachedContents())) {
                ArrayList<DSSDocument> detachedContents = new ArrayList<DSSDocument>();
                detachedContents.add(toSignDocument);
                parameters.getContext().setDetachedContents(detachedContents);
            }
            result = extension.extendSignatures(result, (AbstractSignatureParameters)parameters);
        }
        parameters.reinit();
        result.setName(this.getFinalFileName(toSignDocument, SigningOperation.SIGN, parameters.getSignatureLevel()));
        return result;
    }

    public DSSDocument signDocument(List<DSSDocument> toSignDocuments, XAdESSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(toSignDocuments, "toSignDocuments cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel must be defined!");
        Objects.requireNonNull(signatureValue, "SignatureValue cannot be null!");
        this.assertMultiDocumentsAllowed(parameters);
        this.assertDocumentsValid(toSignDocuments);
        parameters.getContext().setDetachedContents(toSignDocuments);
        return this.signDocument(toSignDocuments.get(0), parameters, signatureValue);
    }

    public DSSDocument extendDocument(DSSDocument toExtendDocument, XAdESSignatureParameters parameters) {
        Objects.requireNonNull(toExtendDocument, "toExtendDocument cannot be null!");
        Objects.requireNonNull(parameters, "Cannot extend the signature. SignatureParameters are not defined!");
        Objects.requireNonNull(parameters.getSignatureLevel(), "SignatureLevel must be defined!");
        parameters.getContext().setOperationKind(SigningOperation.EXTEND);
        SignatureExtension<XAdESSignatureParameters> extension = this.getExtensionProfile(parameters);
        if (extension != null) {
            DSSDocument dssDocument = extension.extendSignatures(toExtendDocument, (AbstractSignatureParameters)parameters);
            dssDocument.setName(this.getFinalFileName(toExtendDocument, SigningOperation.EXTEND, parameters.getSignatureLevel()));
            return dssDocument;
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", parameters.getSignatureLevel()));
    }

    public DSSDocument timestamp(List<DSSDocument> toTimestampDocuments, XAdESTimestampParameters parameters) {
        throw new UnsupportedOperationException("Unsupported operation for this file format");
    }

    private SignatureExtension<XAdESSignatureParameters> getExtensionProfile(XAdESSignatureParameters parameters) {
        switch (parameters.getSignatureLevel()) {
            case XAdES_BASELINE_B: {
                return null;
            }
            case XAdES_BASELINE_T: {
                XAdESLevelBaselineT extensionT = new XAdESLevelBaselineT(this.certificateVerifier);
                extensionT.setTspSource(this.tspSource);
                return extensionT;
            }
            case XAdES_C: {
                XAdESLevelC extensionC = new XAdESLevelC(this.certificateVerifier);
                extensionC.setTspSource(this.tspSource);
                return extensionC;
            }
            case XAdES_X: {
                XAdESLevelX extensionX = new XAdESLevelX(this.certificateVerifier);
                extensionX.setTspSource(this.tspSource);
                return extensionX;
            }
            case XAdES_XL: {
                XAdESLevelXL extensionXL = new XAdESLevelXL(this.certificateVerifier);
                extensionXL.setTspSource(this.tspSource);
                return extensionXL;
            }
            case XAdES_A: {
                XAdESLevelA extensionA = new XAdESLevelA(this.certificateVerifier);
                extensionA.setTspSource(this.tspSource);
                return extensionA;
            }
            case XAdES_BASELINE_LT: {
                XAdESLevelBaselineLT extensionLT = new XAdESLevelBaselineLT(this.certificateVerifier);
                extensionLT.setTspSource(this.tspSource);
                return extensionLT;
            }
            case XAdES_BASELINE_LTA: {
                XAdESLevelBaselineLTA extensionLTA = new XAdESLevelBaselineLTA(this.certificateVerifier);
                extensionLTA.setTspSource(this.tspSource);
                return extensionLTA;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported signature format '%s' for extension.", parameters.getSignatureLevel()));
    }

    private void assertMultiDocumentsAllowed(XAdESSignatureParameters parameters) {
        Objects.requireNonNull(parameters.getSignaturePackaging(), "SignaturePackaging shall be defined!");
        SignaturePackaging signaturePackaging = parameters.getSignaturePackaging();
        if (signaturePackaging == null || SignaturePackaging.ENVELOPED == signaturePackaging) {
            throw new IllegalArgumentException("Not supported operation (only DETACHED or ENVELOPING are allowed)");
        }
    }

    private void assertDocumentsValid(List<DSSDocument> toSignDocuments) {
        ArrayList<String> documentNames = new ArrayList<String>();
        for (DSSDocument document : toSignDocuments) {
            if (toSignDocuments.size() > 1 && Utils.isStringBlank((String)document.getName())) {
                throw new IllegalArgumentException("All documents in the list to be signed shall have names!");
            }
            if (documentNames.contains(document.getName())) {
                throw new IllegalArgumentException(String.format("The documents to be signed shall have different names! The name '%s' appears multiple times.", document.getName()));
            }
            documentNames.add(document.getName());
        }
    }

    public DSSDocument addSignaturePolicyStore(DSSDocument document, SignaturePolicyStore signaturePolicyStore) {
        Objects.requireNonNull(document, "The document cannot be null");
        Objects.requireNonNull(signaturePolicyStore, "The signaturePolicyStore cannot be null");
        SignaturePolicyStoreBuilder builder = new SignaturePolicyStoreBuilder();
        DSSDocument signatureWithPolicyStore = builder.addSignaturePolicyStore(document, signaturePolicyStore);
        signatureWithPolicyStore.setName(this.getFinalFileName(document, SigningOperation.ADD_SIG_POLICY_STORE));
        signatureWithPolicyStore.setMimeType(document.getMimeType());
        return signatureWithPolicyStore;
    }

    public ToBeSigned getDataToBeCounterSigned(DSSDocument signatureDocument, XAdESCounterSignatureParameters parameters) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        this.verifyAndSetCounterSignatureParameters(parameters);
        CounterSignatureBuilder counterSignatureBuilder = new CounterSignatureBuilder(this.certificateVerifier);
        DSSDocument signatureValue = counterSignatureBuilder.getCanonicalizedSignatureValue(signatureDocument, parameters);
        DSSReference counterSignatureReference = counterSignatureBuilder.buildCounterSignatureDSSReference(signatureDocument, parameters);
        parameters.setReferences(Collections.singletonList(counterSignatureReference));
        return this.getDataToSign(signatureValue, (XAdESSignatureParameters)parameters);
    }

    public DSSDocument counterSignSignature(DSSDocument signatureDocument, XAdESCounterSignatureParameters parameters, SignatureValue signatureValue) {
        Objects.requireNonNull(signatureDocument, "signatureDocument cannot be null!");
        Objects.requireNonNull(parameters, "SignatureParameters cannot be null!");
        Objects.requireNonNull(signatureValue, "signatureValue cannot be null!");
        this.verifyAndSetCounterSignatureParameters(parameters);
        CounterSignatureBuilder counterSignatureBuilder = new CounterSignatureBuilder(this.certificateVerifier);
        DSSDocument signatureValueToSign = counterSignatureBuilder.getCanonicalizedSignatureValue(signatureDocument, parameters);
        parameters.getContext().setDetachedContents(Collections.singletonList(signatureValueToSign));
        DSSReference counterSignatureReference = counterSignatureBuilder.buildCounterSignatureDSSReference(signatureDocument, parameters);
        parameters.setReferences(Collections.singletonList(counterSignatureReference));
        DSSDocument counterSignature = this.signDocument(signatureValueToSign, (XAdESSignatureParameters)parameters, signatureValue);
        DSSDocument counterSigned = counterSignatureBuilder.buildEmbeddedCounterSignature(signatureDocument, counterSignature, parameters);
        parameters.reinit();
        counterSigned.setName(this.getFinalFileName(signatureDocument, SigningOperation.COUNTER_SIGN, parameters.getSignatureLevel()));
        counterSigned.setMimeType(signatureDocument.getMimeType());
        return counterSigned;
    }

    public DSSDocument addSignatureEvidenceRecord(DSSDocument signatureDocument, DSSDocument evidenceRecordDocument, XAdESEvidenceRecordIncorporationParameters parameters) {
        Objects.requireNonNull(signatureDocument, "The signature document cannot be null");
        Objects.requireNonNull(evidenceRecordDocument, "The evidence record document cannot be null");
        EmbeddedEvidenceRecordBuilder builder = new EmbeddedEvidenceRecordBuilder(this.certificateVerifier);
        DSSDocument signatureWithEvidenceRecord = builder.addEvidenceRecord(signatureDocument, evidenceRecordDocument, parameters);
        signatureWithEvidenceRecord.setName(this.getFinalFileName(signatureDocument, SigningOperation.ADD_EVIDENCE_RECORD));
        signatureWithEvidenceRecord.setMimeType(signatureDocument.getMimeType());
        return signatureWithEvidenceRecord;
    }

    private void verifyAndSetCounterSignatureParameters(XAdESCounterSignatureParameters parameters) {
        if (parameters.getSignaturePackaging() == null) {
            parameters.setSignaturePackaging(SignaturePackaging.DETACHED);
        } else if (!SignaturePackaging.DETACHED.equals((Object)parameters.getSignaturePackaging())) {
            throw new IllegalArgumentException(String.format("The SignaturePackaging '%s' is not supported by XAdES Counter Signature!", parameters.getSignaturePackaging()));
        }
    }

    static {
        SantuarioInitializer.init();
        DSSXMLUtils.registerXAdESNamespaces();
        LOG = LoggerFactory.getLogger(XAdESService.class);
    }
}

