/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.CertificateQualifiedStatus;
import eu.europa.esig.dss.enumerations.CertificateType;
import eu.europa.esig.dss.enumerations.QSCDStatus;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationMatrix;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculator;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CaQcCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQCTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateIssuedByConsistentByQSCDTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.CertificateTypeCoverageCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.GrantedStatusCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsAbleToSelectOneTrustService;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.IsNoQualificationConflictDetectedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.MRACertificateEquivalenceApplied;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QSCDCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.QualifiedCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.RelatedToMraEnactedTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ServiceConsistencyCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustServiceAtTimeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustServicesByCertificateTypeCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.TrustedCertificateMatchTrustServiceCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.ValidCAQCCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qscd.QSCDStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.qualified.QualificationStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategy;
import eu.europa.esig.dss.validation.process.qualification.certificate.checks.type.TypeStrategyFactory;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertQualificationAtTimeBlock
extends Chain<XmlValidationCertificateQualification> {
    private final ValidationTime validationTime;
    private final Date date;
    private final CertificateWrapper signingCertificate;
    private final List<TrustedServiceWrapper> acceptableServices;
    private CertificateQualification certificateQualification = CertificateQualification.NA;
    private List<TrustedServiceWrapper> filteredServices;

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> acceptableServices) {
        this(i18nProvider, validationTime, null, signingCertificate, acceptableServices);
    }

    public CertQualificationAtTimeBlock(I18nProvider i18nProvider, ValidationTime validationTime, Date date, CertificateWrapper signingCertificate, List<TrustedServiceWrapper> acceptableServices) {
        super(i18nProvider, new XmlValidationCertificateQualification());
        ((XmlValidationCertificateQualification)this.result).setId(signingCertificate.getId());
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.acceptableServices = new ArrayList<TrustedServiceWrapper>(acceptableServices);
        switch (validationTime) {
            case CERTIFICATE_ISSUANCE_TIME: {
                this.date = signingCertificate.getNotBefore();
                break;
            }
            case VALIDATION_TIME: 
            case BEST_SIGNATURE_TIME: {
                this.date = date;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualification time : " + validationTime);
            }
        }
    }

    @Override
    protected String buildChainTitle() {
        MessageTag message = MessageTag.CERT_QUALIFICATION_AT_TIME;
        MessageTag param = ValidationProcessUtils.getValidationTimeMessageTag(this.validationTime);
        return this.i18nProvider.getMessage(message, new Object[]{param});
    }

    @Override
    protected void initChain() {
        TrustedServiceWrapper selectedTrustService;
        this.filteredServices = new ArrayList<TrustedServiceWrapper>(this.acceptableServices);
        ChainItem<XmlValidationCertificateQualification> item = null;
        TrustedServiceFilter filterByDate = TrustedServicesFilterFactory.createFilterByDate(this.date);
        this.filteredServices = filterByDate.filter(this.filteredServices);
        if (this.isMRAEnactedForTrustedList(this.filteredServices)) {
            TrustedServiceFilter filterByMRAEnacted = TrustedServicesFilterFactory.createMRAEnactedFilter();
            this.filteredServices = filterByMRAEnacted.filter(this.filteredServices);
            filterByMRAEnacted = TrustedServicesFilterFactory.createFilterByMRAEquivalenceStartingDate(this.date);
            this.filteredServices = filterByMRAEnacted.filter(this.filteredServices);
            this.firstItem = this.hasMraEnactedTrustService(this.filteredServices);
            item = this.firstItem;
            item = item.setNextItem(this.mraCertificateEquivalenceApplied());
        } else {
            item = this.firstItem = this.hasTrustServiceAtTime(this.filteredServices);
        }
        item = item.setNextItem(this.hasCaQc(this.filteredServices));
        TrustedServiceFilter filterByCaQc = TrustedServicesFilterFactory.createFilterByCaQc();
        List<TrustedServiceWrapper> caqcServices = filterByCaQc.filter(this.filteredServices);
        if (Utils.isCollectionNotEmpty(caqcServices)) {
            this.filteredServices = caqcServices;
        }
        TrustedServiceFilter filterByCertificateType = TrustedServicesFilterFactory.createFilterByCertificateType(this.signingCertificate);
        this.filteredServices = filterByCertificateType.filter(this.filteredServices);
        item = item.setNextItem(this.hasTrustServiceWithType(this.filteredServices));
        for (TrustedServiceWrapper trustedServiceWrapper : this.filteredServices) {
            item = item.setNextItem(this.serviceConsistency(trustedServiceWrapper));
        }
        if (this.filteredServices.size() > 1) {
            HashSet<CertificateQualification> results = new HashSet<CertificateQualification>();
            for (TrustedServiceWrapper trustedService : this.filteredServices) {
                CertificateQualificationCalculator calculator = new CertificateQualificationCalculator(this.signingCertificate, trustedService);
                results.add(calculator.getQualification());
            }
            item = item.setNextItem(this.isNoConflictDetected(results));
            if (results.size() > 1) {
                this.certificateQualification = CertificateQualification.NA;
                return;
            }
        }
        TrustedServiceFilter filterConsistentByStatus = TrustedServicesFilterFactory.createConsistentServiceByStatusFilter();
        this.filteredServices = filterConsistentByStatus.filter(this.filteredServices);
        item = item.setNextItem(this.hasGrantedStatus(this.filteredServices));
        TrustedServiceFilter trustedServiceFilter = TrustedServicesFilterFactory.createFilterByGranted();
        List<TrustedServiceWrapper> grantedServices = trustedServiceFilter.filter(this.filteredServices);
        if (Utils.isCollectionNotEmpty(grantedServices)) {
            this.filteredServices = grantedServices;
        }
        if (Utils.collectionSize(this.filteredServices) > 1) {
            TrustedServiceFilter filterUnique = TrustedServicesFilterFactory.createUniqueServiceFilter(this.signingCertificate);
            this.filteredServices = filterUnique.filter(this.filteredServices);
            item = item.setNextItem(this.isAbleToSelectOneTrustService(this.filteredServices));
        }
        TrustedServiceWrapper trustedServiceWrapper = selectedTrustService = !this.filteredServices.isEmpty() ? this.filteredServices.get(0) : null;
        if (selectedTrustService != null) {
            item = item.setNextItem(this.isTrustedCertificateMatchTrustService(selectedTrustService));
        }
        if (!caqcServices.contains(selectedTrustService) || !grantedServices.contains(selectedTrustService)) {
            this.filteredServices = Collections.emptyList();
            selectedTrustService = null;
        }
        item = item.setNextItem(this.isValidCAQC(selectedTrustService));
        TrustedServiceFilter filterConsistentByQC = TrustedServicesFilterFactory.createConsistentServiceByQCFilter();
        List<TrustedServiceWrapper> trustServicesByQC = filterConsistentByQC.filter(this.filteredServices);
        item = item.setNextItem(this.hasConsistentByQCTrustService(trustServicesByQC));
        selectedTrustService = !trustServicesByQC.isEmpty() ? trustServicesByQC.get(0) : null;
        QualificationStrategy qcStrategy = QualificationStrategyFactory.createQualificationFromCertAndTL(this.signingCertificate, selectedTrustService);
        CertificateQualifiedStatus qualifiedStatus = qcStrategy.getQualifiedStatus();
        item = item.setNextItem(this.isQualified(qualifiedStatus));
        TrustedServiceFilter filterConsistentByType = TrustedServicesFilterFactory.createConsistentServiceByCertificateTypeFilter();
        List<TrustedServiceWrapper> trustServicesByType = filterConsistentByType.filter(this.filteredServices);
        item = item.setNextItem(this.hasCertificateTypeCoverage(trustServicesByType));
        selectedTrustService = !trustServicesByType.isEmpty() ? trustServicesByType.get(0) : null;
        TypeStrategy typeStrategy = TypeStrategyFactory.createTypeFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        CertificateType type = typeStrategy.getType();
        item = item.setNextItem(this.certificateType(type));
        TrustedServiceFilter filterConsistentByQSCD = TrustedServicesFilterFactory.createConsistentServiceByQSCDFilter();
        List<TrustedServiceWrapper> trustServicesByQSCD = filterConsistentByQSCD.filter(this.filteredServices);
        item = item.setNextItem(this.hasConsistentByQSCDTrustService(trustServicesByQSCD));
        selectedTrustService = !trustServicesByQSCD.isEmpty() ? trustServicesByQSCD.get(0) : null;
        QSCDStrategy qscdStrategy = QSCDStrategyFactory.createQSCDFromCertAndTL(this.signingCertificate, selectedTrustService, qualifiedStatus);
        QSCDStatus qscdStatus = qscdStrategy.getQSCDStatus();
        item = item.setNextItem(this.isQscd(qscdStatus));
        this.certificateQualification = CertQualificationMatrix.getCertQualification(qualifiedStatus, type, qscdStatus);
    }

    public List<TrustedServiceWrapper> getFilteredServices() {
        if (this.filteredServices == null) {
            throw new IllegalStateException("execute() method shall be called first!");
        }
        return this.filteredServices;
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlValidationCertificateQualification)this.result).setCertificateQualification(this.certificateQualification);
        ((XmlValidationCertificateQualification)this.result).setValidationTime(this.validationTime);
        ((XmlValidationCertificateQualification)this.result).setDateTime(this.date);
    }

    private ChainItem<XmlValidationCertificateQualification> hasMraEnactedTrustService(List<TrustedServiceWrapper> trustServices) {
        return new RelatedToMraEnactedTrustServiceCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> mraCertificateEquivalenceApplied() {
        return new MRACertificateEquivalenceApplied<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, this.signingCertificate, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCaQc(List<TrustedServiceWrapper> trustServices) {
        return new CaQcCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasTrustServiceAtTime(List<TrustedServiceWrapper> trustServices) {
        return new TrustServiceAtTimeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.validationTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasTrustServiceWithType(List<TrustedServiceWrapper> trustServices) {
        return new TrustServicesByCertificateTypeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isNoConflictDetected(Set<CertificateQualification> certificateQualificationsAtTime) {
        return new IsNoQualificationConflictDetectedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, certificateQualificationsAtTime, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasGrantedStatus(List<TrustedServiceWrapper> trustServices) {
        return new GrantedStatusCheck<XmlValidationCertificateQualification>(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasCertificateTypeCoverage(List<TrustedServiceWrapper> trustServices) {
        return new CertificateTypeCoverageCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQCTrustService(List<TrustedServiceWrapper> trustServices) {
        return new CertificateIssuedByConsistentByQCTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> hasConsistentByQSCDTrustService(List<TrustedServiceWrapper> trustServices) {
        return new CertificateIssuedByConsistentByQSCDTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isAbleToSelectOneTrustService(List<TrustedServiceWrapper> trustServices) {
        return new IsAbleToSelectOneTrustService(this.i18nProvider, (XmlValidationCertificateQualification)this.result, trustServices, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> serviceConsistency(TrustedServiceWrapper selectedTrustService) {
        return new ServiceConsistencyCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isTrustedCertificateMatchTrustService(TrustedServiceWrapper selectedTrustService) {
        return new TrustedCertificateMatchTrustServiceCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isValidCAQC(TrustedServiceWrapper selectedTrustService) {
        return new ValidCAQCCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, selectedTrustService, this.getFailLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQualified(CertificateQualifiedStatus qualifiedStatus) {
        return new QualifiedCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qualifiedStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> certificateType(CertificateType type) {
        return new CertificateTypeCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, type, this.validationTime, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlValidationCertificateQualification> isQscd(QSCDStatus qscdStatus) {
        return new QSCDCheck(this.i18nProvider, (XmlValidationCertificateQualification)this.result, qscdStatus, this.validationTime, this.getWarnLevelConstraint());
    }

    private boolean isMRAEnactedForTrustedList(List<TrustedServiceWrapper> trustedServices) {
        for (TrustedServiceWrapper trustedService : trustedServices) {
            if (!Utils.isTrue((Boolean)trustedService.getTrustedList().isMra())) continue;
            return true;
        }
        return false;
    }
}

