/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlTLAnalysis;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.AcceptableBuildingBlockConclusionCheck;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertQualificationAtTimeBlock;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableListOfTrustedListsCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListCheck;
import eu.europa.esig.dss.validation.process.qualification.signature.checks.AcceptableTrustedListPresenceCheck;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServicesFilterFactory;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CertificateQualificationBlock
extends Chain<XmlCertificate> {
    private final XmlConclusion buildingBlocksConclusion;
    private final Date validationTime;
    private final CertificateWrapper signingCertificate;
    private final List<XmlTLAnalysis> tlAnalysis;

    public CertificateQualificationBlock(I18nProvider i18nProvider, XmlConclusion buildingBlocksConclusion, Date validationTime, CertificateWrapper signingCertificate, List<XmlTLAnalysis> tlAnalysis) {
        super(i18nProvider, new XmlCertificate());
        Objects.requireNonNull(validationTime, "The validationTime shall be provided!");
        Objects.requireNonNull(signingCertificate, "The signingCertificate shall be provided!");
        ((XmlCertificate)this.result).setId(signingCertificate.getId());
        this.buildingBlocksConclusion = buildingBlocksConclusion;
        this.validationTime = validationTime;
        this.signingCertificate = signingCertificate;
        this.tlAnalysis = tlAnalysis;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.CERT_QUALIFICATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlCertificate> item = this.firstItem = this.isAcceptableBuildingBlockConclusion(this.buildingBlocksConclusion);
        if (this.signingCertificate.isTrustedListReached()) {
            List originalTSPs = this.signingCertificate.getTrustedServices();
            Set listOfTrustedListUrls = originalTSPs.stream().filter(t -> t.getListOfTrustedLists() != null).map(t -> t.getListOfTrustedLists().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableLOTLUrls = new HashSet<String>();
            for (String lotlURL : listOfTrustedListUrls) {
                XmlTLAnalysis lotlAnalysis = this.getTlAnalysis(lotlURL);
                if (lotlAnalysis == null) continue;
                AcceptableListOfTrustedListsCheck<XmlCertificate> acceptableLOTL = this.isAcceptableLOTL(lotlAnalysis);
                item = item.setNextItem(acceptableLOTL);
                if (!acceptableLOTL.process()) continue;
                acceptableLOTLUrls.add(lotlURL);
            }
            Set trustedListUrls = originalTSPs.stream().filter(t -> t.getTrustedList() != null && (t.getListOfTrustedLists() == null || acceptableLOTLUrls.contains(t.getListOfTrustedLists().getUrl()))).map(t -> t.getTrustedList().getUrl()).collect(Collectors.toSet());
            HashSet<String> acceptableTLUrls = new HashSet<String>();
            if (Utils.isCollectionNotEmpty(trustedListUrls)) {
                for (String tlURL : trustedListUrls) {
                    XmlTLAnalysis currentTL = this.getTlAnalysis(tlURL);
                    if (currentTL == null) continue;
                    AcceptableTrustedListCheck<XmlCertificate> acceptableTL = this.isAcceptableTL(currentTL);
                    item = item.setNextItem(acceptableTL);
                    if (!acceptableTL.process()) continue;
                    acceptableTLUrls.add(tlURL);
                }
            }
            item = item.setNextItem(this.isAcceptableTLPresent(acceptableTLUrls));
            if (Utils.isCollectionNotEmpty(acceptableTLUrls)) {
                TrustedServiceFilter filter = TrustedServicesFilterFactory.createFilterByUrls(acceptableTLUrls);
                List<TrustedServiceWrapper> acceptableServices = filter.filter(originalTSPs);
                CertQualificationAtTimeBlock certQualAtIssuanceBlock = new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.CERTIFICATE_ISSUANCE_TIME, this.signingCertificate, acceptableServices);
                ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtIssuanceBlock.execute());
                CertQualificationAtTimeBlock certQualAtSigningTimeBlock = new CertQualificationAtTimeBlock(this.i18nProvider, ValidationTime.VALIDATION_TIME, this.validationTime, this.signingCertificate, acceptableServices);
                ((XmlCertificate)this.result).getValidationCertificateQualification().add((XmlValidationCertificateQualification)certQualAtSigningTimeBlock.execute());
            }
        }
    }

    private XmlTLAnalysis getTlAnalysis(String url) {
        if (Utils.isCollectionNotEmpty(this.tlAnalysis)) {
            for (XmlTLAnalysis xmlTLAnalysis : this.tlAnalysis) {
                if (!Utils.areStringsEqual((String)url, (String)xmlTLAnalysis.getURL())) continue;
                return xmlTLAnalysis;
            }
        }
        return null;
    }

    @Override
    protected void addAdditionalInfo() {
        this.setIndication();
    }

    private void setIndication() {
        XmlConclusion conclusion = ((XmlCertificate)this.result).getConclusion();
        if (conclusion != null) {
            if (Utils.isCollectionNotEmpty((Collection)conclusion.getErrors())) {
                conclusion.setIndication(Indication.FAILED);
            } else if (Utils.isCollectionNotEmpty((Collection)conclusion.getWarnings())) {
                conclusion.setIndication(Indication.INDETERMINATE);
            } else {
                conclusion.setIndication(Indication.PASSED);
            }
        }
    }

    private AcceptableListOfTrustedListsCheck<XmlCertificate> isAcceptableLOTL(XmlTLAnalysis xmlLOTLAnalysis) {
        return new AcceptableListOfTrustedListsCheck<XmlCertificate>(this.i18nProvider, (XmlCertificate)this.result, xmlLOTLAnalysis, this.getWarnLevelConstraint());
    }

    private AcceptableTrustedListCheck<XmlCertificate> isAcceptableTL(XmlTLAnalysis xmlTLAnalysis) {
        return new AcceptableTrustedListCheck<XmlCertificate>(this.i18nProvider, (XmlCertificate)this.result, xmlTLAnalysis, this.getWarnLevelConstraint());
    }

    private ChainItem<XmlCertificate> isAcceptableTLPresent(Set<String> acceptableUrls) {
        return new AcceptableTrustedListPresenceCheck<XmlCertificate>(this.i18nProvider, (XmlCertificate)this.result, acceptableUrls, this.getFailLevelConstraint());
    }

    private ChainItem<XmlCertificate> isAcceptableBuildingBlockConclusion(XmlConclusion buildingBlocksConclusion) {
        return new AcceptableBuildingBlockConclusionCheck(this.i18nProvider, (XmlCertificate)this.result, buildingBlocksConclusion, this.getWarnLevelConstraint());
    }
}

