/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.signature.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class AdESAcceptableCheck
extends ChainItem<XmlValidationSignatureQualification> {
    private final XmlConclusion etsi319102Conclusion;
    private MessageTag error;

    public AdESAcceptableCheck(I18nProvider i18nProvider, XmlValidationSignatureQualification result, XmlConclusion etsi319102Conclusion, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.etsi319102Conclusion = etsi319102Conclusion;
    }

    @Override
    protected boolean process() {
        boolean valid = this.isValidConclusion(this.etsi319102Conclusion);
        if (!valid) {
            if (this.isIndeterminateConclusion(this.etsi319102Conclusion)) {
                this.error = MessageTag.QUAL_IS_ADES_IND;
            } else if (this.isInvalidConclusion(this.etsi319102Conclusion)) {
                this.error = MessageTag.QUAL_IS_ADES_INV;
            }
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.QUAL_IS_ADES;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return this.error;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.etsi319102Conclusion.getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.etsi319102Conclusion.getSubIndication();
    }
}

