/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.Level;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.policy.jaxb.Model;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.CheckSubXCVResult;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.ProspectiveCertificateChainCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustedServiceStatusCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.checks.TrustedServiceTypeIdentifierCheck;
import eu.europa.esig.dss.validation.process.bbb.xcv.sub.SubX509CertificateValidation;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class X509CertificateValidation
extends Chain<XmlXCV> {
    private final CertificateWrapper currentCertificate;
    private final Date validationDate;
    private final Date usageTime;
    private final Context context;
    private final ValidationPolicy validationPolicy;

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date validationDate, Context context, ValidationPolicy validationPolicy) {
        this(i18nProvider, currentCertificate, validationDate, validationDate, context, validationPolicy);
    }

    public X509CertificateValidation(I18nProvider i18nProvider, CertificateWrapper currentCertificate, Date validationDate, Date usageTime, Context context, ValidationPolicy validationPolicy) {
        super(i18nProvider, new XmlXCV());
        this.currentCertificate = currentCertificate;
        this.validationDate = validationDate;
        this.usageTime = usageTime;
        this.context = context;
        this.validationPolicy = validationPolicy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.X509_CERTIFICATE_VALIDATION;
    }

    @Override
    protected void initChain() {
        ChainItem<XmlXCV> item = this.firstItem = this.prospectiveCertificateChain();
        if (this.currentCertificate.isTrusted() || this.currentCertificate.isTrustedChain() || !this.prospectiveCertificateChainCheckEnforced()) {
            item = item.setNextItem(this.trustedServiceWithExpectedTypeIdentifier());
            item = item.setNextItem(this.trustedServiceWithExpectedStatus());
            SubX509CertificateValidation certificateValidation = new SubX509CertificateValidation(this.i18nProvider, this.currentCertificate, this.validationDate, this.context, SubContext.SIGNING_CERT, this.validationPolicy);
            XmlSubXCV subXCV = (XmlSubXCV)certificateValidation.execute();
            ((XmlXCV)this.result).getSubXCV().add(subXCV);
            boolean trustAnchorReached = this.currentCertificate.isTrusted();
            Model model = this.validationPolicy.getValidationModel();
            Date lastDate = Model.SHELL.equals((Object)model) ? this.validationDate : this.currentCertificate.getNotBefore();
            List certificateChainList = this.currentCertificate.getCertificateChain();
            if (Utils.isCollectionNotEmpty((Collection)certificateChainList)) {
                for (CertificateWrapper certificate : certificateChainList) {
                    if (trustAnchorReached) continue;
                    certificateValidation = new SubX509CertificateValidation(this.i18nProvider, certificate, lastDate, this.context, SubContext.CA_CERTIFICATE, this.validationPolicy);
                    subXCV = (XmlSubXCV)certificateValidation.execute();
                    ((XmlXCV)this.result).getSubXCV().add(subXCV);
                    trustAnchorReached = certificate.isTrusted();
                    lastDate = Model.HYBRID.equals((Object)model) ? lastDate : (Model.SHELL.equals((Object)model) ? this.validationDate : certificate.getNotBefore());
                }
            }
            for (XmlSubXCV subXCVResult : ((XmlXCV)this.result).getSubXCV()) {
                item = item.setNextItem(this.checkSubXCVResult(subXCVResult));
            }
        }
    }

    private ChainItem<XmlXCV> prospectiveCertificateChain() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return new ProspectiveCertificateChainCheck<XmlXCV>(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustedServiceWithExpectedTypeIdentifier() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustedServiceTypeIdentifierConstraint(this.context);
        return new TrustedServiceTypeIdentifierCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> trustedServiceWithExpectedStatus() {
        MultiValuesConstraint constraint = this.validationPolicy.getTrustedServiceStatusConstraint(this.context);
        return new TrustedServiceStatusCheck(this.i18nProvider, (XmlXCV)this.result, this.currentCertificate, this.usageTime, this.context, constraint);
    }

    private ChainItem<XmlXCV> checkSubXCVResult(XmlSubXCV subXCVResult) {
        return new CheckSubXCVResult(this.i18nProvider, (XmlXCV)this.result, subXCVResult, this.getFailLevelConstraint());
    }

    private boolean prospectiveCertificateChainCheckEnforced() {
        LevelConstraint constraint = this.validationPolicy.getProspectiveCertificateChainConstraint(this.context);
        return constraint != null && Level.FAIL == constraint.getLevel();
    }

    @Override
    protected void collectAdditionalMessages(XmlConclusion conclusion) {
        for (XmlSubXCV subXCV : ((XmlXCV)this.result).getSubXCV()) {
            this.collectAllMessages(conclusion, subXCV.getConclusion());
        }
    }
}

