/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.MultiValuesConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.bbb.AbstractMultiValuesCheckItem;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TrustedServiceStatusCheck
extends AbstractMultiValuesCheckItem<XmlXCV> {
    private final CertificateWrapper certificate;
    private final Date usageTime;
    private final Context context;
    private String serviceStatusStr;

    public TrustedServiceStatusCheck(I18nProvider i18nProvider, XmlXCV result, CertificateWrapper certificate, Date usageTime, Context context, MultiValuesConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.certificate = certificate;
        this.usageTime = usageTime;
        this.context = context;
    }

    @Override
    protected boolean process() {
        if (this.certificate.isCertificateChainFromTrustedStore()) {
            return true;
        }
        List trustedServices = this.certificate.getTrustedServices();
        if (Utils.isCollectionNotEmpty((Collection)trustedServices)) {
            for (TrustedServiceWrapper trustedService : trustedServices) {
                this.serviceStatusStr = Utils.trim((String)trustedService.getStatus());
                Date statusStartDate = trustedService.getStartDate();
                if (!this.processValueCheck(this.serviceStatusStr) || statusStartDate == null) continue;
                Date statusEndDate = trustedService.getEndDate();
                if (this.usageTime.compareTo(statusStartDate) < 0 || statusEndDate != null && !this.usageTime.before(statusEndDate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String buildAdditionalInfo() {
        if (Utils.isStringNotEmpty((String)this.serviceStatusStr)) {
            return this.i18nProvider.getMessage(MessageTag.TRUSTED_SERVICE_STATUS, new Object[]{this.serviceStatusStr});
        }
        return null;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.XCV_TSL_ESP;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.context) {
            case SIGNATURE: 
            case COUNTER_SIGNATURE: {
                return MessageTag.XCV_TSL_ESP_SIG_ANS;
            }
            case TIMESTAMP: {
                return MessageTag.XCV_TSL_ESP_TSP_ANS;
            }
            case REVOCATION: {
                return MessageTag.XCV_TSL_ESP_REV_ANS;
            }
        }
        return MessageTag.XCV_TSL_ESP_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.NO_CERTIFICATE_CHAIN_FOUND;
    }
}

