/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.consistency;

import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.AdditionalServiceInformation;
import eu.europa.esig.dss.enumerations.ServiceQualification;
import eu.europa.esig.dss.validation.process.qualification.EIDASUtils;
import eu.europa.esig.dss.validation.process.qualification.trust.consistency.TrustedServiceCondition;
import java.util.Date;
import java.util.List;

public class TrustedServiceQualifierAndAdditionalServiceInfoPreEIDASConsistency
implements TrustedServiceCondition {
    @Override
    public boolean isConsistent(TrustedServiceWrapper trustedService) {
        Date startDate = trustedService.getStartDate();
        if (EIDASUtils.isPreEIDAS(startDate)) {
            List asis = trustedService.getAdditionalServiceInfos();
            if (AdditionalServiceInformation.isForeSealsOnly((List)asis) || AdditionalServiceInformation.isForWebAuthOnly((List)asis)) {
                return false;
            }
            List qualifiers = trustedService.getCapturedQualifiers();
            if (ServiceQualification.isQcForEseal((List)qualifiers) || ServiceQualification.isQcForWSA((List)qualifiers)) {
                return false;
            }
        }
        return true;
    }
}

