/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.diagnostic.OrphanTokenWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.SignerDataWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestampedObject;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.vpfswatsp.POE;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class POEExtraction {
    private final Map<String, List<POE>> poeMap = new HashMap<String, List<POE>>();

    public void init(DiagnosticData diagnosticData, Date controlTime) {
        POE controlTimePoe = new POE(controlTime);
        for (SignatureWrapper signature : diagnosticData.getAllSignatures()) {
            this.addPOE(signature.getId(), controlTimePoe);
        }
        for (TimestampWrapper timestamp : diagnosticData.getTimestampList()) {
            this.addPOE(timestamp.getId(), controlTimePoe);
        }
        for (CertificateWrapper certificate : diagnosticData.getUsedCertificates()) {
            this.addPOE(certificate.getId(), controlTimePoe);
        }
        for (RevocationWrapper revocation : diagnosticData.getAllRevocationData()) {
            this.addPOE(revocation.getId(), controlTimePoe);
        }
        for (SignerDataWrapper signerData : diagnosticData.getAllSignerDocuments()) {
            this.addPOE(signerData.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanCertificate : diagnosticData.getAllOrphanCertificateObjects()) {
            this.addPOE(orphanCertificate.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanCertificateRef : diagnosticData.getAllOrphanCertificateReferences()) {
            this.addPOE(orphanCertificateRef.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanRevocation : diagnosticData.getAllOrphanRevocationObjects()) {
            this.addPOE(orphanRevocation.getId(), controlTimePoe);
        }
        for (OrphanTokenWrapper orphanRevocationRef : diagnosticData.getAllOrphanRevocationReferences()) {
            this.addPOE(orphanRevocationRef.getId(), controlTimePoe);
        }
    }

    public void collectAllPOE(Collection<TimestampWrapper> timestamps) {
        for (TimestampWrapper timestamp : timestamps) {
            this.extractPOE(timestamp);
        }
    }

    public void extractPOE(TimestampWrapper timestamp) {
        List timestampedObjects;
        if (timestamp.isMessageImprintDataFound() && timestamp.isMessageImprintDataIntact() && Utils.isCollectionNotEmpty((Collection)(timestampedObjects = timestamp.getTimestampedObjects()))) {
            POE poe = new POE(timestamp);
            for (XmlTimestampedObject xmlTimestampedObject : timestampedObjects) {
                this.addPOE(xmlTimestampedObject.getToken().getId(), poe);
            }
        }
    }

    private void addPOE(String tokenId, POE proofOfExistence) {
        if (proofOfExistence != null) {
            List poesById = this.poeMap.computeIfAbsent(tokenId, k -> new ArrayList());
            poesById.add(proofOfExistence);
        }
    }

    public void addSignaturePOE(SignatureWrapper signature, POE proofOfExistence) {
        if (signature != null) {
            this.addPOE(signature.getId(), proofOfExistence);
        }
    }

    public boolean isPOEExists(String tokenId, Date controlTime) {
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            for (POE poe : poes) {
                if (poe.getTime().compareTo(controlTime) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPOEExistInRange(String tokenId, Date notBefore, Date notAfter) {
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            for (POE poe : poes) {
                if (poe.getTime().compareTo(notBefore) < 0 || poe.getTime().compareTo(notAfter) > 0) continue;
                return true;
            }
        }
        return false;
    }

    public Date getLowestPOETime(String tokenId) {
        return this.getLowestPOE(tokenId).getTime();
    }

    public POE getLowestPOE(String tokenId) {
        POE lowestPOE = null;
        List<POE> poes = this.poeMap.get(tokenId);
        if (poes != null) {
            POEComparator comparator = new POEComparator();
            for (POE poe : poes) {
                if (lowestPOE != null && !comparator.before(poe, lowestPOE)) continue;
                lowestPOE = poe;
            }
        }
        return lowestPOE;
    }
}

