/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.QCType;
import eu.europa.esig.dss.enumerations.QCTypeEnum;
import eu.europa.esig.dss.utils.Utils;
import java.util.Collection;
import java.util.List;

public final class QCTypeIdentifiers {
    private QCTypeIdentifiers() {
    }

    public static boolean isQCTypeEsign(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, (QCType)QCTypeEnum.QCT_ESIGN);
    }

    public static boolean isQCTypeEseal(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, (QCType)QCTypeEnum.QCT_ESEAL);
    }

    public static boolean isQCTypeWeb(CertificateWrapper certificate) {
        return QCTypeIdentifiers.hasQCTypeOID(certificate, (QCType)QCTypeEnum.QCT_WEB);
    }

    private static boolean hasQCTypeOID(CertificateWrapper certificate, QCType qcType) {
        List qcTypes = certificate.getQcTypes();
        if (Utils.isCollectionNotEmpty((Collection)qcTypes)) {
            return qcTypes.contains(qcType);
        }
        return false;
    }
}

