/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ted.eforms.sdk;

import eu.europa.ted.eforms.sdk.component.SdkComponentFactory;
import eu.europa.ted.eforms.sdk.component.SdkComponentType;
import eu.europa.ted.efx.interfaces.MarkupGenerator;
import eu.europa.ted.efx.interfaces.ScriptGenerator;
import eu.europa.ted.efx.interfaces.SymbolResolver;
import eu.europa.ted.efx.interfaces.TranslatorOptions;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ComponentFactory
extends SdkComponentFactory {
    public static final ComponentFactory INSTANCE = new ComponentFactory();
    private static final Map<VersionQualifier, SymbolResolver> instances = new HashMap<VersionQualifier, SymbolResolver>();

    private ComponentFactory() {
    }

    public static SymbolResolver getSymbolResolver(String string, Path path) throws InstantiationException {
        return ComponentFactory.getSymbolResolver(string, "", path);
    }

    public static SymbolResolver getSymbolResolver(String string, String string2, Path path) throws InstantiationException {
        ComponentFactory componentFactory = INSTANCE;
        Objects.requireNonNull(componentFactory);
        VersionQualifier versionQualifier2 = componentFactory.new VersionQualifier(string, string2);
        return instances.computeIfAbsent(versionQualifier2, versionQualifier -> {
            try {
                return (SymbolResolver)INSTANCE.getComponentImpl(string, SdkComponentType.SYMBOL_RESOLVER, string2, SymbolResolver.class, new Object[]{string, path});
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(MessageFormat.format("Failed to instantiate SDK Symbol Resolver for SDK version [{0}]", string), instantiationException);
            }
        });
    }

    public static MarkupGenerator getMarkupGenerator(String string, TranslatorOptions translatorOptions) throws InstantiationException {
        return ComponentFactory.getMarkupGenerator(string, "", translatorOptions);
    }

    public static MarkupGenerator getMarkupGenerator(String string, String string2, TranslatorOptions translatorOptions) throws InstantiationException {
        return (MarkupGenerator)INSTANCE.getComponentImpl(string, SdkComponentType.MARKUP_GENERATOR, string2, MarkupGenerator.class, new Object[]{translatorOptions});
    }

    public static ScriptGenerator getScriptGenerator(String string, TranslatorOptions translatorOptions) throws InstantiationException {
        return ComponentFactory.getScriptGenerator(string, "", translatorOptions);
    }

    public static ScriptGenerator getScriptGenerator(String string, String string2, TranslatorOptions translatorOptions) throws InstantiationException {
        return (ScriptGenerator)INSTANCE.getComponentImpl(string, SdkComponentType.SCRIPT_GENERATOR, string2, ScriptGenerator.class, new Object[]{translatorOptions});
    }

    class VersionQualifier {
        private final String sdkVersion;
        private final String qualifier;

        VersionQualifier(String string, String string2) {
            this.sdkVersion = string;
            this.qualifier = string2;
        }

        public int hashCode() {
            return Objects.hash(this.sdkVersion, this.qualifier);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            VersionQualifier versionQualifier = (VersionQualifier)object;
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)versionQualifier.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.sdkVersion, versionQualifier.sdkVersion) && Objects.equals(this.qualifier, versionQualifier.qualifier);
        }

        private ComponentFactory getEnclosingInstance() {
            return ComponentFactory.this;
        }
    }
}

